/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.handshake;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.yoGraphics.RemoteYoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.RemoteYoGraphicFactory;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.robotDataLogger.Handshake;
import us.ihmc.robotDataLogger.HandshakeFileType;
import us.ihmc.robotDataLogger.handshake.IDLYoVariableHandshakeParser;
import us.ihmc.robotDataLogger.handshake.ProtoBufferYoVariableHandshakeParser;
import us.ihmc.robotDataLogger.jointState.JointState;
import us.ihmc.yoVariables.euclid.referenceFrame.interfaces.FrameIndexMap;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoVariable;

public abstract class YoVariableHandshakeParser {
    private final RemoteYoGraphicFactory yoGraphicFactory = new RemoteYoGraphicFactory();
    protected final YoGraphicsListRegistry yoGraphicsListRegistry = new YoGraphicsListRegistry();
    protected final ArrayList<JointState> jointStates = new ArrayList();
    protected double dt;
    protected int stateVariables;
    protected int numberOfVariables;
    protected int numberOfJointStateVariables;
    protected List<YoRegistry> registries = new ArrayList<YoRegistry>();
    protected List<YoVariable> variables = new ArrayList<YoVariable>();
    protected FrameIndexMap frameIndexMap;

    public static YoVariableHandshakeParser create(HandshakeFileType type) {
        if (type == null) {
            System.err.println("Handshake file type is null. Defaulting to PROTOBUFFER");
            type = HandshakeFileType.PROTOBUFFER;
        }
        switch (type) {
            case IDL_CDR: 
            case IDL_YAML: {
                return new IDLYoVariableHandshakeParser(type);
            }
            case PROTOBUFFER: {
                return new ProtoBufferYoVariableHandshakeParser();
            }
        }
        throw new RuntimeException("Not implemented");
    }

    public static int getNumberOfStateVariables(HandshakeFileType type, byte[] data) throws IOException {
        YoVariableHandshakeParser parser = YoVariableHandshakeParser.create(type);
        parser.parseFrom(data);
        return parser.getNumberOfStates();
    }

    public abstract void parseFrom(Handshake var1) throws IOException;

    public abstract void parseFrom(byte[] var1) throws IOException;

    public YoRegistry getRootRegistry() {
        return this.registries.get(0);
    }

    public FrameIndexMap getFrameIndexMap() {
        return this.frameIndexMap;
    }

    public List<YoRegistry> getRegistries() {
        return Collections.unmodifiableList(this.registries);
    }

    public List<JointState> getJointStates() {
        return Collections.unmodifiableList(this.jointStates);
    }

    public List<YoVariable> getYoVariablesList() {
        return Collections.unmodifiableList(this.variables);
    }

    public YoGraphicsListRegistry getYoGraphicsListRegistry() {
        return this.yoGraphicsListRegistry;
    }

    public double getDt() {
        return this.dt;
    }

    public int getBufferSize() {
        return this.stateVariables * 8;
    }

    public int getNumberOfStates() {
        return this.stateVariables;
    }

    public int getNumberOfVariables() {
        return this.numberOfVariables;
    }

    public int getNumberOfJointStateVariables() {
        return this.numberOfJointStateVariables;
    }

    protected RemoteYoGraphic yoGraphicFromMessage(int registrationID, String name, YoVariable[] vars, double[] consts, AppearanceDefinition appearance) {
        return this.yoGraphicFactory.yoGraphicFromMessage(registrationID, name, vars, consts, appearance);
    }
}

