/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger;

import java.io.IOException;
import us.ihmc.idl.CDR;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;
import us.ihmc.robotDataLogger.Host;
import us.ihmc.robotDataLogger.HostPubSubType;
import us.ihmc.robotDataLogger.StaticHostList;

public class StaticHostListPubSubType
implements TopicDataType<StaticHostList> {
    public static final String name = "us::ihmc::robotDataLogger::StaticHostList";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public void serialize(StaticHostList data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        StaticHostListPubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, StaticHostList data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        StaticHostListPubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return StaticHostListPubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (int i0 = 0; i0 < 128; ++i0) {
            current_alignment += HostPubSubType.getMaxCdrSerializedSize(current_alignment);
        }
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(StaticHostList data) {
        return StaticHostListPubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(StaticHostList data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (int i0 = 0; i0 < data.getHosts().size(); ++i0) {
            current_alignment += HostPubSubType.getCdrSerializedSize((Host)((Object)data.getHosts().get(i0)), current_alignment);
        }
        return current_alignment - initial_alignment;
    }

    public static void write(StaticHostList data, CDR cdr) {
        if (data.getHosts().size() > 128) {
            throw new RuntimeException("hosts field exceeds the maximum length");
        }
        cdr.write_type_e(data.getHosts());
    }

    public static void read(StaticHostList data, CDR cdr) {
        cdr.read_type_e(data.getHosts());
    }

    public final void serialize(StaticHostList data, InterchangeSerializer ser) {
        ser.write_type_e("hosts", data.getHosts());
    }

    public final void deserialize(InterchangeSerializer ser, StaticHostList data) {
        ser.read_type_e("hosts", data.getHosts());
    }

    public static void staticCopy(StaticHostList src, StaticHostList dest) {
        dest.set(src);
    }

    public StaticHostList createData() {
        return new StaticHostList();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)StaticHostListPubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(StaticHostList data, CDR cdr) {
        StaticHostListPubSubType.write(data, cdr);
    }

    public void deserialize(StaticHostList data, CDR cdr) {
        StaticHostListPubSubType.read(data, cdr);
    }

    public void copy(StaticHostList src, StaticHostList dest) {
        StaticHostListPubSubType.staticCopy(src, dest);
    }

    public StaticHostListPubSubType newInstance() {
        return new StaticHostListPubSubType();
    }
}

