/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.utils;

import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Collections;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.robotDataLogger.util.SocketUtils;

public class SocketUtilsTest {
    private NetworkInterface networkInterface;
    private InetAddress validAddress;
    int port = 54321;

    @BeforeEach
    public void setUp() throws Exception {
        for (NetworkInterface ni : Collections.list(NetworkInterface.getNetworkInterfaces())) {
            if (!ni.isUp() || ni.isLoopback() || !ni.getInetAddresses().hasMoreElements()) continue;
            this.networkInterface = ni;
            this.validAddress = ni.getInetAddresses().nextElement();
            break;
        }
    }

    @Test
    public void testUDPPortIsAvailable() {
        boolean inUse = SocketUtils.isUDPPortInUse((NetworkInterface)this.networkInterface, (int)this.port);
        Assertions.assertFalse((boolean)inUse, (String)"Port should be available, but was reported as in use");
    }

    @Test
    public void testUDPPortIsInUse() throws Exception {
        try (DatagramSocket socket = new DatagramSocket(this.port, this.validAddress);){
            boolean inUse = SocketUtils.isUDPPortInUse((NetworkInterface)this.networkInterface, (int)this.port);
            Assertions.assertTrue((boolean)inUse, (String)"Port should be in use, but was reported as available");
        }
    }
}

