/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataCommunication;

import java.io.IOException;
import java.io.InputStream;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.commons.time.Stopwatch;
import us.ihmc.robotDataLogger.RobotVisualizer;
import us.ihmc.robotDataLogger.YoVariableServer;
import us.ihmc.robotDataLogger.logger.DataServerSettings;
import us.ihmc.robotDataLogger.util.JVMStatisticsGenerator;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.parameters.XmlParameterReader;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoVariableUpdatesTest {
    private XmlParameterReader parameterReader;
    private final YoRegistry registry = new YoRegistry("YoVariableUpdatesTest");
    private final YoInteger timeout = new YoInteger("timeout", this.registry);
    private final YoDouble variableDoubleOne = new YoDouble("variableDoubleOne", this.registry);
    private final YoDouble variableDoubleTwo = new YoDouble("variableDoubleTwo", this.registry);
    private final YoInteger variableIntegerThree = new YoInteger("variableIntegerThree", this.registry);
    private final YoEnum<TestEnum> variableEnumFour = new YoEnum("variableEnumFour", "", this.registry, TestEnum.class, true);
    private final YoInteger echoIn = new YoInteger("echoIn", this.registry);
    private final YoInteger echoOut = new YoInteger("echoOut", this.registry);
    private final YoBoolean startVariableSummary = new YoBoolean("startVariableSummary", this.registry);
    private final DoubleParameter parameter1 = new DoubleParameter("param1", this.registry);
    private final DoubleParameter parameter2 = new DoubleParameter("param2", this.registry);
    private final YoDouble parameter1Echo = new YoDouble("param1Echo", this.registry);
    private final YoDouble parameter2Echo = new YoDouble("param2Echo", this.registry);
    private final YoVariableServer server = new YoVariableServer(this.getClass(), null, new DataServerSettings(false), 0.001);
    private JVMStatisticsGenerator jvmStatisticsGenerator;
    private long timestamp = 0L;

    @Test
    public void testYoVariableConnections() throws IOException {
        Stopwatch timerToEndLoop = new Stopwatch();
        timerToEndLoop.start();
        this.parameterReader = new XmlParameterReader(new InputStream[]{this.getClass().getResourceAsStream("TestParameters.xml")});
        this.server.setMainRegistry(this.registry, null);
        this.jvmStatisticsGenerator = new JVMStatisticsGenerator((RobotVisualizer)this.server);
        this.server.createSummary("YoVariableUpdatesTest.startVariableSummary");
        this.server.addSummarizedVariable("YoVariableUpdatesTest.variableDoubleOne");
        this.server.addSummarizedVariable("YoVariableUpdatesTest.variableDoubleTwo");
        this.server.addSummarizedVariable((YoVariable)this.variableIntegerThree);
        this.jvmStatisticsGenerator.addVariablesToStatisticsGenerator(this.server);
        this.startVariableSummary.set(false);
        this.jvmStatisticsGenerator.start();
        this.parameterReader.readParametersInRegistry(this.registry);
        new ThreadTester(this.server).start();
        this.server.start();
        this.variableIntegerThree.set(5000);
        this.timeout.set(1);
        int i = 0;
        TestEnum[] values = new TestEnum[]{TestEnum.A, TestEnum.B, TestEnum.C, TestEnum.D};
        while (timerToEndLoop.totalElapsed() < 12.0) {
            this.variableDoubleOne.add(1.0);
            this.variableDoubleTwo.sub(1.0);
            this.variableIntegerThree.sub(1);
            if (++i >= values.length) {
                i = 0;
            }
            this.variableEnumFour.set((Enum)values[i]);
            this.echoOut.set(this.echoIn.getIntegerValue());
            this.parameter1Echo.set(this.parameter1.getValue());
            this.parameter2Echo.set(this.parameter2.getValue());
            this.server.update(this.timestamp);
            this.timestamp += Conversions.millisecondsToNanoseconds((long)1L);
            ThreadTools.sleep((long)this.timeout.getIntegerValue());
        }
        this.server.close();
    }

    static enum TestEnum {
        A,
        B,
        C,
        D;

    }

    private class ThreadTester
    extends Thread {
        private final YoRegistry registry = new YoRegistry("ThreadServer");
        private final YoDouble A = new YoDouble("A", this.registry);
        private final YoDouble B = new YoDouble("B", this.registry);
        private final YoDouble C = new YoDouble("C", this.registry);
        private final YoEnum<TestEnum> echoThreadIn = new YoEnum("echoThreadIn", this.registry, TestEnum.class, false);
        private final YoEnum<TestEnum> echoThreadOut = new YoEnum("echoThreadOut", this.registry, TestEnum.class, false);
        private final DoubleParameter param1 = new DoubleParameter("threadParam1", this.registry);
        private final DoubleParameter param2 = new DoubleParameter("threadParam2", this.registry);
        private final YoDouble param1Echo = new YoDouble("threadParam1Echo", this.registry);
        private final YoDouble param2Echo = new YoDouble("threadParam2Echo", this.registry);

        public ThreadTester(YoVariableServer server) {
            server.addRegistry(this.registry, null);
            YoVariableUpdatesTest.this.parameterReader.readParametersInRegistry(this.registry);
        }

        @Override
        public void run() {
            while (true) {
                this.A.set(this.A.getDoubleValue() + 0.5);
                this.B.set(this.B.getDoubleValue() - 0.5);
                this.C.set(this.C.getDoubleValue() * 2.0);
                this.echoThreadOut.set((Enum)((TestEnum)this.echoThreadIn.getEnumValue()));
                this.param1Echo.set(this.param1.getValue());
                this.param2Echo.set(this.param2.getValue());
                YoVariableUpdatesTest.this.server.update(YoVariableUpdatesTest.this.timestamp, this.registry);
                ThreadTools.sleep((long)10L);
            }
        }
    }
}

