/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.compression;

import java.nio.ByteBuffer;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.tools.compression.LZ4CompressionImplementation;

public class LZ4CompressionImplementationTest {
    int ELEMENTS = 1024;
    Random random = new Random(1234L);

    @Test
    public void testLZ4DataDirectBuffer() {
        LZ4CompressionImplementation impl = new LZ4CompressionImplementation();
        ByteBuffer data = ByteBuffer.allocate(this.ELEMENTS * 4);
        for (int i = 0; i < this.ELEMENTS; ++i) {
            data.putInt(this.random.nextInt());
        }
        ByteBuffer target = ByteBuffer.allocateDirect(impl.maxCompressedLength(this.ELEMENTS * 4));
        for (int i = 0; i < 6; ++i) {
            data.clear();
            target.clear();
            impl.compress(data, target);
        }
    }

    @Test
    public void testLZ4DataBuffer() {
        LZ4CompressionImplementation impl = new LZ4CompressionImplementation();
        ByteBuffer data = ByteBuffer.allocate(this.ELEMENTS * 4);
        for (int i = 0; i < this.ELEMENTS; ++i) {
            data.putInt(this.random.nextInt());
        }
        ByteBuffer target = ByteBuffer.allocateDirect(impl.maxCompressedLength(this.ELEMENTS * 4));
        for (int i = 0; i < 6; ++i) {
            data.clear();
            target.clear();
            impl.compress(data, target);
        }
    }

    @Test
    public void testLength() {
        LZ4CompressionImplementation impl = new LZ4CompressionImplementation();
        Random random = new Random(12597651L);
        for (int i = 0; i < 1000; ++i) {
            int max;
            int min;
            int test = random.nextInt(65000);
            Assertions.assertTrue((test == (min = impl.minimumDecompressedLength(max = impl.maxCompressedLength(test))) || test - 1 == min ? 1 : 0) != 0, (String)("Got: " + min + ", expected " + test + " or " + test + "-1"));
        }
    }
}

