/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.compression;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.tools.compression.SnappyUtils;

public class SnappyUtilsTest {
    private final Random rand = new Random(98753244356L);

    @Test
    public void testIllegalArgumentException() {
        boolean failure = false;
        int elements = 1024;
        ByteBuffer data = ByteBuffer.allocate(elements);
        ByteBuffer dataCompressed = ByteBuffer.allocate(SnappyUtils.maxCompressedLength((int)data.remaining()) - 1);
        for (int i = 0; i < 24; ++i) {
            for (int j = 0; j < elements / 4; ++j) {
                data.putInt(this.rand.nextInt());
            }
            data.flip();
            try {
                SnappyUtils.compress((ByteBuffer)data, (ByteBuffer)dataCompressed);
            }
            catch (Exception e) {
                failure = true;
            }
            Assertions.assertTrue((boolean)failure);
        }
    }

    @Test
    public void testDirectByteBuffers() throws IOException {
        int elements = 128 + this.rand.nextInt(128);
        int dataOffset = this.rand.nextInt(128);
        int compressedOffset = this.rand.nextInt(128);
        int decompressOffset = this.rand.nextInt(128);
        ByteBuffer data = ByteBuffer.allocateDirect(elements * 4 + dataOffset);
        ByteBuffer compressed = ByteBuffer.allocateDirect(SnappyUtils.maxCompressedLength((int)data.remaining()) + compressedOffset);
        ByteBuffer decompress = ByteBuffer.allocateDirect(elements * 4 + decompressOffset);
        this.testCompression(elements, data, dataOffset, compressed, compressedOffset, decompress, decompressOffset);
    }

    @Test
    public void testDirectData() throws IOException {
        int elements = 128 + this.rand.nextInt(128);
        int dataOffset = this.rand.nextInt(128);
        int compressedOffset = this.rand.nextInt(128);
        int decompressOffset = this.rand.nextInt(128);
        ByteBuffer data = ByteBuffer.allocateDirect(elements * 4 + dataOffset);
        ByteBuffer compressed = ByteBuffer.allocate(SnappyUtils.maxCompressedLength((int)data.remaining()) + compressedOffset);
        ByteBuffer decompress = ByteBuffer.allocate(elements * 4 + decompressOffset);
        this.testCompression(elements, data, dataOffset, compressed, compressedOffset, decompress, decompressOffset);
    }

    @Test
    public void testDirectCompressed() throws IOException {
        int elements = 128 + this.rand.nextInt(128);
        int dataOffset = this.rand.nextInt(128);
        int compressedOffset = this.rand.nextInt(128);
        int decompressOffset = this.rand.nextInt(128);
        ByteBuffer data = ByteBuffer.allocate(elements * 4 + dataOffset);
        ByteBuffer compressed = ByteBuffer.allocateDirect(SnappyUtils.maxCompressedLength((int)data.remaining()) + compressedOffset);
        ByteBuffer decompress = ByteBuffer.allocate(elements * 4 + decompressOffset);
        this.testCompression(elements, data, dataOffset, compressed, compressedOffset, decompress, decompressOffset);
    }

    @Test
    public void testDirectDecompressed() throws IOException {
        int elements = 128 + this.rand.nextInt(128);
        int dataOffset = this.rand.nextInt(128);
        int compressedOffset = this.rand.nextInt(128);
        int decompressOffset = this.rand.nextInt(128);
        ByteBuffer data = ByteBuffer.allocate(elements * 4 + dataOffset);
        ByteBuffer compressed = ByteBuffer.allocate(SnappyUtils.maxCompressedLength((int)data.remaining()) + compressedOffset);
        ByteBuffer decompress = ByteBuffer.allocateDirect(elements * 4 + decompressOffset);
        this.testCompression(elements, data, dataOffset, compressed, compressedOffset, decompress, decompressOffset);
    }

    @Test
    public void testAllocateHeap() throws IOException {
        int elements = 128 + this.rand.nextInt(128);
        int dataOffset = this.rand.nextInt(128);
        int compressedOffset = this.rand.nextInt(128);
        int decompressOffset = this.rand.nextInt(128);
        ByteBuffer data = ByteBuffer.allocate(elements * 4 + dataOffset);
        ByteBuffer compressed = ByteBuffer.allocate(SnappyUtils.maxCompressedLength((int)data.remaining()) + compressedOffset);
        ByteBuffer decompress = ByteBuffer.allocate(elements * 4 + decompressOffset);
        this.testCompression(elements, data, dataOffset, compressed, compressedOffset, decompress, decompressOffset);
    }

    @Test
    public void testSliceBuffers() throws IOException {
        int elements = 128 + this.rand.nextInt(128);
        int dataOffset = this.rand.nextInt(128);
        int compressedOffset = this.rand.nextInt(128);
        int decompressOffset = this.rand.nextInt(128);
        int inSlice = this.rand.nextInt(128);
        int compressedSlice = this.rand.nextInt(128);
        int decompressSlice = this.rand.nextInt(128);
        ByteBuffer data = ByteBuffer.allocate(elements * 4 + dataOffset + inSlice);
        ByteBuffer compressed = ByteBuffer.allocate(SnappyUtils.maxCompressedLength((int)data.remaining()) + compressedOffset + compressedSlice);
        ByteBuffer decompress = ByteBuffer.allocate(elements * 4 + decompressOffset + decompressSlice);
        data.position(inSlice);
        data = data.slice();
        compressed.position(compressedSlice);
        compressed = compressed.slice();
        decompress.position(decompressSlice);
        decompress = decompress.slice();
        this.testCompression(elements, data, dataOffset, compressed, compressedOffset, decompress, decompressOffset);
    }

    @Test
    public void testCompressionRatio() throws IOException {
        int elements = 1024;
        ByteBuffer random = ByteBuffer.allocate(elements);
        ByteBuffer tens = ByteBuffer.allocate(elements);
        ByteBuffer randomCompressed = ByteBuffer.allocate(SnappyUtils.maxCompressedLength((int)elements));
        ByteBuffer tensCompressed = ByteBuffer.allocate(SnappyUtils.maxCompressedLength((int)elements));
        for (int i = 0; i < elements / 4; ++i) {
            random.putInt(this.rand.nextInt());
            tens.putInt(10);
        }
        random.flip();
        tens.flip();
        SnappyUtils.compress((ByteBuffer)random, (ByteBuffer)randomCompressed);
        SnappyUtils.compress((ByteBuffer)tens, (ByteBuffer)tensCompressed);
        Assertions.assertTrue((tensCompressed.position() < randomCompressed.position() ? 1 : 0) != 0);
    }

    private void testCompression(int elements, ByteBuffer data, int dataOffset, ByteBuffer compressed, int compressedOffset, ByteBuffer decompress, int decompressOffset) throws IOException {
        int i;
        data.position(dataOffset);
        compressed.position(compressedOffset);
        decompress.position(decompressOffset);
        for (i = 0; i < elements; ++i) {
            data.putInt(this.rand.nextInt());
        }
        data.flip();
        data.position(dataOffset);
        SnappyUtils.compress((ByteBuffer)data, (ByteBuffer)compressed);
        Assertions.assertEquals((int)0, (int)data.remaining());
        compressed.flip();
        compressed.position(compressedOffset);
        SnappyUtils.uncompress((ByteBuffer)compressed, (ByteBuffer)decompress);
        data.position(dataOffset);
        decompress.flip();
        decompress.position(decompressOffset);
        Assertions.assertEquals((int)(elements * 4), (int)decompress.remaining());
        for (i = 0; i < elements; ++i) {
            Assertions.assertEquals((int)data.getInt(), (int)decompress.getInt());
        }
    }
}

