/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.websocket.command;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.robotDataLogger.websocket.command.DataServerCommand;

public class DataServerCommandTest {
    @Test
    public void testMaxArgumentSize() {
        for (int i = 0; i < 4; ++i) {
            Assertions.assertTrue((DataServerCommand.MaxCommandSize() < DataServerCommand.getMaximumArgumentValue() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testStartsWith() {
        ByteBuf str = Unpooled.copiedBuffer((CharSequence)"CLEAR_LOG", (Charset)CharsetUtil.UTF_8);
        Assertions.assertTrue((boolean)DataServerCommand.CLEAR_LOG.isThisCommand(str));
        Assertions.assertTrue((boolean)DataServerCommand.CLEAR_LOG.isThisCommand(str));
        Assertions.assertFalse((boolean)DataServerCommand.START_LOG.isThisCommand(str));
        str = Unpooled.copiedBuffer((CharSequence)"NOT_CLEAR_LOG", (Charset)CharsetUtil.UTF_8);
        Assertions.assertFalse((boolean)DataServerCommand.CLEAR_LOG.isThisCommand(str));
        str.readerIndex(4);
        Assertions.assertTrue((boolean)DataServerCommand.CLEAR_LOG.isThisCommand(str));
        str = Unpooled.copiedBuffer((CharSequence)"CLEAR_LOG_GARBAGE", (Charset)CharsetUtil.UTF_8);
        Assertions.assertFalse((boolean)DataServerCommand.CLEAR_LOG.isThisCommand(str));
        str = Unpooled.copiedBuffer((CharSequence)"CLEAR_LOG_GARB", (Charset)CharsetUtil.UTF_8);
        Assertions.assertFalse((boolean)DataServerCommand.CLEAR_LOG.isThisCommand(str));
        str = Unpooled.copiedBuffer((CharSequence)"CLEAR_LOG56789", (Charset)CharsetUtil.UTF_8);
        Assertions.assertTrue((boolean)DataServerCommand.CLEAR_LOG.isThisCommand(str));
        str = Unpooled.copiedBuffer((CharSequence)"CLEAR_LOG5678", (Charset)CharsetUtil.UTF_8);
        Assertions.assertFalse((boolean)DataServerCommand.CLEAR_LOG.isThisCommand(str));
        str.writerIndex(4);
        Assertions.assertFalse((boolean)DataServerCommand.CLEAR_LOG.isThisCommand(str));
        str = Unpooled.copiedBuffer((CharSequence)"LOG_ACTIVE", (Charset)CharsetUtil.UTF_8);
        Assertions.assertFalse((boolean)DataServerCommand.LOG_ACTIVE_WITH_CAMERA.isThisCommand(str));
    }

    @Test
    public void testGetBytes() {
        ByteBuf target = Unpooled.buffer((int)DataServerCommand.MaxCommandSize());
        DataServerCommand.SEND_TIMESTAMPS.getBytes(target, 24891);
        Assertions.assertEquals((int)24891, (int)DataServerCommand.SEND_TIMESTAMPS.getArgument(target));
        Assertions.assertEquals((int)-1, (int)DataServerCommand.CLEAR_LOG.getArgument(target));
        Assertions.assertEquals((Object)"SEND_TIMESTAMPS24891", (Object)target.readCharSequence(target.readableBytes(), CharsetUtil.UTF_8));
        target = Unpooled.buffer((int)DataServerCommand.MaxCommandSize());
        DataServerCommand.SEND_TIMESTAMPS.getBytes(target, 1);
        Assertions.assertEquals((int)1, (int)DataServerCommand.SEND_TIMESTAMPS.getArgument(target));
        Assertions.assertEquals((int)-1, (int)DataServerCommand.CLEAR_LOG.getArgument(target));
        Assertions.assertEquals((Object)"SEND_TIMESTAMPS00001", (Object)target.readCharSequence(target.readableBytes(), CharsetUtil.UTF_8));
        target = Unpooled.buffer((int)DataServerCommand.MaxCommandSize());
        DataServerCommand.SEND_TIMESTAMPS.getBytes(target, 200);
        Assertions.assertEquals((int)200, (int)DataServerCommand.SEND_TIMESTAMPS.getArgument(target));
        Assertions.assertEquals((int)-1, (int)DataServerCommand.CLEAR_LOG.getArgument(target));
        Assertions.assertEquals((Object)"SEND_TIMESTAMPS00200", (Object)target.readCharSequence(target.readableBytes(), CharsetUtil.UTF_8));
        target = Unpooled.buffer((int)DataServerCommand.MaxCommandSize());
        DataServerCommand.SEND_TIMESTAMPS.getBytes(target);
        Assertions.assertEquals((int)0, (int)DataServerCommand.SEND_TIMESTAMPS.getArgument(target));
        Assertions.assertEquals((Object)"SEND_TIMESTAMPS", (Object)target.readCharSequence(target.readableBytes(), CharsetUtil.UTF_8));
        target = Unpooled.buffer((int)DataServerCommand.MaxCommandSize());
        DataServerCommand.SEND_TIMESTAMPS.getBytes(target, 0);
        Assertions.assertEquals((int)0, (int)DataServerCommand.SEND_TIMESTAMPS.getArgument(target));
        Assertions.assertEquals((Object)"SEND_TIMESTAMPS00000", (Object)target.readCharSequence(target.readableBytes(), CharsetUtil.UTF_8));
    }
}

