/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.compression;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.tools.compression.SnappyUtils;

public class SnappyUtilsTest {
    private final Random rand = new Random(98753244356L);

    @Test
    public void testDirectByteBuffers() throws IOException {
        int elements = 128 + this.rand.nextInt(128);
        int inOffset = this.rand.nextInt(128);
        int outOffset = this.rand.nextInt(128);
        int decompressOffset = this.rand.nextInt(128);
        ByteBuffer in = ByteBuffer.allocateDirect(elements * 4 + inOffset);
        ByteBuffer out = ByteBuffer.allocateDirect(SnappyUtils.maxCompressedLength((int)in.remaining()) + outOffset);
        ByteBuffer decompress = ByteBuffer.allocateDirect(elements * 4 + decompressOffset);
        this.testCompression(elements, in, inOffset, out, outOffset, decompress, decompressOffset);
    }

    @Test
    public void testDirectInput() throws IOException {
        int elements = 128 + this.rand.nextInt(128);
        int inOffset = this.rand.nextInt(128);
        int outOffset = this.rand.nextInt(128);
        int decompressOffset = this.rand.nextInt(128);
        ByteBuffer in = ByteBuffer.allocateDirect(elements * 4 + inOffset);
        ByteBuffer out = ByteBuffer.allocate(SnappyUtils.maxCompressedLength((int)in.remaining()) + outOffset);
        ByteBuffer decompress = ByteBuffer.allocate(elements * 4 + decompressOffset);
        this.testCompression(elements, in, inOffset, out, outOffset, decompress, decompressOffset);
    }

    @Test
    public void testDirectOutput() throws IOException {
        int elements = 128 + this.rand.nextInt(128);
        int inOffset = this.rand.nextInt(128);
        int outOffset = this.rand.nextInt(128);
        int decompressOffset = this.rand.nextInt(128);
        ByteBuffer in = ByteBuffer.allocate(elements * 4 + inOffset);
        ByteBuffer out = ByteBuffer.allocateDirect(SnappyUtils.maxCompressedLength((int)in.remaining()) + outOffset);
        ByteBuffer decompress = ByteBuffer.allocate(elements * 4 + decompressOffset);
        this.testCompression(elements, in, inOffset, out, outOffset, decompress, decompressOffset);
    }

    @Test
    public void testDirectCompressed() throws IOException {
        int elements = 128 + this.rand.nextInt(128);
        int inOffset = this.rand.nextInt(128);
        int outOffset = this.rand.nextInt(128);
        int decompressOffset = this.rand.nextInt(128);
        ByteBuffer in = ByteBuffer.allocate(elements * 4 + inOffset);
        ByteBuffer out = ByteBuffer.allocate(SnappyUtils.maxCompressedLength((int)in.remaining()) + outOffset);
        ByteBuffer decompress = ByteBuffer.allocateDirect(elements * 4 + decompressOffset);
        this.testCompression(elements, in, inOffset, out, outOffset, decompress, decompressOffset);
    }

    @Test
    public void testHeap() throws IOException {
        int elements = 128 + this.rand.nextInt(128);
        int inOffset = this.rand.nextInt(128);
        int outOffset = this.rand.nextInt(128);
        int decompressOffset = this.rand.nextInt(128);
        ByteBuffer in = ByteBuffer.allocate(elements * 4 + inOffset);
        ByteBuffer out = ByteBuffer.allocate(SnappyUtils.maxCompressedLength((int)in.remaining()) + outOffset);
        ByteBuffer decompress = ByteBuffer.allocate(elements * 4 + decompressOffset);
        this.testCompression(elements, in, inOffset, out, outOffset, decompress, decompressOffset);
    }

    @Test
    public void testSlice() throws IOException {
        int elements = 128 + this.rand.nextInt(128);
        int inOffset = this.rand.nextInt(128);
        int outOffset = this.rand.nextInt(128);
        int decompressOffset = this.rand.nextInt(128);
        int inSlice = this.rand.nextInt(128);
        int outSlice = this.rand.nextInt(128);
        int decompressSlice = this.rand.nextInt(128);
        ByteBuffer in = ByteBuffer.allocate(elements * 4 + inOffset + inSlice);
        ByteBuffer out = ByteBuffer.allocate(SnappyUtils.maxCompressedLength((int)in.remaining()) + outOffset + outSlice);
        ByteBuffer decompress = ByteBuffer.allocate(elements * 4 + decompressOffset + decompressSlice);
        in.position(inSlice);
        in = in.slice();
        out.position(outSlice);
        out = out.slice();
        decompress.position(decompressSlice);
        decompress = decompress.slice();
        this.testCompression(elements, in, inOffset, out, outOffset, decompress, decompressOffset);
    }

    @Test
    public void testCompressionRatio() throws IOException {
        int elements = 1024;
        ByteBuffer random = ByteBuffer.allocate(elements);
        ByteBuffer tens = ByteBuffer.allocate(elements);
        ByteBuffer randomOut = ByteBuffer.allocate(SnappyUtils.maxCompressedLength((int)elements));
        ByteBuffer tensOut = ByteBuffer.allocate(SnappyUtils.maxCompressedLength((int)elements));
        for (int i = 0; i < elements / 4; ++i) {
            random.putInt(this.rand.nextInt());
            tens.putInt(10);
        }
        random.flip();
        tens.flip();
        SnappyUtils.compress((ByteBuffer)random, (ByteBuffer)randomOut);
        SnappyUtils.compress((ByteBuffer)tens, (ByteBuffer)tensOut);
        Assertions.assertTrue((tensOut.position() < randomOut.position() ? 1 : 0) != 0);
    }

    private void testCompression(int elements, ByteBuffer in, int inOffset, ByteBuffer out, int outOffset, ByteBuffer decompress, int decompressOffset) throws IOException {
        int i;
        in.position(inOffset);
        out.position(outOffset);
        decompress.position(decompressOffset);
        for (i = 0; i < elements; ++i) {
            in.putInt(this.rand.nextInt());
        }
        in.flip();
        in.position(inOffset);
        SnappyUtils.compress((ByteBuffer)in, (ByteBuffer)out);
        Assertions.assertEquals((int)0, (int)in.remaining());
        out.flip();
        out.position(outOffset);
        SnappyUtils.uncompress((ByteBuffer)out, (ByteBuffer)decompress);
        in.position(inOffset);
        decompress.flip();
        decompress.position(decompressOffset);
        Assertions.assertEquals((int)(elements * 4), (int)decompress.remaining());
        for (i = 0; i < elements; ++i) {
            Assertions.assertEquals((int)in.getInt(), (int)decompress.getInt());
        }
    }
}

