/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.types;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.commons.lang3.NotImplementedException;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import us.ihmc.idl.CDR;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;

public class ByteBufferPubSubType
implements TopicDataType<ByteBuffer>,
AutoCloseable {
    private final String name;
    private final int maxSize;
    private final String userName;
    private final int userMaxSize;
    @Nullable
    private Pointer dataPointer;

    private static int align(int size) {
        int adv = size % 4;
        if (adv != 0) {
            size += 4 - adv;
        }
        return size;
    }

    public ByteBufferPubSubType(String name, int maxSize) {
        this.userName = name;
        this.userMaxSize = maxSize;
        this.maxSize = CDR.getTypeSize(ByteBufferPubSubType.align(maxSize)) + 4;
        this.name = name + "::" + this.maxSize;
    }

    @Override
    public void serialize(ByteBuffer data, SerializedPayload serializedPayload) throws IOException {
        if (CDR.getTypeSize(data.remaining() + 4) > this.maxSize) {
            throw new IOException("Data size is larger than the maximum size");
        }
        CDR.writeEncapsulation(serializedPayload);
        ByteBuffer target = serializedPayload.getData();
        target.putInt(data.remaining());
        target.put(data);
        serializedPayload.setLength(ByteBufferPubSubType.align(target.position()));
    }

    @Override
    public void deserialize(SerializedPayload serializedPayload, ByteBuffer data) throws IOException {
        CDR.readEncapsulation(serializedPayload);
        ByteBuffer src = serializedPayload.getData();
        int length = src.getInt();
        if (length > data.remaining()) {
            throw new IOException("ByteBuffer data does not have enough space remaining to accept the incoming message.");
        }
        for (int i = 0; i < length; ++i) {
            data.put(src.get());
        }
    }

    @Override
    public int getTypeSize() {
        return this.maxSize;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ByteBuffer createData() {
        this.dataPointer = new BytePointer((long)this.maxSize);
        Pointer.memset((Pointer)this.dataPointer, (int)0, (long)((long)this.dataPointer.sizeof() * (long)this.maxSize));
        return this.dataPointer.asByteBuffer();
    }

    @Override
    public TopicDataType<ByteBuffer> newInstance() {
        return new ByteBufferPubSubType(this.userName, this.userMaxSize);
    }

    @Override
    public void serialize(ByteBuffer data, CDR cdr) {
        throw new NotImplementedException("Nested serializer is not implemented for bytebuffer pub/sub type");
    }

    @Override
    public void deserialize(ByteBuffer data, CDR cdr) {
        throw new NotImplementedException("Nested serializer is not implemented for bytebuffer pub/sub type");
    }

    @Override
    public void copy(ByteBuffer src, ByteBuffer dest) {
        throw new NotImplementedException("Copy is not implemented for bytebuffer pub/sub type");
    }

    @Override
    public void serialize(ByteBuffer data, InterchangeSerializer serializer) {
        throw new NotImplementedException("Interchange serializer is not implemented for bytebuffer pub/sub type");
    }

    @Override
    public void deserialize(InterchangeSerializer serializer, ByteBuffer data) {
        throw new NotImplementedException("Interchange serializer is not implemented for bytebuffer pub/sub type");
    }

    @Override
    public void close() {
        if (this.dataPointer != null) {
            this.dataPointer.close();
        }
    }
}

