/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.common;

public class Time {
    public static final Time Infinite = new Time(Integer.MAX_VALUE, -1L);
    public static final Time Zero = new Time(0, 0L);
    public static final Time Invalid = new Time(-1, -1L);
    private int seconds;
    private long nsec;

    public Time(int seconds, long nsec) {
        this.seconds = seconds;
        this.nsec = nsec;
    }

    public Time() {
    }

    public void set(long nanoseconds) {
        this.seconds = (int)(nanoseconds / 1000000000L);
        this.nsec = nanoseconds % 1000000000L;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public void setSeconds(int seconds) {
        this.seconds = seconds;
    }

    public void setNanoseconds(long nsec) {
        this.nsec = nsec;
    }

    public long getNanoseconds() {
        return this.nsec;
    }

    public String toString() {
        return String.format("%.2f", (double)this.seconds + (double)this.nsec / 1.0E9);
    }

    public void set(Time sourceTimestamp) {
        this.seconds = sourceTimestamp.seconds;
        this.nsec = sourceTimestamp.nsec;
    }
}

