/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.common;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;

public class SerializedPayload
implements AutoCloseable {
    public static final short CDR_BE = 0;
    public static final short CDR_LE = 1;
    public static final short PL_CDR_BE = 2;
    public static final short PL_CDR_LE = 3;
    private short encapsulation;
    private int length;
    private final Pointer dataPointer;
    private final ByteBuffer data;
    private int max_size;
    private int pos;

    public SerializedPayload(int maxSize) {
        this.max_size = maxSize;
        this.dataPointer = new BytePointer((long)maxSize);
        Pointer.memset((Pointer)this.dataPointer, (int)0, (long)((long)this.dataPointer.sizeof() * (long)maxSize));
        this.data = this.dataPointer.asByteBuffer();
        this.setEncapsulation((short)1);
    }

    public short getEncapsulation() {
        return this.encapsulation;
    }

    public void setEncapsulation(short encapsulation) {
        this.encapsulation = encapsulation;
        if (encapsulation == 0 || encapsulation == 2) {
            this.data.order(ByteOrder.BIG_ENDIAN);
        } else {
            this.data.order(ByteOrder.LITTLE_ENDIAN);
        }
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getMax_size() {
        return this.max_size;
    }

    public int getPos() {
        return this.pos;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    @Override
    public void close() {
        this.dataPointer.close();
    }
}

