/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.impl.fastRTPS;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import us.ihmc.idl.CDR;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.SubscriberAttributes;
import us.ihmc.pubsub.common.ChangeKind;
import us.ihmc.pubsub.common.Guid;
import us.ihmc.pubsub.common.MatchingInfo;
import us.ihmc.pubsub.common.SampleIdentity;
import us.ihmc.pubsub.common.SampleInfo;
import us.ihmc.pubsub.common.SerializedPayload;
import us.ihmc.pubsub.common.Time;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.pubsub.subscriber.SubscriberListener;
import us.ihmc.rtps.impl.fastRTPS.NativeParticipantImpl;
import us.ihmc.rtps.impl.fastRTPS.NativeSubscriberImpl;
import us.ihmc.rtps.impl.fastRTPS.NativeSubscriberListener;
import us.ihmc.rtps.impl.fastRTPS.SampleInfoMarshaller;

public class FastRTPSSubscriber<T>
implements Subscriber<T> {
    private final Object readLock = new Object();
    private final AtomicBoolean deleted = new AtomicBoolean();
    private NativeSubscriberImpl impl;
    private final SubscriberAttributes attributes;
    private final TopicDataType<T> topicDataType;
    private final SubscriberListener<T> listener;
    private final SerializedPayload payload;
    private final Guid guid = new Guid();
    private final MatchingInfo matchingInfo = new MatchingInfo();
    private final SampleInfoMarshaller sampleInfoMarshaller = new SampleInfoMarshaller();
    private final Pointer keyBufferPointer = new BytePointer(16L);
    private final ByteBuffer keyBuffer = this.keyBufferPointer.asByteBuffer();
    private final NativeSubscriberListenerImpl nativeListenerImpl = new NativeSubscriberListenerImpl();
    private boolean hasMatched = false;
    private boolean isRemoved = false;
    private long numberOfReceivedMessages = 0L;
    private long largestMessageSize = 0L;
    private long currentMessageSize = 0L;
    private long cumulativePayloadBytes = 0L;

    private void preparePayload(short encapsulation, int dataLength) {
        this.payload.getData().clear();
        this.payload.setEncapsulation(encapsulation);
        if (CDR.getTypeSize(dataLength) <= this.payload.getMax_size()) {
            dataLength = CDR.getTypeSize(dataLength);
        }
        this.payload.setLength(dataLength);
        this.payload.getData().limit(dataLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FastRTPSSubscriber(TopicDataType<T> topicDataTypeIn, SubscriberAttributes attrs, SubscriberListener<T> listener, NativeParticipantImpl participantImpl) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            this.attributes = attrs;
            this.topicDataType = topicDataTypeIn.newInstance();
            this.listener = listener;
            this.payload = new SerializedPayload(this.topicDataType.getTypeSize() + 3);
            String profileName = UUID.randomUUID().toString();
            String profileXML = this.attributes.marshall(profileName);
            this.impl = new NativeSubscriberImpl(participantImpl, this.nativeListenerImpl);
            if (!this.impl.createSubscriber(profileName, profileXML, profileXML.length())) {
                throw new IOException("Cannot create subscriber with data: \n" + profileXML);
            }
            this.guid.fromPrimitives(this.impl.getGuidHigh(), this.impl.getGuidLow());
        }
    }

    @Override
    public Guid getGuid() {
        return this.guid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForUnreadMessage(int timeoutInMilliseconds) {
        Object object = this.readLock;
        synchronized (object) {
            if (this.impl == null) {
                throw new RuntimeException("This subscriber has been removed from the domain");
            }
            this.impl.waitForUnreadMessage();
        }
    }

    private void updateSampleInfo(SampleInfoMarshaller marshaller, SampleInfo info, ByteBuffer keyBuffer) {
        marshaller.getInstanceHandleValue(keyBuffer);
        keyBuffer.clear();
        info.setDataLength(marshaller.getDataLength());
        info.setOwnershipStrength(marshaller.getOwnershipStrength());
        info.setSampleKind(ChangeKind.values[marshaller.getChangeKind()]);
        Time time = info.getSourceTimestamp();
        time.setSeconds(marshaller.getTime_seconds());
        time.set(marshaller.getTime_nsec());
        SampleIdentity id = info.getSampleIdentity();
        id.getGuid().fromPrimitives(marshaller.getSampleIdentity_GuidHigh(), marshaller.getSampleIdentity_GuidLow());
        id.getSequenceNumber().set(marshaller.getSampleIdentity_sequenceNumberHigh(), marshaller.getSampleIdentity_sequenceNumberLow());
        SampleIdentity relatedId = info.getRelatedSampleIdentity();
        relatedId.getGuid().fromPrimitives(marshaller.getRelatedSampleIdentity_GuidHigh(), marshaller.getRelatedSampleIdentity_GuidLow());
        relatedId.getSequenceNumber().set(marshaller.getRelatedSampleIdentity_sequenceNumberHigh(), marshaller.getRelatedSampleIdentity_sequenceNumberLow());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean readNextData(T data, SampleInfo info) {
        if (this.deleted.get()) {
            return false;
        }
        Object object = this.readLock;
        synchronized (object) {
            if (this.impl == null) {
                System.err.println("This subscriber has been removed from the domain");
                return false;
            }
            if (this.impl.readnextData(this.payload.getData().capacity(), this.payload.getData(), this.sampleInfoMarshaller)) {
                if (info != null) {
                    this.updateSampleInfo(this.sampleInfoMarshaller, info, this.keyBuffer);
                }
                this.preparePayload(this.sampleInfoMarshaller.getEncapsulation(), this.sampleInfoMarshaller.getDataLength());
                try {
                    this.currentMessageSize = this.payload.getLength();
                    if ((long)this.payload.getLength() > this.largestMessageSize) {
                        this.largestMessageSize = this.payload.getLength();
                    }
                    this.cumulativePayloadBytes += (long)this.payload.getLength();
                    this.topicDataType.deserialize(this.payload, data);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    @Override
    public T readNextData() {
        return this.readNextData(null);
    }

    @Override
    public T readNextData(SampleInfo info) {
        T nextData = this.topicDataType.createData();
        if (this.readNextData(nextData, info)) {
            return nextData;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean takeNextData(T data, SampleInfo info) {
        if (this.deleted.get()) {
            return false;
        }
        Object object = this.readLock;
        synchronized (object) {
            if (this.impl == null) {
                System.err.println("This subscriber has been removed from the domain");
                return false;
            }
            if (this.impl.takeNextData(this.payload.getData().capacity(), this.payload.getData(), this.sampleInfoMarshaller)) {
                if (info != null) {
                    this.updateSampleInfo(this.sampleInfoMarshaller, info, this.keyBuffer);
                }
                this.preparePayload(this.sampleInfoMarshaller.getEncapsulation(), this.sampleInfoMarshaller.getDataLength());
                try {
                    this.currentMessageSize = this.payload.getLength();
                    if ((long)this.payload.getLength() > this.largestMessageSize) {
                        this.largestMessageSize = this.payload.getLength();
                    }
                    this.cumulativePayloadBytes += (long)this.payload.getLength();
                    this.topicDataType.deserialize(this.payload, data);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    @Override
    public T takeNextData() {
        return this.takeNextData(null);
    }

    @Override
    public T takeNextData(SampleInfo info) {
        T nextData = this.topicDataType.createData();
        if (this.takeNextData(nextData, info)) {
            return nextData;
        }
        return null;
    }

    @Override
    public SubscriberAttributes getAttributes() {
        return this.attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInCleanState() {
        Object object = this.readLock;
        synchronized (object) {
            if (this.impl == null) {
                throw new RuntimeException("This subscriber has been removed from the domain");
            }
            return this.impl.isInCleanState();
        }
    }

    void delete() {
        this.deleted.set(true);
        this.keyBufferPointer.close();
        this.payload.close();
        this.impl.delete();
        this.nativeListenerImpl.delete();
        this.impl = null;
        this.isRemoved = true;
    }

    TopicDataType<T> getTopicDataType() {
        return this.topicDataType;
    }

    @Override
    public boolean hasMatched() {
        return this.hasMatched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAvailable() {
        Object object = this.readLock;
        synchronized (object) {
            return this.impl != null;
        }
    }

    @Override
    public boolean isRemoved() {
        return this.isRemoved;
    }

    @Override
    public long getNumberOfReceivedMessages() {
        return this.numberOfReceivedMessages;
    }

    @Override
    public long getCurrentMessageSize() {
        return this.currentMessageSize;
    }

    @Override
    public long getLargestMessageSize() {
        return this.largestMessageSize;
    }

    @Override
    public long getCumulativePayloadBytes() {
        return this.cumulativePayloadBytes;
    }

    private class NativeSubscriberListenerImpl
    extends NativeSubscriberListener {
        private NativeSubscriberListenerImpl() {
        }

        @Override
        public void onSubscriptionMatched(int matchingStatus, long guidHigh, long guidLow) {
            try {
                if (FastRTPSSubscriber.this.listener != null) {
                    FastRTPSSubscriber.this.matchingInfo.getGuid().fromPrimitives(guidHigh, guidLow);
                    FastRTPSSubscriber.this.matchingInfo.setStatus(MatchingInfo.MatchingStatus.values[matchingStatus]);
                    FastRTPSSubscriber.this.listener.onSubscriptionMatched(FastRTPSSubscriber.this, FastRTPSSubscriber.this.matchingInfo);
                    FastRTPSSubscriber.this.hasMatched = true;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onNewDataMessage() {
            try {
                if (FastRTPSSubscriber.this.listener != null) {
                    FastRTPSSubscriber.this.listener.onNewDataMessage(FastRTPSSubscriber.this);
                }
                ++FastRTPSSubscriber.this.numberOfReceivedMessages;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

