/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.attributes;

import com.eprosima.xmlschemas.fastrtps_profiles.BuiltinAttributesType;
import com.eprosima.xmlschemas.fastrtps_profiles.Dds;
import com.eprosima.xmlschemas.fastrtps_profiles.DiscoveryProtocolType;
import com.eprosima.xmlschemas.fastrtps_profiles.DiscoveryServersListType;
import com.eprosima.xmlschemas.fastrtps_profiles.DiscoverySettingsType;
import com.eprosima.xmlschemas.fastrtps_profiles.EDPType;
import com.eprosima.xmlschemas.fastrtps_profiles.LibrarySettingsType;
import com.eprosima.xmlschemas.fastrtps_profiles.LocatorListType;
import com.eprosima.xmlschemas.fastrtps_profiles.ParticipantProfileType;
import com.eprosima.xmlschemas.fastrtps_profiles.ProfilesType;
import com.eprosima.xmlschemas.fastrtps_profiles.RemoteServerAttributesType;
import com.eprosima.xmlschemas.fastrtps_profiles.TransportDescriptorListType;
import com.eprosima.xmlschemas.fastrtps_profiles.TransportDescriptorType;
import com.eprosima.xmlschemas.fastrtps_profiles.Udpv4LocatorType;
import jakarta.xml.bind.JAXBElement;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.UUID;
import javax.xml.namespace.QName;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.attributes.DDSConversionTools;
import us.ihmc.pubsub.common.Time;
import us.ihmc.pubsub.impl.fastRTPS.FastRTPSDomain;

public class ParticipantProfile {
    private final ParticipantProfileType participantProfile = new ParticipantProfileType();
    private final TransportDescriptorListType transportDescriptors = new TransportDescriptorListType();
    private final LibrarySettingsType librarySettings = new LibrarySettingsType();
    private static final boolean FASTRTPS_SHM_AVAILABLE_ON_WINDOWS;

    public ParticipantProfile() {
        BuiltinAttributesType builtin = new BuiltinAttributesType();
        DiscoverySettingsType discoverySettingsType = new DiscoverySettingsType();
        builtin.setDiscoveryConfig(discoverySettingsType);
        this.participantProfile.setRtps(new ParticipantProfileType.Rtps());
        this.participantProfile.getRtps().setBuiltin(builtin);
        this.discoveryLeaseDuration(Time.Infinite);
        this.useIntraProcessDelivery(true);
    }

    public static ParticipantProfile create() {
        return new ParticipantProfile();
    }

    public ParticipantProfileType getProfile() {
        return this.participantProfile;
    }

    public TransportDescriptorListType getTransportDescriptors() {
        return this.transportDescriptors;
    }

    public LibrarySettingsType getLibrarySettings() {
        return this.librarySettings;
    }

    public ParticipantProfile domainId(int id) {
        this.participantProfile.setDomainId(Integer.valueOf(id));
        return this;
    }

    public int getDomainId() {
        return this.getProfile().getDomainId();
    }

    public ParticipantProfile name(String name) {
        this.participantProfile.getRtps().setName(name);
        return this;
    }

    public String getName() {
        return this.participantProfile.getRtps().getName();
    }

    public ParticipantProfile discoveryLeaseDuration(Time discoveryLeaseDuration) {
        this.participantProfile.getRtps().getBuiltin().getDiscoveryConfig().setLeaseDuration(DDSConversionTools.timeToDurationType(discoveryLeaseDuration));
        return this;
    }

    public ParticipantProfile discoveryServer(String discoveryServerAddress, int discoveryServerId) {
        return this.discoveryServer(discoveryServerAddress, discoveryServerId, 11811);
    }

    public ParticipantProfile discoveryServer(String discoveryServerAddress, int discoveryServerId, int discoveryServerPort) {
        if (discoveryServerId < 0 || discoveryServerId > 255) {
            throw new RuntimeException("Invalid discovery server ID");
        }
        if (discoveryServerPort < 0 || discoveryServerPort > 65535) {
            throw new RuntimeException("Invalid discovery server port");
        }
        DiscoverySettingsType discoverySettingsType = this.participantProfile.getRtps().getBuiltin().getDiscoveryConfig();
        discoverySettingsType.setDiscoveryProtocol(DiscoveryProtocolType.CLIENT);
        LocatorListType locatorListType = new LocatorListType();
        LocatorListType.Locator locatorType = new LocatorListType.Locator();
        Udpv4LocatorType udpv4LocatorType = new Udpv4LocatorType();
        udpv4LocatorType.setAddress(discoveryServerAddress);
        udpv4LocatorType.setPort(Integer.valueOf(discoveryServerPort));
        locatorType.getUdpv4().add(udpv4LocatorType);
        locatorListType.getLocator().add(locatorType);
        RemoteServerAttributesType remoteServerAttributes = new RemoteServerAttributesType();
        remoteServerAttributes.getContent().add(new JAXBElement(new QName("http://www.eprosima.com/XMLSchemas/fastRTPS_Profiles", "metatrafficUnicastLocatorList"), LocatorListType.class, (Object)locatorListType));
        remoteServerAttributes.setPrefix(String.format("44.53.%02X.5f.45.50.52.4f.53.49.4d.41", discoveryServerId));
        DiscoveryServersListType discoveryServerList = this.participantProfile.getRtps().getBuiltin().getDiscoveryConfig().getDiscoveryServersList();
        discoveryServerList.getRemoteServer().add(remoteServerAttributes);
        discoverySettingsType.setDiscoveryServersList(discoveryServerList);
        return this;
    }

    public ParticipantProfile addTransport(TransportDescriptorType transport) {
        boolean existsInTransportDescriptors = false;
        for (TransportDescriptorType transportDescriptorType : this.transportDescriptors.getTransportDescriptor()) {
            if (!transportDescriptorType.getTransportId().equals(transport.getTransportId())) continue;
            existsInTransportDescriptors = true;
            break;
        }
        if (!existsInTransportDescriptors) {
            this.transportDescriptors.getTransportDescriptor().add(transport);
        }
        if (this.participantProfile.getRtps().getUserTransports() == null) {
            this.participantProfile.getRtps().setUserTransports(new ParticipantProfileType.Rtps.UserTransports());
        }
        boolean existsInUserTransports = false;
        for (String transportId : this.participantProfile.getRtps().getUserTransports().getTransportId()) {
            if (!transportId.equals(transport.getTransportId())) continue;
            existsInUserTransports = true;
            break;
        }
        if (!existsInUserTransports) {
            this.participantProfile.getRtps().getUserTransports().getTransportId().add(transport.getTransportId());
        }
        return this;
    }

    public ParticipantProfile addSharedMemoryTransport() {
        TransportDescriptorType transportDescriptor = new TransportDescriptorType();
        transportDescriptor.setTransportId(UUID.randomUUID().toString());
        transportDescriptor.setType("SHM");
        this.addTransport(transportDescriptor);
        return this;
    }

    public ParticipantProfile addUDPv4Transport(InetAddress ... addressRestriction) {
        TransportDescriptorType udp4Transport = new TransportDescriptorType();
        udp4Transport.setTransportId(UUID.randomUUID().toString());
        udp4Transport.setType("UDPv4");
        if (addressRestriction != null && addressRestriction.length > 0 && addressRestriction[0] != null) {
            TransportDescriptorType.InterfaceWhiteList addressWhitelist = new TransportDescriptorType.InterfaceWhiteList();
            for (InetAddress addr : addressRestriction) {
                JAXBElement addressElement = new JAXBElement(new QName("http://www.eprosima.com/XMLSchemas/fastRTPS_Profiles", "address"), String.class, (Object)addr.getHostAddress());
                addressWhitelist.getAddressOrInterface().add(addressElement);
            }
            udp4Transport.setInterfaceWhiteList(addressWhitelist);
        }
        this.addTransport(udp4Transport);
        return this;
    }

    public ParticipantProfile useOnlySharedMemoryTransport() {
        this.useBuiltinTransports(false);
        this.useIntraProcessDelivery(false);
        if (this.participantProfile.getRtps().getUserTransports() == null) {
            this.participantProfile.getRtps().setUserTransports(new ParticipantProfileType.Rtps.UserTransports());
        }
        this.participantProfile.getRtps().getUserTransports().getTransportId().clear();
        boolean shmTransportFound = false;
        for (TransportDescriptorType transportDescriptorType : this.transportDescriptors.getTransportDescriptor()) {
            if (!transportDescriptorType.getType().equals("SHM")) continue;
            this.addTransport(transportDescriptorType);
            shmTransportFound = true;
            break;
        }
        if (!shmTransportFound) {
            this.addSharedMemoryTransport();
        }
        return this;
    }

    public ParticipantProfile useOnlyUDPv4Transport(InetAddress ... addressRestriction) {
        this.useBuiltinTransports(false);
        this.useIntraProcessDelivery(false);
        if (this.participantProfile.getRtps().getUserTransports() == null) {
            this.participantProfile.getRtps().setUserTransports(new ParticipantProfileType.Rtps.UserTransports());
        }
        this.participantProfile.getRtps().getUserTransports().getTransportId().clear();
        boolean udpv4TransportFound = false;
        for (TransportDescriptorType transportDescriptorType : this.transportDescriptors.getTransportDescriptor()) {
            if (!transportDescriptorType.getType().equals("UDPv4")) continue;
            this.addTransport(transportDescriptorType);
            udpv4TransportFound = true;
            break;
        }
        if (!udpv4TransportFound) {
            this.addUDPv4Transport(addressRestriction);
        }
        return this;
    }

    public ParticipantProfile useOnlyIntraProcessDelivery() {
        this.useBuiltinTransports(false);
        this.useIntraProcessDelivery(true);
        if (this.participantProfile.getRtps().getUserTransports() == null) {
            this.participantProfile.getRtps().setUserTransports(new ParticipantProfileType.Rtps.UserTransports());
        }
        this.participantProfile.getRtps().getUserTransports().getTransportId().clear();
        if (System.getProperty("os.name").toLowerCase().contains("win") && !FASTRTPS_SHM_AVAILABLE_ON_WINDOWS) {
            LogTools.error((String)"Shared Memory Transport (SHM) is not available (Could not write to C:\\ProgramData\\eprosima\\fastrtps_interprocess). Falling back to UDPv4 transport on the loopback address.");
            this.addUDPv4Transport(InetAddress.getLoopbackAddress());
        } else {
            this.addSharedMemoryTransport();
        }
        return this;
    }

    public ParticipantProfile useBuiltinTransports(boolean useBuiltinTransports) {
        this.participantProfile.getRtps().setUseBuiltinTransports(Boolean.valueOf(useBuiltinTransports));
        return this;
    }

    public boolean isUseBuiltinTransports() {
        return this.participantProfile.getRtps().isUseBuiltinTransports();
    }

    public ParticipantProfile useIntraProcessDelivery(boolean intraProcessDelivery) {
        this.librarySettings.setIntraprocessDelivery(intraProcessDelivery ? "FULL" : "OFF");
        return this;
    }

    public boolean isUseStaticDiscovery() {
        return this.participantProfile.getRtps().getBuiltin().getDiscoveryConfig().getEDP() == EDPType.STATIC;
    }

    public ParticipantProfile useStaticDiscovery(boolean useStaticDiscovery) {
        this.participantProfile.getRtps().getBuiltin().getDiscoveryConfig().setEDP(useStaticDiscovery ? EDPType.STATIC : EDPType.SIMPLE);
        return this;
    }

    public String marshall(String profileName) throws IOException {
        this.participantProfile.setProfileName(profileName);
        Dds dds = new Dds();
        ProfilesType profilesType = new ProfilesType();
        profilesType.getDomainparticipantFactoryOrParticipantOrDataWriter().add(this.transportDescriptors);
        profilesType.getDomainparticipantFactoryOrParticipantOrDataWriter().add(this.participantProfile);
        dds.setProfiles(profilesType);
        dds.setLibrarySettings(this.librarySettings);
        String profileXML = FastRTPSDomain.marshallProfile(dds);
        return profileXML;
    }

    static {
        File shmDir = new File("C:\\ProgramData\\eprosima\\fastrtps_interprocess");
        if (!shmDir.exists()) {
            boolean bl = shmDir.mkdirs();
        }
        FASTRTPS_SHM_AVAILABLE_ON_WINDOWS = shmDir.exists() && shmDir.canWrite();
    }
}

