/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.attributes;

import com.eprosima.xmlschemas.fastrtps_profiles.DurabilityQosKindType;
import com.eprosima.xmlschemas.fastrtps_profiles.DurabilityQosPolicyType;
import com.eprosima.xmlschemas.fastrtps_profiles.HistoryQosKindType;
import com.eprosima.xmlschemas.fastrtps_profiles.HistoryQosPolicyType;
import com.eprosima.xmlschemas.fastrtps_profiles.LifespanQosPolicyType;
import com.eprosima.xmlschemas.fastrtps_profiles.NameVectorType;
import com.eprosima.xmlschemas.fastrtps_profiles.OwnershipQosKindType;
import com.eprosima.xmlschemas.fastrtps_profiles.PartitionQosPolicyType;
import com.eprosima.xmlschemas.fastrtps_profiles.ReliabilityQosKindType;
import com.eprosima.xmlschemas.fastrtps_profiles.ReliabilityQosPolicyType;
import com.eprosima.xmlschemas.fastrtps_profiles.TopicAttributesType;
import com.eprosima.xmlschemas.fastrtps_profiles.TopicKindType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.DDSConversionTools;
import us.ihmc.pubsub.common.Time;

public abstract class CommonAttributes<T extends CommonAttributes<T>> {
    private TopicDataType<?> topicDataType;
    protected final TopicAttributesType topicAttributesType = new TopicAttributesType();
    protected final HistoryQosPolicyType historyQosPolicyType = new HistoryQosPolicyType();
    protected final DurabilityQosPolicyType durabilityQosPolicyType = new DurabilityQosPolicyType();
    protected final ReliabilityQosPolicyType reliabilityQosPolicyType = new ReliabilityQosPolicyType();
    private String humanReadableTopicName = "";
    private String humanReadableTopicDataTypeName = "";

    public CommonAttributes() {
        this.topicAttributesType.setHistoryQos(this.historyQosPolicyType);
        this.historyDepth(10);
        this.historyQosPolicyKind(HistoryQosKindType.KEEP_LAST);
        this.durabilityKind(DurabilityQosKindType.VOLATILE);
        this.reliabilityKind(ReliabilityQosKindType.RELIABLE);
        this.topicKind(TopicKindType.NO_KEY);
    }

    private T self() {
        return (T)this;
    }

    public T topicDataType(TopicDataType<?> topicDataType) {
        this.topicDataType = topicDataType;
        this.topicAttributesType.setDataType(topicDataType.getName());
        String centerPartReplaced = topicDataType.getName().replaceAll("::msg::dds_::", "/");
        this.humanReadableTopicDataTypeName = centerPartReplaced.substring(0, centerPartReplaced.length() - 1);
        return this.self();
    }

    public TopicDataType<?> getTopicDataType() {
        return this.topicDataType;
    }

    public T topicKind(TopicKindType kind) {
        this.topicAttributesType.setKind(kind);
        return this.self();
    }

    public TopicKindType getTopicKind() {
        return this.topicAttributesType.getKind();
    }

    public T topicName(String name) {
        this.topicAttributesType.setName(name);
        this.humanReadableTopicName = this.topicAttributesType.getName().substring(2);
        return this.self();
    }

    public String getTopicName() {
        return this.topicAttributesType.getName();
    }

    public T historyDepth(int depth) {
        this.historyQosPolicyType.setDepth(depth);
        return this.self();
    }

    public int getHistoryDepth() {
        return this.historyQosPolicyType.getDepth();
    }

    public T historyQosPolicyKind(HistoryQosKindType kind) {
        this.historyQosPolicyType.setKind(kind);
        return this.self();
    }

    public HistoryQosKindType getHistoryQosPolicyKind() {
        return this.historyQosPolicyType.getKind();
    }

    public T durabilityKind(DurabilityQosKindType kind) {
        this.durabilityQosPolicyType.setKind(kind);
        return this.self();
    }

    public DurabilityQosKindType getDurabilityKind() {
        return this.durabilityQosPolicyType.getKind();
    }

    public T reliabilityKind(ReliabilityQosKindType kind) {
        this.reliabilityQosPolicyType.setKind(kind);
        return this.self();
    }

    public ReliabilityQosKindType getReliabilityKind() {
        return this.reliabilityQosPolicyType.getKind();
    }

    public T maxBlockingTime(Time time) {
        this.reliabilityQosPolicyType.setMaxBlockingTime(DDSConversionTools.timeToDurationType(time));
        return this.self();
    }

    public Time getMaxBlockingTime() {
        return DDSConversionTools.durationTypeToTime(this.reliabilityQosPolicyType.getMaxBlockingTime());
    }

    protected abstract void setPartitionQosPolicyType(PartitionQosPolicyType var1);

    protected abstract PartitionQosPolicyType getPartitionQosPolicyType();

    public T partitions(List<String> partitions) {
        if (partitions != null && !partitions.isEmpty()) {
            PartitionQosPolicyType partitionQosPolicyType = new PartitionQosPolicyType();
            NameVectorType nameVectorType = new NameVectorType();
            partitions.forEach(s -> nameVectorType.getName().add((String)s));
            partitionQosPolicyType.setNames(nameVectorType);
            this.setPartitionQosPolicyType(partitionQosPolicyType);
        }
        return this.self();
    }

    public List<String> getPartitions() {
        if (this.getPartitionQosPolicyType() == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(this.getPartitionQosPolicyType().getNames().getName());
    }

    public T ownershipPolicyKind(OwnershipQosKindType kind) {
        LogTools.warn((String)"OwnershipQosPolicy not supported");
        return this.self();
    }

    public OwnershipQosKindType getOwnerShipPolicyKind() {
        return null;
    }

    protected abstract void setLifespanQosPolicyType(LifespanQosPolicyType var1);

    protected abstract LifespanQosPolicyType getLifespanQosPolicyType();

    public T lifespan(Time lifespan) {
        LifespanQosPolicyType lifespanQosPolicyType = new LifespanQosPolicyType();
        lifespanQosPolicyType.setDuration(DDSConversionTools.timeToDurationType(lifespan));
        this.setLifespanQosPolicyType(lifespanQosPolicyType);
        return this.self();
    }

    public Time getLifespan() {
        if (this.getLifespanQosPolicyType() != null) {
            return DDSConversionTools.durationTypeToTime(this.getLifespanQosPolicyType().getDuration());
        }
        return null;
    }

    public String getHumanReadableTopicName() {
        return this.humanReadableTopicName;
    }

    public String getHumanReadableTopicDataTypeName() {
        return this.humanReadableTopicDataTypeName;
    }
}

