/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.attributes;

import com.eprosima.xmlschemas.fastrtps_profiles.AddressListType;
import com.eprosima.xmlschemas.fastrtps_profiles.BuiltinAttributesType;
import com.eprosima.xmlschemas.fastrtps_profiles.DiscoveryProtocol;
import com.eprosima.xmlschemas.fastrtps_profiles.DiscoveryServerList;
import com.eprosima.xmlschemas.fastrtps_profiles.DiscoverySettingsType;
import com.eprosima.xmlschemas.fastrtps_profiles.EDPType;
import com.eprosima.xmlschemas.fastrtps_profiles.LocatorListType;
import com.eprosima.xmlschemas.fastrtps_profiles.LocatorType;
import com.eprosima.xmlschemas.fastrtps_profiles.ParticipantProfileType;
import com.eprosima.xmlschemas.fastrtps_profiles.ProfilesType;
import com.eprosima.xmlschemas.fastrtps_profiles.RemoteServerAttributes;
import com.eprosima.xmlschemas.fastrtps_profiles.RtpsParticipantAttributesType;
import com.eprosima.xmlschemas.fastrtps_profiles.RtpsTransportDescriptorType;
import com.eprosima.xmlschemas.fastrtps_profiles.StringListType;
import com.eprosima.xmlschemas.fastrtps_profiles.TransportDescriptorListType;
import com.eprosima.xmlschemas.fastrtps_profiles.Udpv4LocatorType;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import us.ihmc.pubsub.attributes.DDSConversionTools;
import us.ihmc.pubsub.common.Time;
import us.ihmc.pubsub.impl.fastRTPS.FastRTPSDomain;

public class ParticipantAttributes {
    private final ParticipantProfileType participantProfile = new ParticipantProfileType();
    private final TransportDescriptorListType transportDescriptors = new TransportDescriptorListType();

    public ParticipantAttributes() {
        RtpsParticipantAttributesType rtps = new RtpsParticipantAttributesType();
        BuiltinAttributesType builtin = new BuiltinAttributesType();
        DiscoverySettingsType discoverySettingsType = new DiscoverySettingsType();
        this.participantProfile.setRtps(rtps);
        rtps.setBuiltin(builtin);
        builtin.setDiscoveryConfig(discoverySettingsType);
        this.discoveryLeaseDuration(Time.Infinite);
    }

    public static ParticipantAttributes create() {
        return new ParticipantAttributes();
    }

    public ParticipantProfileType getProfile() {
        return this.participantProfile;
    }

    public ParticipantAttributes domainId(int id) {
        this.participantProfile.setDomainId(Long.valueOf(id));
        return this;
    }

    public int getDomainId() {
        return this.participantProfile.getDomainId().intValue();
    }

    public ParticipantAttributes name(String name) {
        this.participantProfile.getRtps().setName(name);
        return this;
    }

    public String getName() {
        return this.participantProfile.getRtps().getName();
    }

    public ParticipantAttributes discoveryLeaseDuration(Time discoveryLeaseDuration) {
        this.participantProfile.getRtps().getBuiltin().getDiscoveryConfig().setLeaseDuration(DDSConversionTools.timeToDurationType(discoveryLeaseDuration));
        return this;
    }

    public ParticipantAttributes discoveryServer(String discoveryServerAddress, int discoveryServerId) {
        return this.discoveryServer(discoveryServerAddress, discoveryServerId, 11811);
    }

    public ParticipantAttributes discoveryServer(String discoveryServerAddress, int discoveryServerId, int discoveryServerPort) {
        if (discoveryServerId < 0 || discoveryServerId > 255) {
            throw new RuntimeException("Invalid discovery server ID");
        }
        if (discoveryServerPort < 0 || discoveryServerPort > 65535) {
            throw new RuntimeException("Invalid discovery server port");
        }
        DiscoverySettingsType discoverySettingsType = this.participantProfile.getRtps().getBuiltin().getDiscoveryConfig();
        DiscoveryServerList discoveryServerList = new DiscoveryServerList();
        discoverySettingsType.setDiscoveryProtocol(DiscoveryProtocol.CLIENT);
        RemoteServerAttributes remoteServerAttributes = new RemoteServerAttributes();
        LocatorListType locatorListType = new LocatorListType();
        LocatorType locatorType = new LocatorType();
        Udpv4LocatorType udpv4LocatorType = new Udpv4LocatorType();
        udpv4LocatorType.setAddress(discoveryServerAddress);
        udpv4LocatorType.setPort(Long.valueOf(discoveryServerPort));
        locatorType.setUdpv4(udpv4LocatorType);
        locatorListType.getLocator().add(locatorType);
        remoteServerAttributes.getContent().add((JAXBElement<LocatorListType>)new JAXBElement(new QName("http://www.eprosima.com/XMLSchemas/fastRTPS_Profiles", "metatrafficUnicastLocatorList"), LocatorListType.class, (Object)locatorListType));
        remoteServerAttributes.setPrefix(String.format("44.53.%02X.5f.45.50.52.4f.53.49.4d.41", discoveryServerId));
        discoveryServerList.getRemoteServer().add(remoteServerAttributes);
        discoverySettingsType.setDiscoveryServersList(discoveryServerList);
        return this;
    }

    public ParticipantAttributes bindToAddressRestrictions(boolean addSharedMemoryTransport, List<InetAddress> bindToAddressRestrictions) {
        this.useBuiltinTransports(false);
        if (addSharedMemoryTransport) {
            this.addSharedMemoryTransport();
        }
        if (bindToAddressRestrictions != null && !bindToAddressRestrictions.isEmpty()) {
            String transportName = UUID.randomUUID().toString();
            RtpsTransportDescriptorType transportDescriptor = new RtpsTransportDescriptorType();
            transportDescriptor.setTransportId(transportName);
            transportDescriptor.setType("UDPv4");
            transportDescriptor.setMaxMessageSize(1500L);
            AddressListType addressWhitelist = new AddressListType();
            for (InetAddress addr : bindToAddressRestrictions) {
                addressWhitelist.getAddress().add(addr.getHostAddress());
            }
            transportDescriptor.setInterfaceWhiteList(addressWhitelist);
            this.addTransport(transportDescriptor);
        }
        return this;
    }

    public ParticipantAttributes addTransport(RtpsTransportDescriptorType transport) {
        this.transportDescriptors.getTransportDescriptor().add(transport);
        if (this.participantProfile.getRtps().getUserTransports() == null) {
            this.participantProfile.getRtps().setUserTransports(new StringListType());
        }
        this.participantProfile.getRtps().getUserTransports().getId().add(transport.getTransportId());
        return this;
    }

    public ParticipantAttributes addSharedMemoryTransport() {
        String transportName = UUID.randomUUID().toString();
        RtpsTransportDescriptorType transportDescriptor = new RtpsTransportDescriptorType();
        transportDescriptor.setTransportId(transportName);
        transportDescriptor.setType("SHM");
        this.addTransport(transportDescriptor);
        return this;
    }

    public ParticipantAttributes useBuiltinTransports(boolean useBuiltinTransports) {
        this.participantProfile.getRtps().setUseBuiltinTransports(useBuiltinTransports);
        return this;
    }

    public boolean isUseBuiltinTransports() {
        return this.participantProfile.getRtps().isUseBuiltinTransports();
    }

    public ParticipantAttributes useOnlySharedMemoryTransport() {
        this.useBuiltinTransports(false);
        this.addSharedMemoryTransport();
        return this;
    }

    public boolean isUseStaticDiscovery() {
        return this.participantProfile.getRtps().getBuiltin().getDiscoveryConfig().getEDP() == EDPType.STATIC;
    }

    public ParticipantAttributes useStaticDiscovery(boolean useStaticDiscovery) {
        this.participantProfile.getRtps().getBuiltin().getDiscoveryConfig().setEDP(useStaticDiscovery ? EDPType.STATIC : EDPType.SIMPLE);
        return this;
    }

    public String marshall(String profileName) throws IOException {
        ProfilesType profilesType = new ProfilesType();
        profilesType.getLibrarySettingsOrTransportDescriptorsOrParticipant().add(new JAXBElement(new QName("http://www.eprosima.com/XMLSchemas/fastRTPS_Profiles", "transport_descriptors"), TransportDescriptorListType.class, (Object)this.transportDescriptors));
        profilesType.getLibrarySettingsOrTransportDescriptorsOrParticipant().add(new JAXBElement(new QName("http://www.eprosima.com/XMLSchemas/fastRTPS_Profiles", "participant"), ParticipantProfileType.class, (Object)this.participantProfile));
        this.participantProfile.setProfileName(profileName);
        String profileXML = FastRTPSDomain.marshalProfile(profilesType);
        profileXML = Pattern.compile("<id>(.*)<\\/id>").matcher(profileXML).replaceAll("<transport_id>$1<\\/transport_id>");
        return profileXML;
    }
}

