/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rtps.impl.fastRTPS;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang3.SystemUtils;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.Domain;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.ParticipantAttributes;
import us.ihmc.pubsub.attributes.PublisherAttributes;
import us.ihmc.pubsub.attributes.SubscriberAttributes;
import us.ihmc.pubsub.participant.Participant;
import us.ihmc.pubsub.participant.ParticipantListener;
import us.ihmc.pubsub.publisher.Publisher;
import us.ihmc.pubsub.publisher.PublisherListener;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.pubsub.subscriber.SubscriberListener;
import us.ihmc.rtps.impl.fastRTPS.FastRTPSJNI;
import us.ihmc.rtps.impl.fastRTPS.FastRTPSParticipant;
import us.ihmc.rtps.impl.fastRTPS.FastRTPSParticipantAttributes;
import us.ihmc.rtps.impl.fastRTPS.FastRTPSPublisher;
import us.ihmc.rtps.impl.fastRTPS.FastRTPSPublisherAttributes;
import us.ihmc.rtps.impl.fastRTPS.FastRTPSSubscriberAttributes;
import us.ihmc.rtps.impl.fastRTPS.LogLevel;
import us.ihmc.tools.nativelibraries.NativeLibraryLoader;

public class FastRTPSDomain
implements Domain {
    private final ArrayList<FastRTPSParticipant> participants = new ArrayList();
    private static boolean useSystemFastRTPS = false;
    private static FastRTPSDomain instance = null;

    public static synchronized FastRTPSDomain getInstance(boolean useSystemFastRTPS) {
        if (instance == null) {
            FastRTPSDomain.useSystemFastRTPS = useSystemFastRTPS;
            instance = new FastRTPSDomain(useSystemFastRTPS);
        }
        if (FastRTPSDomain.useSystemFastRTPS != useSystemFastRTPS) {
            if (useSystemFastRTPS) {
                throw new RuntimeException("Loading FastRTPS using the system FastRTPS library, but the builtin FastRTPS library is already loaded.");
            }
            throw new RuntimeException("Loading FastRTPS using the builtin FastRTPS library, but the system FastRTPS library is already loaded.");
        }
        return instance;
    }

    private FastRTPSDomain(boolean useSystemFastRTPS) {
        try {
            if (useSystemFastRTPS) {
                System.loadLibrary("FastRTPSWrapper");
            } else {
                NativeLibraryLoader.loadLibrary((String)"us.ihmc.rtps.impl.fastRTPS", (String)"FastRTPSWrapper");
                FastRTPSJNI.LogLevel_setLogLevel(0);
            }
        }
        catch (UnsatisfiedLinkError e) {
            if (SystemUtils.IS_OS_WINDOWS) {
                throw new UnsatisfiedLinkError("Cannot load library, make sure to install Microsoft Visual C++ 2019 Redistributable (x64) (https://aka.ms/vs/16/release/vc_redist.x64.exe). " + e.getMessage());
            }
            throw e;
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            LogTools.info((String)"FastRTPS domain is going down.");
            this.stopAll();
            ThreadTools.sleep((long)10L);
        }, "IHMCPubSub-FastRTPSDomain-StopAll"));
    }

    @Override
    public synchronized Participant createParticipant(ParticipantAttributes participantAttributes, ParticipantListener participantListener) throws IOException {
        FastRTPSParticipant participant = new FastRTPSParticipant(participantAttributes, participantListener);
        this.participants.add(participant);
        return participant;
    }

    @Override
    public synchronized Publisher createPublisher(Participant participant, PublisherAttributes publisherAttributes, PublisherListener listener) throws IOException, IllegalArgumentException {
        FastRTPSPublisher publisher = null;
        for (int i = 0; i < this.participants.size(); ++i) {
            if (this.participants.get(i) != participant) continue;
            publisher = this.participants.get(i).createPublisher(publisherAttributes, listener);
            break;
        }
        if (publisher == null) {
            throw new IllegalArgumentException("Participant is not part of this domain.");
        }
        ThreadTools.sleep((long)1L);
        return publisher;
    }

    @Override
    public synchronized Subscriber createSubscriber(Participant participant, SubscriberAttributes subscriberAttributes, SubscriberListener listener) throws IOException, IllegalArgumentException {
        for (int i = 0; i < this.participants.size(); ++i) {
            if (this.participants.get(i) != participant) continue;
            return this.participants.get(i).createSubscriber(subscriberAttributes, listener);
        }
        throw new IllegalArgumentException("Participant is not part of this domain.");
    }

    @Override
    public synchronized boolean removeParticipant(Participant participant) {
        for (int i = 0; i < this.participants.size(); ++i) {
            if (this.participants.get(i) != participant) continue;
            this.participants.get(i).delete();
            this.participants.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean removePublisher(Publisher publisher) {
        for (int i = 0; i < this.participants.size(); ++i) {
            if (!this.participants.get(i).getGuid().getGuidPrefix().equals(publisher.getGuid().getGuidPrefix())) continue;
            return this.participants.get(i).removePublisher(publisher);
        }
        return false;
    }

    @Override
    public synchronized boolean removeSubscriber(Subscriber subscriber) {
        for (int i = 0; i < this.participants.size(); ++i) {
            if (!this.participants.get(i).getGuid().getGuidPrefix().equals(subscriber.getGuid().getGuidPrefix())) continue;
            return this.participants.get(i).removeSubscriber(subscriber);
        }
        return false;
    }

    @Override
    public synchronized TopicDataType<?> getRegisteredType(Participant participant, String typeName) {
        for (int i = 0; i < this.participants.size(); ++i) {
            if (this.participants.get(i) != participant) continue;
            return this.participants.get(i).getRegisteredType(typeName);
        }
        return null;
    }

    @Override
    public synchronized void registerType(Participant participant, TopicDataType<?> topicDataType) throws IllegalArgumentException {
        for (int i = 0; i < this.participants.size(); ++i) {
            if (this.participants.get(i) != participant) continue;
            this.participants.get(i).registerType(topicDataType);
            return;
        }
        throw new IllegalArgumentException("Participant is not part of this domain.");
    }

    @Override
    public synchronized void unregisterType(Participant participant, String typeName) throws IOException {
        for (int i = 0; i < this.participants.size(); ++i) {
            if (this.participants.get(i) != participant) continue;
            this.participants.get(i).unregisterType(typeName);
            return;
        }
        throw new IllegalArgumentException("Participant is not part of this domain.");
    }

    @Override
    public synchronized void stopAll() {
        for (int i = this.participants.size() - 1; i >= 0; --i) {
            this.removeParticipant(this.participants.get(i));
        }
    }

    @Override
    public FastRTPSSubscriberAttributes createSubscriberAttributes() {
        return new FastRTPSSubscriberAttributes();
    }

    @Override
    public FastRTPSPublisherAttributes createPublisherAttributes() {
        return new FastRTPSPublisherAttributes();
    }

    @Override
    public FastRTPSParticipantAttributes createParticipantAttributes() {
        return new FastRTPSParticipantAttributes();
    }

    @Override
    public void setLogLevel(us.ihmc.pubsub.common.LogLevel level) {
        LogLevel.setLogLevel(level.getLevel());
    }
}

