/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.impl.intraprocess;

import java.io.IOException;
import org.apache.commons.lang3.NotImplementedException;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.DurabilityKind;
import us.ihmc.pubsub.common.ChangeKind;
import us.ihmc.pubsub.common.Guid;
import us.ihmc.pubsub.common.MatchingInfo;
import us.ihmc.pubsub.common.SampleInfo;
import us.ihmc.pubsub.impl.intraprocess.IntraProcessDomainImpl;
import us.ihmc.pubsub.impl.intraprocess.IntraProcessParticipant;
import us.ihmc.pubsub.impl.intraprocess.IntraProcessPublisherAttributes;
import us.ihmc.pubsub.impl.intraprocess.IntraProcessSubscriber;
import us.ihmc.pubsub.publisher.Publisher;
import us.ihmc.pubsub.publisher.PublisherListener;

class IntraProcessPublisher<T>
implements Publisher {
    private boolean available = true;
    private final TopicDataType<T> topicDataType;
    private final Guid guid;
    private final IntraProcessPublisherAttributes attr;
    private IntraProcessDomainImpl domain;
    private IntraProcessParticipant participant;
    private PublisherListener listener;
    private long sequence = 0L;

    public IntraProcessPublisher(Guid guid, IntraProcessDomainImpl domainImpl, IntraProcessParticipant participant, IntraProcessPublisherAttributes attr, PublisherListener listener) throws IOException {
        TopicDataType<?> topicDataType = participant.getTopicDataType(attr.getTopic().getTopicDataType());
        if (topicDataType == null) {
            throw new IOException("Cannot registered publisher with topic " + attr.getTopic().getTopicDataType() + ". Topic data type is not registered.");
        }
        this.topicDataType = topicDataType.newInstance();
        this.guid = guid;
        this.domain = domainImpl;
        this.participant = participant;
        this.attr = attr;
        this.listener = listener;
        if (attr.getQos().getDurabilityKind() != DurabilityKind.VOLATILE_DURABILITY_QOS) {
            throw new RuntimeException("Only volatile durability is supported for intraprocess communication");
        }
    }

    @Override
    public void write(Object data) throws IOException {
        SampleInfo newInfo = new SampleInfo();
        newInfo.setDataLength(this.topicDataType.getTypeSize());
        newInfo.setSampleKind(ChangeKind.ALIVE);
        newInfo.getSourceTimestamp().set(System.nanoTime());
        newInfo.getSampleIdentity().getGuid().set(this.guid);
        newInfo.getSampleIdentity().getSequenceNumber().set(this.sequence);
        this.domain.write(this.attr, this.topicDataType, data, newInfo);
        ++this.sequence;
    }

    @Override
    public void dispose(Object data) throws IOException {
        throw new NotImplementedException("Dispose not implemented for intraprocess communication");
    }

    @Override
    public void unregister(Object data) throws IOException {
        throw new NotImplementedException("Unregister not implemented for intraprocess communication");
    }

    @Override
    public void dispose_and_unregister(Object data) throws IOException {
        throw new NotImplementedException("Dispose and unregister not implemented for intraprocess communication");
    }

    @Override
    public int removeAllChange() throws IOException {
        throw new NotImplementedException("Remove all change not implemented for intraprocess communication");
    }

    @Override
    public Guid getGuid() {
        return this.guid;
    }

    @Override
    public IntraProcessPublisherAttributes getAttributes() {
        return this.attr;
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    void notifyPublisherListener(IntraProcessSubscriber subscriber, MatchingInfo.MatchingStatus matchedMatching) {
        if (this.listener != null) {
            MatchingInfo info = new MatchingInfo();
            info.setStatus(matchedMatching);
            info.getGuid().set(subscriber.getGuid());
            this.listener.onPublicationMatched(this, info);
        }
    }

    public TopicDataType<?> getTopicDataType() {
        return this.topicDataType;
    }

    IntraProcessParticipant getParticipant() {
        return this.participant;
    }

    void destroy() {
        this.available = false;
        this.domain = null;
        this.participant = null;
        this.listener = null;
    }
}

