/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.idl.serializers.extra;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.idl.serializers.extra.CustomDeserializationHandler;
import us.ihmc.idl.serializers.extra.JacksonInterchangeSerializer;
import us.ihmc.idl.serializers.extra.UnsupportedFeatureException;
import us.ihmc.pubsub.TopicDataType;

public abstract class AbstractSerializer<T> {
    protected final ObjectMapper mapper;
    protected final TopicDataType<T> topicDataType;
    private boolean addTypeAsRootNode = true;
    private CustomDeserializationHandler<T> customDeserializationHandler;

    protected AbstractSerializer(TopicDataType<T> topicDataType, ObjectMapper mapper) {
        this.topicDataType = topicDataType;
        this.mapper = mapper;
    }

    public void setAddTypeAsRootNode(boolean addTypeAsRootNode) {
        this.addTypeAsRootNode = addTypeAsRootNode;
    }

    public String serializeToString(T data) throws IOException {
        try {
            return this.mapper.writeValueAsString(this.serializeAndCatch(data));
        }
        catch (JsonProcessingException e) {
            throw new IOException("Invalid call to Jackson made internally in the serializer. Please file a bug report", e);
        }
    }

    public byte[] serializeToBytes(T data) throws IOException {
        try {
            return this.mapper.writeValueAsBytes(this.serializeAndCatch(data));
        }
        catch (JsonProcessingException e) {
            throw new IOException("Invalid call to Jackson made internally in the serializer. Please file a bug report", e);
        }
    }

    public void serialize(File target, T data) throws IOException {
        this.mapper.writeValue(target, this.serializeAndCatch(data));
    }

    public void serialize(OutputStream target, T data) throws IOException {
        this.mapper.writeValue(target, this.serializeAndCatch(data));
    }

    public void serialize(Writer target, T data) throws IOException {
        this.mapper.writeValue(target, this.serializeAndCatch(data));
    }

    protected Object serialize(T data) throws IOException {
        ObjectNode root = this.mapper.createObjectNode();
        ObjectNode node = this.addTypeAsRootNode ? root.putObject(this.topicDataType.getName()) : root;
        this.topicDataType.serialize(data, (InterchangeSerializer)new JacksonInterchangeSerializer(node, true));
        return root;
    }

    private Object serializeAndCatch(T data) throws IOException {
        try {
            return this.serialize(data);
        }
        catch (UnsupportedFeatureException e) {
            throw new IOException(e);
        }
    }

    public T deserialize(Reader source) throws IOException {
        return this.deserializeAndCatch(this.mapper.readTree(source));
    }

    public T deserialize(InputStream source) throws IOException {
        return this.deserializeAndCatch(this.mapper.readTree(source));
    }

    public T deserialize(byte[] source) throws IOException {
        return this.deserializeAndCatch(this.mapper.readTree(source));
    }

    public T deserialize(String source) throws IOException {
        return this.deserializeAndCatch(this.mapper.readTree(source));
    }

    public T deserialize(File source) throws IOException {
        return this.deserializeAndCatch(this.mapper.readTree(source));
    }

    public T deserialize(URL source) throws IOException {
        return this.deserializeAndCatch(this.mapper.readTree(source));
    }

    protected T deserialize(JsonNode root) throws IOException {
        JsonNode node = this.addTypeAsRootNode ? root.get(this.topicDataType.getName()) : root;
        if (node != null && node.isObject()) {
            JacksonInterchangeSerializer serializer = new JacksonInterchangeSerializer((ObjectNode)node, true);
            Object data = this.topicDataType.createData();
            this.topicDataType.deserialize((InterchangeSerializer)serializer, data);
            if (this.customDeserializationHandler != null) {
                this.customDeserializationHandler.handle(node, data);
            }
            return (T)data;
        }
        return null;
    }

    private T deserializeAndCatch(JsonNode root) throws IOException {
        if (root != null) {
            try {
                return this.deserialize(root);
            }
            catch (UnsupportedFeatureException e) {
                throw new IOException(e);
            }
        }
        return null;
    }

    public void setCustomDeserializationHandler(CustomDeserializationHandler<T> customDeserializationHandler) {
        this.customDeserializationHandler = customDeserializationHandler;
    }
}

