/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.idl.serializers.extra;

import java.io.IOException;
import java.io.InputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.idl.generated.nested.NestedElement;
import us.ihmc.idl.generated.test.Color;
import us.ihmc.idl.generated.test.IDLElementTest;
import us.ihmc.idl.generated.test.IDLElementTestPubSubType;
import us.ihmc.idl.serializers.extra.JSONSerializer;
import us.ihmc.pubsub.TopicDataType;

public class JSONSerializerTest {
    public static void populateIDLElementTest(IDLElementTest test) {
        int i;
        test.setCharTest('3');
        test.setWcharTest('w');
        test.setOctetTest((byte)10);
        test.setShortTest((short)-16);
        test.setUshortTest(15);
        test.setLongTest(-58102);
        test.setUlongTest(914L);
        test.setLonglongTest(-90224141L);
        test.setUlonglongTest(582142L);
        test.setFloatTest(258145.22f);
        test.setDoubleTest(9.1842890511241E9);
        test.setBooleanTest(true);
        test.setColorTest(Color.blue);
        test.getNestedElementTest().setLongTest(518);
        test.getNestedElementTest().getStringTest().append("Nested");
        test.getStringTest().append("Wolololo</StringTest>");
        for (i = 0; i < 10; ++i) {
            test.getLongArray()[i] = i * 124;
        }
        for (int a = 0; a < 5; ++a) {
            for (int b = 0; b < 3; ++b) {
                test.getNestedArray()[a][b].setLongTest(a + a * b * 3 + b + 24);
                test.getNestedArray()[a][b].getStringTest().append("arrayDim:" + a + b);
            }
        }
        for (i = 0; i < 4; ++i) {
            test.getStringArray()[i].append("arrayDim:" + i);
        }
        for (int s = 1; s < 4; ++s) {
            for (int w = 0; w < 5; ++w) {
                int i2 = s + s * w;
                switch (s) {
                    case 1: {
                        test.getCharSeqTest().add(String.valueOf(i2).charAt(0));
                        test.getWcharSeqTest().add('w');
                        test.getOctetSeqTest().add((byte)(i2 * 2));
                        test.getShortSeqTest().add((short)(-2 * i2 + 1));
                        test.getBooleanSeqTest().add(i2 % 2 == 0);
                    }
                    case 2: {
                        test.getUshortSeqTest().add(i2 + 4);
                        test.getLongSeqTest().add(i2 * 124 - 98);
                        test.getUlongSeqTest().add((long)(i2 * 11561));
                        test.getLonglongSeqtest().add(-2143125L + (long)(i2 * 1251));
                    }
                    case 3: {
                        test.getUlonglongSeqTest().add(241L + (long)i2 * 100421410L);
                        test.getFloatSeqTest().add(325.25f * (float)i2);
                        test.getDoubleSeqTest().add(15095.921 * (double)i2);
                        NestedElement elem = (NestedElement)test.getNestedSeqTest().add();
                        elem.setLongTest(i2 * 541);
                        elem.getStringTest().append("dim:" + s + w);
                        StringBuilder builder = (StringBuilder)test.getStringSeqTest().add();
                        builder.append("sdim:" + s + w);
                    }
                }
            }
        }
    }

    public static IDLElementTest createPopulatedIDLElementTest() {
        IDLElementTest idlElementTest = new IDLElementTest();
        JSONSerializerTest.populateIDLElementTest(idlElementTest);
        return idlElementTest;
    }

    @Test
    public void testEmpty() throws IOException {
        IDLElementTestPubSubType type = new IDLElementTestPubSubType();
        JSONSerializer serializer = new JSONSerializer((TopicDataType)type);
        IDLElementTest idlElementTest = new IDLElementTest();
        byte[] data = serializer.serializeToBytes((Object)idlElementTest);
        IDLElementTest res = (IDLElementTest)serializer.deserialize(data);
        Assertions.assertEquals((Object)idlElementTest, (Object)res);
    }

    @Test
    public void testWithData() throws IOException {
        IDLElementTestPubSubType type = new IDLElementTestPubSubType();
        JSONSerializer serializer = new JSONSerializer((TopicDataType)type);
        IDLElementTest idlElementTest = JSONSerializerTest.createPopulatedIDLElementTest();
        byte[] data = serializer.serializeToBytes((Object)idlElementTest);
        IDLElementTest res = (IDLElementTest)serializer.deserialize(data);
        Assertions.assertEquals((Object)idlElementTest, (Object)res);
    }

    @Test
    public void testWithMissingData() throws IOException {
        IDLElementTestPubSubType type = new IDLElementTestPubSubType();
        JSONSerializer serializer = new JSONSerializer((TopicDataType)type);
        IDLElementTest empty = (IDLElementTest)serializer.deserialize("{\"test::IDLElementTest\":{}}");
        Assertions.assertEquals((Object)type.createData(), (Object)empty);
        InputStream dataStream = this.getClass().getResourceAsStream("IDLElementTest.incomplete.json");
        IDLElementTest incomplete = (IDLElementTest)serializer.deserialize(dataStream);
        Assertions.assertNotNull((Object)incomplete);
    }
}

