/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.idl.generator;

import com.eprosima.idl.parser.exception.ParseException;
import com.eprosima.idl.parser.tree.AnnotationDeclaration;
import com.eprosima.idl.parser.tree.Definition;
import com.eprosima.idl.parser.tree.Exception;
import com.eprosima.idl.parser.tree.Interface;
import com.eprosima.idl.parser.tree.Module;
import com.eprosima.idl.parser.tree.Operation;
import com.eprosima.idl.parser.tree.Param;
import com.eprosima.idl.parser.tree.TypeDeclaration;
import com.eprosima.idl.parser.typecode.StructTypeCode;
import com.eprosima.idl.parser.typecode.TypeCode;
import com.eprosima.idl.util.Pair;
import com.eprosima.idl.util.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.Stack;
import org.antlr.v4.runtime.Token;

public class Context
extends com.eprosima.idl.context.Context {
    final String currentDirS = "." + File.separator;
    final String includeFlag = "-I";
    protected HashMap<String, TypeDeclaration> m_types = null;
    String m_os = System.getProperty("os.name");
    String m_userdir = System.getProperty("user.dir");
    private String m_filename = "";
    private String m_file = "";
    private String m_directoryFile = "";
    private String m_scope = "";
    private String m_scopeFile = "";
    private boolean m_scopeLimitToAll = false;
    private int m_currentincludeline = 0;
    private ArrayList<Definition> m_definitions;
    private HashMap<String, Module> m_modules = null;
    private HashMap<String, Interface> m_interfaces = null;
    private HashMap<String, Exception> m_exceptions = null;
    private HashMap<String, AnnotationDeclaration> m_annotations = null;
    private ArrayList<String> m_includePaths = null;
    private LinkedHashSet<String> m_dependencies = null;
    private HashSet<String> m_directIncludeDependencies = null;
    private HashSet<String> m_includedependency = null;
    private int m_loopVarIndex = 0;
    private Stack<Pair<String, Integer>> m_scopeFilesStack;

    public Context(String filename, String file, ArrayList<String> includePaths) {
        super(filename, file, includePaths);
        this.m_filename = filename;
        this.m_directoryFile = Util.getIDLFileDirectoryOnly((String)file);
        this.m_file = file;
        if (this.startsWith(this.m_file, this.m_userdir)) {
            this.m_file = this.m_file.substring(this.m_userdir.length());
            if (this.startsWith(this.m_file, File.separator)) {
                this.m_file = this.m_file.substring(1);
            }
        }
        this.m_definitions = new ArrayList();
        this.m_modules = new HashMap();
        this.m_interfaces = new HashMap();
        this.m_exceptions = new HashMap();
        this.m_types = new HashMap();
        this.m_annotations = new HashMap();
        this.m_includedependency = new HashSet();
        this.m_scopeFile = this.m_file;
        this.m_includePaths = new ArrayList();
        this.m_dependencies = new LinkedHashSet();
        this.m_directIncludeDependencies = new HashSet();
        this.m_scopeFilesStack = new Stack();
        for (int i = 0; i < includePaths.size(); ++i) {
            Object include = includePaths.get(i);
            if (this.startsWith((String)include, "-I")) {
                include = ((String)include).substring("-I".length());
            }
            if (this.startsWith((String)include, this.m_userdir) && this.startsWith((String)(include = ((String)include).substring(this.m_userdir.length())), File.separator)) {
                include = ((String)include).substring(1);
            }
            if (this.m_directoryFile != null && this.startsWith((String)include, this.m_directoryFile)) {
                include = ((String)include).substring(this.m_directoryFile.length());
            }
            if (((String)include).charAt(((String)include).length() - 1) != File.separatorChar) {
                include = (String)include + File.separator;
            }
            this.m_includePaths.add((String)include);
        }
        int pointer = 0;
        while (pointer < this.m_includePaths.size()) {
            int count;
            for (count = pointer + 1; count < this.m_includePaths.size(); ++count) {
                if (!this.startsWith(this.m_includePaths.get(count), this.m_includePaths.get(pointer))) continue;
                String first = this.m_includePaths.get(pointer);
                String second = this.m_includePaths.get(count);
                this.m_includePaths.set(pointer, second);
                this.m_includePaths.set(count, first);
                break;
            }
            if (count != this.m_includePaths.size()) continue;
            ++pointer;
        }
    }

    public String getFilename() {
        return this.m_filename;
    }

    public void setFilename(String filename) {
        this.m_filename = filename;
    }

    public String getTrimfilename() {
        return Util.stringTrimAll((String)this.m_filename);
    }

    public String getScope() {
        return this.m_scope;
    }

    public void setScope(String scope) {
        this.m_scope = scope;
    }

    public boolean isInScopedFile() {
        return this.m_scopeFile.equals(this.m_file);
    }

    public String getScopeFile() {
        return this.m_scopeFile;
    }

    public boolean isScopeLimitToAll() {
        return this.m_scopeLimitToAll;
    }

    public void setScopeLimitToAll(boolean scopeLimitToAll) {
        this.m_scopeLimitToAll = scopeLimitToAll;
    }

    public int getCurrentIncludeLine() {
        return this.m_currentincludeline;
    }

    public Stack<Pair<String, Integer>> getScopeFilesStack() {
        return this.m_scopeFilesStack;
    }

    public void addDefinition(Definition definition) {
        this.m_definitions.add(definition);
    }

    public ArrayList<Definition> getDefinitions() {
        return this.m_definitions;
    }

    public void addModule(Module module) {
        if (!this.m_modules.containsKey(module.getScopedname())) {
            this.m_modules.put(module.getScopedname(), module);
        }
    }

    public Module existsModule(String scopedName) {
        if (this.m_modules.containsKey(scopedName)) {
            return this.m_modules.get(scopedName);
        }
        return null;
    }

    public Interface createInterface(String name, Token token) {
        Interface interfaceObject = new Interface(this.m_scopeFile, this.isInScopedFile(), this.m_scope, name, token);
        this.addInterface(interfaceObject);
        return interfaceObject;
    }

    protected void addInterface(Interface interf) {
        Interface prev = this.m_interfaces.put(interf.getScopedname(), interf);
        if (prev != null) {
            System.out.println("Warning: Redefined interface " + prev.getScopedname());
        }
    }

    public Interface getInterface(String name) {
        int lastIndex = -1;
        Interface returnedValue = this.m_interfaces.get(name);
        if (returnedValue == null) {
            String scope = this.m_scope;
            while (returnedValue == null && !scope.isEmpty()) {
                returnedValue = this.m_interfaces.get(scope + "::" + name);
                lastIndex = scope.lastIndexOf("::");
                if (lastIndex != -1) {
                    scope = scope.substring(0, lastIndex);
                    continue;
                }
                scope = "";
            }
        }
        return returnedValue;
    }

    public ArrayList<Interface> getInterfaces() {
        return new ArrayList<Interface>(this.m_interfaces.values());
    }

    public ArrayList<Interface> getScopedInterfaces() {
        ArrayList<Interface> ret = new ArrayList<Interface>();
        for (Interface interf : this.m_interfaces.values()) {
            if (!interf.isInScope()) continue;
            ret.add(interf);
        }
        return ret;
    }

    public Exception createException(String name, Token token) {
        Exception exceptionObject = new Exception(this.m_scopeFile, this.isInScopedFile(), this.m_scope, name, token);
        this.addException(exceptionObject);
        return exceptionObject;
    }

    protected void addException(Exception exception) {
        Exception prev = this.m_exceptions.put(exception.getScopedname(), exception);
        if (prev != null) {
            System.out.println("Warning: Redefined exception " + prev.getScopedname());
        }
    }

    public Exception getException(String name) {
        int lastIndex = -1;
        Exception returnedValue = this.m_exceptions.get(name);
        if (returnedValue == null) {
            String scope = this.m_scope;
            while (returnedValue == null && !scope.isEmpty()) {
                returnedValue = this.m_exceptions.get(scope + "::" + name);
                lastIndex = scope.lastIndexOf("::");
                if (lastIndex != -1) {
                    scope = scope.substring(0, lastIndex);
                    continue;
                }
                scope = "";
            }
        }
        return returnedValue;
    }

    public Operation createOperation(String name, Token token) {
        Operation operationObject = new Operation(this.m_scopeFile, this.isInScopedFile(), null, name, token);
        return operationObject;
    }

    public Param createParam(String name, TypeCode typecode, Param.Kind kind) {
        Param paramObject = new Param(name, typecode, kind);
        return paramObject;
    }

    public StructTypeCode createStructTypeCode(String name, String comments) {
        StructTypeCode structObject = new StructTypeCode(this.m_scope, name, comments);
        return structObject;
    }

    public Collection<TypeDeclaration> getTypes() {
        return this.m_types.values();
    }

    public void addTypeDeclaration(TypeDeclaration typedecl) {
        TypeDeclaration prev = this.m_types.put(typedecl.getScopedname(), typedecl);
        if (prev != null) {
            throw new ParseException(typedecl.getToken(), "was redefined");
        }
    }

    public TypeCode getTypeCode(String name) {
        int lastIndex = -1;
        TypeCode returnedValue = null;
        TypeDeclaration typedecl = this.m_types.get(name);
        if (typedecl == null) {
            String scope = this.m_scope;
            while (typedecl == null && !scope.isEmpty()) {
                typedecl = this.m_types.get(scope + "::" + name);
                lastIndex = scope.lastIndexOf("::");
                if (lastIndex != -1) {
                    scope = scope.substring(0, lastIndex);
                    continue;
                }
                scope = "";
            }
        }
        if (typedecl != null) {
            returnedValue = typedecl.getTypeCode();
        }
        return returnedValue;
    }

    public AnnotationDeclaration createAnnotationDeclaration(String name, Token token) {
        AnnotationDeclaration annotationObject = new AnnotationDeclaration(this.m_scopeFile, this.isInScopedFile(), this.m_scope, name, token);
        this.addAnnotationDeclaration(annotationObject);
        return annotationObject;
    }

    protected void addAnnotationDeclaration(AnnotationDeclaration annotation) {
        AnnotationDeclaration prev = this.m_annotations.put(annotation.getScopedname(), annotation);
        if (prev != null) {
            System.out.println("Warning: Redefined annotation " + prev.getScopedname());
        }
    }

    public AnnotationDeclaration getAnnotationDeclaration(String name) {
        int lastIndex = -1;
        AnnotationDeclaration returnedValue = this.m_annotations.get(name);
        if (returnedValue == null) {
            String scope = this.m_scope;
            while (returnedValue == null && !scope.isEmpty()) {
                returnedValue = this.m_annotations.get(scope + "::" + name);
                lastIndex = scope.lastIndexOf("::");
                if (lastIndex != -1) {
                    scope = scope.substring(0, lastIndex);
                    continue;
                }
                scope = "";
            }
        }
        return returnedValue;
    }

    public void addDependency(String dependency) {
        this.m_dependencies.add(dependency);
    }

    public LinkedHashSet<String> getDependencies() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        LinkedList<String> list = new LinkedList<String>(this.m_dependencies);
        Iterator<String> it = list.descendingIterator();
        while (it.hasNext()) {
            Object dep = it.next();
            if (this.getOS().contains("Windows")) {
                int count = 0;
                while ((count = ((String)dep).indexOf("/")) != -1) {
                    dep = ((String)dep).substring(0, count) + "\\" + ((String)dep).substring(count + 1);
                }
            }
            set.add((String)dep);
        }
        return set;
    }

    public ArrayList<String> getDirectIncludeDependencies() {
        return new ArrayList<String>(this.m_directIncludeDependencies);
    }

    public void addIncludeDependency(String dependency) {
        String dep = dependency.substring(0, dependency.length() - 4);
        if (this.m_directoryFile != null && this.startsWith(dep, this.m_directoryFile)) {
            dep = dep.substring(this.m_directoryFile.length());
        }
        this.m_includedependency.add(dep);
    }

    public ArrayList<String> getIncludeDependencies() {
        return new ArrayList<String>(this.m_includedependency);
    }

    public void processPreprocessorLine(String line, int nline) {
        if (line.startsWith("# ")) {
            String line_ = line.substring(2);
            Scanner scanner = new Scanner(line_);
            int numline = scanner.nextInt();
            line_ = scanner.nextLine();
            scanner = new Scanner(line_).useDelimiter("\"");
            scanner.next();
            String file = scanner.next();
            boolean systemFile = false;
            boolean enteringFile = false;
            boolean exitingFile = false;
            if (this.m_os.contains("Linux")) {
                try {
                    line_ = scanner.nextLine();
                    scanner = new Scanner(line_);
                    scanner.next();
                    while (true) {
                        Integer flag;
                        if ((flag = Integer.valueOf(scanner.nextInt())) == 1) {
                            enteringFile = true;
                            continue;
                        }
                        if (flag == 2) {
                            exitingFile = true;
                            continue;
                        }
                        if (flag != 3) continue;
                        systemFile = true;
                    }
                }
                catch (NoSuchElementException flag) {
                    // empty catch block
                }
            }
            if (!systemFile) {
                if (!this.m_scopeFile.equals(file)) {
                    if (this.startsWith(file, this.m_userdir) && this.startsWith(file = file.substring(this.m_userdir.length()), File.separator)) {
                        file = file.substring(1);
                    }
                    if (this.startsWith(file, this.currentDirS) && this.startsWith(file = file.substring(this.currentDirS.length()), File.separator)) {
                        file = file.substring(1);
                    }
                    if (file.substring(file.length() - 4, file.length()).equals(".idl") && !this.m_scopeFile.equals(file)) {
                        if (!this.m_scopeFilesStack.empty() && ((String)this.m_scopeFilesStack.peek().first()).equals(file)) {
                            this.m_scopeFilesStack.pop();
                            this.addDependency(this.m_scopeFile);
                            if (file.equals(this.m_file)) {
                                String includeFile = this.m_scopeFile;
                                if (this.m_directoryFile != null && this.startsWith(includeFile, this.m_directoryFile)) {
                                    includeFile = includeFile.substring(this.m_directoryFile.length());
                                }
                                for (int i = 0; i < this.m_includePaths.size(); ++i) {
                                    if (!this.startsWith(includeFile, this.m_includePaths.get(i))) continue;
                                    includeFile = includeFile.substring(this.m_includePaths.get(i).length());
                                    break;
                                }
                                this.m_directIncludeDependencies.add(includeFile.substring(0, includeFile.length() - 4));
                            }
                        } else {
                            this.m_scopeFilesStack.push((Pair<String, Integer>)new Pair((Object)this.m_scopeFile, (Object)(nline - this.m_currentincludeline - 1)));
                        }
                        this.m_scopeFile = file;
                    }
                }
                this.m_currentincludeline = nline - numline;
            }
        }
    }

    protected String getOS() {
        return this.m_os;
    }

    public String getNewLoopVarName() {
        this.m_loopVarIndex = 0;
        return "i" + this.m_loopVarIndex;
    }

    public String getNextLoopVarName() {
        ++this.m_loopVarIndex;
        return "i" + this.m_loopVarIndex;
    }
}

