/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.tools;

import com.eprosima.xmlschemas.fastrtps_profiles.DurabilityQosKindPolicyType;
import com.eprosima.xmlschemas.fastrtps_profiles.HistoryQosKindPolicyType;
import com.eprosima.xmlschemas.fastrtps_profiles.PublishModeQosKindPolicyType;
import com.eprosima.xmlschemas.fastrtps_profiles.ReliabilityQosKindPolicyType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.function.Supplier;
import us.ihmc.communication.packets.Packet;
import us.ihmc.idl.generated.test.IDLElementTestPubSubType;
import us.ihmc.pubsub.Domain;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.ParticipantProfile;
import us.ihmc.pubsub.attributes.PublisherAttributes;
import us.ihmc.pubsub.attributes.SubscriberAttributes;
import us.ihmc.pubsub.common.LogLevel;
import us.ihmc.pubsub.common.Time;
import us.ihmc.pubsub.participant.Participant;
import us.ihmc.pubsub.participant.ParticipantListener;
import us.ihmc.pubsub.publisher.Publisher;
import us.ihmc.pubsub.publisher.PublisherListener;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.pubsub.tools.MessageCallback;
import us.ihmc.pubsub.tools.ParticipantListenerImpl;
import us.ihmc.pubsub.tools.PublishSubscribeTools;
import us.ihmc.pubsub.tools.PublisherListenerImpl;
import us.ihmc.pubsub.tools.SubscriberListenerImpl;

public class PubSubTester<P extends Packet> {
    public Domain domain;
    public Subscriber subscriber;
    public Publisher publisher;
    public ArrayList<MessageCallback<P>> callbacks = new ArrayList();

    public PubSubTester(Supplier<P> msgTypeSupplier) throws IOException {
        this.domain = DomainFactory.getDomain();
        this.domain.setLogLevel(LogLevel.INFO);
        ParticipantProfile attributes = ParticipantProfile.create().domainId(PublishSubscribeTools.systemDomain()).useOnlyIntraProcessDelivery().discoveryLeaseDuration(Time.Infinite).name("PubSubTester");
        Participant participant = this.domain.createParticipant(attributes, (ParticipantListener)new ParticipantListenerImpl());
        IDLElementTestPubSubType dataType = new IDLElementTestPubSubType();
        this.domain.registerType(participant, (TopicDataType)dataType);
        PublisherAttributes genericPublisherAttributes = ((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)PublisherAttributes.create().topicDataType((TopicDataType)dataType)).topicName("pubsubtest")).reliabilityKind(ReliabilityQosKindPolicyType.RELIABLE)).durabilityKind(DurabilityQosKindPolicyType.VOLATILE)).historyQosPolicyKind(HistoryQosKindPolicyType.KEEP_LAST)).historyDepth(1L)).publishModeKind(PublishModeQosKindPolicyType.ASYNCHRONOUS);
        Packet data = (Packet)msgTypeSupplier.get();
        TopicDataType topicDataType = (TopicDataType)data.getPubSubTypePacket().get();
        SubscriberAttributes subscriberAttributes = (SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)SubscriberAttributes.create().topicDataType(topicDataType)).topicName("pubsubtest")).reliabilityKind(ReliabilityQosKindPolicyType.RELIABLE)).durabilityKind(DurabilityQosKindPolicyType.VOLATILE)).historyQosPolicyKind(HistoryQosKindPolicyType.KEEP_ALL);
        this.subscriber = this.domain.createSubscriber(participant, subscriberAttributes, new SubscriberListenerImpl<Packet>(data, this.callbacks));
        this.publisher = this.domain.createPublisher(participant, genericPublisherAttributes, (PublisherListener)new PublisherListenerImpl());
    }
}

