/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.examples;

import com.eprosima.xmlschemas.fastrtps_profiles.DurabilityQosKindPolicyType;
import com.eprosima.xmlschemas.fastrtps_profiles.HistoryQosKindPolicyType;
import com.eprosima.xmlschemas.fastrtps_profiles.ReliabilityQosKindPolicyType;
import java.io.IOException;
import java.util.Collections;
import us.ihmc.idl.generated.chat.ChatMessage;
import us.ihmc.idl.generated.chat.ChatMessagePubSubType;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.ParticipantProfile;
import us.ihmc.pubsub.attributes.SubscriberAttributes;
import us.ihmc.pubsub.common.LogLevel;
import us.ihmc.pubsub.common.MatchingInfo;
import us.ihmc.pubsub.common.SampleInfo;
import us.ihmc.pubsub.common.Time;
import us.ihmc.pubsub.impl.fastRTPS.FastRTPSDomain;
import us.ihmc.pubsub.participant.Participant;
import us.ihmc.pubsub.participant.ParticipantDiscoveryInfo;
import us.ihmc.pubsub.participant.ParticipantListener;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.pubsub.subscriber.SubscriberListener;

public class SubscriberExample {
    public SubscriberExample() throws IOException {
        FastRTPSDomain domain = DomainFactory.getDomain();
        domain.setLogLevel(LogLevel.INFO);
        ParticipantProfile attributes2 = ParticipantProfile.create().domainId(1).useOnlyIntraProcessDelivery().name("ParticipantExample").discoveryLeaseDuration(Time.Infinite);
        Participant participant = domain.createParticipant(attributes2, (ParticipantListener)new ParticipantListenerImpl());
        ChatMessagePubSubType dataType = new ChatMessagePubSubType();
        domain.registerType(participant, (TopicDataType)dataType);
        SubscriberAttributes subscriberAttributes = (SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)SubscriberAttributes.create().topicDataType((TopicDataType)dataType)).topicName("chatter")).reliabilityKind(ReliabilityQosKindPolicyType.RELIABLE)).partitions(Collections.singletonList("us/ihmc"))).durabilityKind(DurabilityQosKindPolicyType.TRANSIENT_LOCAL)).historyQosPolicyKind(HistoryQosKindPolicyType.KEEP_LAST)).historyDepth(50L);
        Subscriber subscriber = domain.createSubscriber(participant, subscriberAttributes, (SubscriberListener)new SubscriberListenerImpl());
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        new SubscriberExample();
        Thread.currentThread().join();
    }

    private class ParticipantListenerImpl
    implements ParticipantListener {
        private ParticipantListenerImpl() {
        }

        public void onParticipantDiscovery(Participant participant, ParticipantDiscoveryInfo info) {
            System.out.println("New participant discovered");
            System.out.println("Status: " + String.valueOf(info.getStatus()));
            System.out.println("Guid: " + info.getGuid().toString());
            System.out.println("Name: " + info.getName());
        }
    }

    private class SubscriberListenerImpl
    implements SubscriberListener {
        private final ChatMessage data = new ChatMessage();
        private final SampleInfo info = new SampleInfo();

        private SubscriberListenerImpl() {
        }

        public void onNewDataMessage(Subscriber subscriber) {
            if (subscriber.takeNextData((Object)this.data, this.info)) {
                System.out.println(this.data.getSender().toString() + ": " + this.data.getMsg().toString());
            }
        }

        public void onSubscriptionMatched(Subscriber subscriber, MatchingInfo info) {
            System.out.println("New publisher matched");
            System.out.println("Status: " + String.valueOf(info.getStatus()));
            System.out.println("Guid: " + info.getGuid().toString());
        }
    }
}

