/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.test;

import com.eprosima.xmlschemas.fastrtps_profiles.DurabilityQosKindPolicyType;
import com.eprosima.xmlschemas.fastrtps_profiles.HistoryQosKindPolicyType;
import com.eprosima.xmlschemas.fastrtps_profiles.ReliabilityQosKindPolicyType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.PrintTools;
import us.ihmc.commons.allocations.AllocationProfiler;
import us.ihmc.commons.allocations.AllocationRecord;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.idl.IDLSequence;
import us.ihmc.idl.generated.test.FooAppearanceDefinitionMessage;
import us.ihmc.idl.generated.test.FooEnumType;
import us.ihmc.idl.generated.test.FooGraphicObjectMessage;
import us.ihmc.idl.generated.test.FooHandshake;
import us.ihmc.idl.generated.test.FooHandshakePubSubType;
import us.ihmc.idl.generated.test.FooJointDefinition;
import us.ihmc.idl.generated.test.FooJointType;
import us.ihmc.idl.generated.test.FooLoadStatus;
import us.ihmc.idl.generated.test.FooSummary;
import us.ihmc.idl.generated.test.FooYoRegistryDefinition;
import us.ihmc.idl.generated.test.FooYoType;
import us.ihmc.idl.generated.test.FooYoVariableDefinition;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.ParticipantProfile;
import us.ihmc.pubsub.attributes.PublisherAttributes;
import us.ihmc.pubsub.attributes.SubscriberAttributes;
import us.ihmc.pubsub.common.LogLevel;
import us.ihmc.pubsub.common.MatchingInfo;
import us.ihmc.pubsub.common.SampleInfo;
import us.ihmc.pubsub.common.Time;
import us.ihmc.pubsub.impl.fastRTPS.FastRTPSDomain;
import us.ihmc.pubsub.participant.Participant;
import us.ihmc.pubsub.participant.ParticipantDiscoveryInfo;
import us.ihmc.pubsub.participant.ParticipantListener;
import us.ihmc.pubsub.publisher.Publisher;
import us.ihmc.pubsub.publisher.PublisherListener;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.pubsub.subscriber.SubscriberListener;

public class HandshakeTest {
    public static final int NUMBER_OF_MESSAGES_TO_SEND = 7;
    public int sendIndex = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Disabled
    @Test
    public void testPublishSubscribeFooHandshake() throws IOException {
        AllocationProfiler allocationProfiler = new AllocationProfiler();
        allocationProfiler.excludeAllocationsInsideMethod("java.lang.ThreadGroup.add");
        Random random = new Random(29103902183L);
        FastRTPSDomain domain = DomainFactory.getDomain();
        try {
            domain.setLogLevel(LogLevel.INFO);
            ParticipantProfile attributes = ParticipantProfile.create().domainId(220).useOnlyIntraProcessDelivery().discoveryLeaseDuration(Time.Infinite).name("StatusTest");
            Participant participant = domain.createParticipant(attributes, (ParticipantListener)new ParticipantListenerImpl());
            FooHandshakePubSubType dataType = new FooHandshakePubSubType();
            domain.registerType(participant, (TopicDataType)dataType);
            PublisherAttributes genericPublisherAttributes = (PublisherAttributes)((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)PublisherAttributes.create().topicDataType((TopicDataType)dataType)).topicName("Status")).reliabilityKind(ReliabilityQosKindPolicyType.RELIABLE)).partitions(Collections.singletonList("us/ihmc"))).durabilityKind(DurabilityQosKindPolicyType.VOLATILE)).historyQosPolicyKind(HistoryQosKindPolicyType.KEEP_ALL);
            FooHandshakePubSubType dataType2 = new FooHandshakePubSubType();
            SubscriberAttributes subscriberAttributes = (SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)SubscriberAttributes.create().topicDataType((TopicDataType)dataType2)).topicName("Status")).reliabilityKind(ReliabilityQosKindPolicyType.RELIABLE)).partitions(Collections.singletonList("us/ihmc"))).durabilityKind(DurabilityQosKindPolicyType.VOLATILE)).historyQosPolicyKind(HistoryQosKindPolicyType.KEEP_ALL);
            SubscriberListenerImpl subscriberListener = new SubscriberListenerImpl();
            Subscriber subscriber = domain.createSubscriber(participant, subscriberAttributes, (SubscriberListener)subscriberListener);
            Publisher publisher = domain.createPublisher(participant, genericPublisherAttributes, (PublisherListener)new PublisherListenerImpl());
            ArrayList<FooHandshake> preallocatedHandshakes = new ArrayList<FooHandshake>();
            for (int n = 0; n < 7; ++n) {
                System.out.println("Constructing random handshake " + n + "...");
                preallocatedHandshakes.add(this.constructRandomHandshake(random, n));
            }
            this.writeNHandshakes(publisher, preallocatedHandshakes, 1);
            allocationProfiler.startRecordingAllocations();
            this.writeNHandshakes(publisher, preallocatedHandshakes, 6);
            allocationProfiler.stopRecordingAllocations();
            ThreadTools.sleep((long)100L);
            for (int i = 0; i < subscriberListener.i; ++i) {
                PrintTools.info((Object)this, (String)("Message received: " + subscriberListener.receivedMessages[i].getDt()));
            }
            List allocations = allocationProfiler.pollAllocations();
            Object message = "";
            for (AllocationRecord allocation : allocations) {
                message = (String)message + allocation.toString() + "\n";
            }
            System.out.println((String)message);
            LogTools.info((String)("Recieved: " + subscriberListener.i + "/7 messages"));
            Assertions.assertTrue((allocations.size() == 0 ? 1 : 0) != 0, (String)("allocated " + allocations.size() + ": \n" + (String)message));
            Assertions.assertTrue((subscriberListener.i >= 1 ? 1 : 0) != 0, (String)"did not receive all");
        }
        finally {
            domain.stopAll();
        }
    }

    private void writeNHandshakes(Publisher publisher, List<FooHandshake> preallocatedHandshakes, int handshakesToWrite) throws IOException {
        for (int i = 0; i < handshakesToWrite; ++i) {
            try {
                publisher.write((Object)preallocatedHandshakes.get(this.sendIndex));
                ++this.sendIndex;
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public FooHandshake constructRandomHandshake(Random random, int id) {
        FooHandshake fooHandshake = new FooHandshake();
        fooHandshake.setUniqueId(id);
        fooHandshake.setDt(random.nextDouble());
        fooHandshake.setDestination(random.nextInt());
        fooHandshake.setSource(random.nextInt());
        FooSummary summary = fooHandshake.getSummary();
        summary.setCreateSummary(random.nextBoolean());
        summary.setSummaryTriggerVariable("ksnfajisfiuhou");
        IDLSequence.Object<FooGraphicObjectMessage> artifacts1 = fooHandshake.getArtifacts();
        for (int i = 0; i < 2000; ++i) {
            int j;
            FooGraphicObjectMessage fooGraphicObjectMessage = (FooGraphicObjectMessage)((Object)artifacts1.add());
            fooGraphicObjectMessage.setListName("asndoasd" + i);
            fooGraphicObjectMessage.setName("aiojdsoia" + i);
            fooGraphicObjectMessage.setRegistrationID(random.nextInt());
            for (j = 0; j < 70; ++j) {
                fooGraphicObjectMessage.getConstants().add(random.nextDouble());
            }
            for (j = 0; j < 700; ++j) {
                fooGraphicObjectMessage.getYoVariableIndex().add(random.nextInt(65535));
            }
            FooAppearanceDefinitionMessage appearance = fooGraphicObjectMessage.getAppearance();
            appearance.setB(255.0);
            appearance.setG(255.0);
            appearance.setR(255.0);
        }
        IDLSequence.Object<FooEnumType> enumTypes = fooHandshake.getEnumTypes();
        for (int i = 0; i < 700; ++i) {
            ((FooEnumType)((Object)enumTypes.add())).setName("ioshda" + i);
        }
        IDLSequence.Object<FooGraphicObjectMessage> graphicObjects = fooHandshake.getGraphicObjects();
        for (int i = 0; i < 2000; ++i) {
            int j;
            FooGraphicObjectMessage fooGraphicObjectMessage = (FooGraphicObjectMessage)((Object)graphicObjects.add());
            fooGraphicObjectMessage.setName("asodjao" + i);
            fooGraphicObjectMessage.setRegistrationID(random.nextInt());
            for (j = 0; j < 70; ++j) {
                fooGraphicObjectMessage.getConstants().add(random.nextDouble());
            }
            for (j = 0; j < 700; ++j) {
                fooGraphicObjectMessage.getYoVariableIndex().add(random.nextInt(65535));
            }
            FooAppearanceDefinitionMessage appearance = fooGraphicObjectMessage.getAppearance();
            appearance.setB(255.0);
            appearance.setG(255.0);
            appearance.setR(255.0);
        }
        IDLSequence.Object<FooJointDefinition> joints = fooHandshake.getJoints();
        for (int i = 0; i < 70; ++i) {
            FooJointDefinition fooJointDefinition = (FooJointDefinition)((Object)joints.add());
            fooJointDefinition.setName("iksaof" + i);
            fooJointDefinition.setType(FooJointType.FooOneDoFJoint);
        }
        IDLSequence.Object<FooYoRegistryDefinition> registries = fooHandshake.getRegistries();
        for (int i = 0; i < 1000; ++i) {
            FooYoRegistryDefinition fooYoRegistryDefinition = (FooYoRegistryDefinition)((Object)registries.add());
            fooYoRegistryDefinition.setName("iasodoiasd" + i);
            fooYoRegistryDefinition.setParent(random.nextInt(65535));
        }
        IDLSequence.Object<FooYoVariableDefinition> variables = fooHandshake.getVariables();
        for (int i = 0; i < 30000; ++i) {
            FooYoVariableDefinition fooYoVariableDefinition = (FooYoVariableDefinition)((Object)variables.add());
            fooYoVariableDefinition.setAllowNullValues(random.nextBoolean());
            fooYoVariableDefinition.setDescription("Diosfopjka" + i);
            fooYoVariableDefinition.setEnumType(random.nextInt(65535));
            fooYoVariableDefinition.setIsParameter(random.nextBoolean());
            fooYoVariableDefinition.setLoadStatus(FooLoadStatus.FooLoaded);
            fooYoVariableDefinition.setMax(random.nextDouble());
            fooYoVariableDefinition.setMin(random.nextDouble());
            fooYoVariableDefinition.setRegistry(random.nextInt(65535));
            fooYoVariableDefinition.setType(FooYoType.FooDoubleYoVariable);
        }
        return fooHandshake;
    }

    private class ParticipantListenerImpl
    implements ParticipantListener {
        private ParticipantListenerImpl() {
        }

        public void onParticipantDiscovery(Participant participant, ParticipantDiscoveryInfo info) {
            System.out.println("New participant discovered");
            System.out.println("Status: " + info.getStatus());
            System.out.println("Guid: " + info.getGuid().toString());
            System.out.println("Name: " + info.getName());
        }
    }

    private class SubscriberListenerImpl
    implements SubscriberListener {
        private final SampleInfo info = new SampleInfo();
        public final FooHandshake[] receivedMessages = new FooHandshake[8];
        public int i;

        private SubscriberListenerImpl() {
            for (int i = 0; i < this.receivedMessages.length; ++i) {
                this.receivedMessages[i] = new FooHandshake();
            }
            this.i = 0;
        }

        public void onNewDataMessage(Subscriber subscriber) {
            if (subscriber.takeNextData((Object)this.receivedMessages[this.i++], this.info)) {
                // empty if block
            }
        }

        public void onSubscriptionMatched(Subscriber subscriber, MatchingInfo info) {
            System.out.println("New publisher matched");
            System.out.println("Status: " + info.getStatus());
            System.out.println("Guid: " + info.getGuid().toString());
        }
    }

    private class PublisherListenerImpl
    implements PublisherListener {
        private PublisherListenerImpl() {
        }

        public void onPublicationMatched(Publisher publisher, MatchingInfo info) {
            System.out.println("New subscriber matched");
            System.out.println("Status: " + info.getStatus());
            System.out.println("Guid: " + info.getGuid().toString());
        }
    }
}

