/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.tools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.function.Supplier;
import us.ihmc.communication.packets.Packet;
import us.ihmc.idl.generated.test.IDLElementTestPubSubType;
import us.ihmc.pubsub.Domain;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.DurabilityKind;
import us.ihmc.pubsub.attributes.HistoryQosPolicy;
import us.ihmc.pubsub.attributes.ParticipantAttributes;
import us.ihmc.pubsub.attributes.PublishModeKind;
import us.ihmc.pubsub.attributes.PublisherAttributes;
import us.ihmc.pubsub.attributes.ReliabilityKind;
import us.ihmc.pubsub.attributes.SubscriberAttributes;
import us.ihmc.pubsub.common.LogLevel;
import us.ihmc.pubsub.common.Time;
import us.ihmc.pubsub.participant.Participant;
import us.ihmc.pubsub.participant.ParticipantListener;
import us.ihmc.pubsub.publisher.Publisher;
import us.ihmc.pubsub.publisher.PublisherListener;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.pubsub.tools.MessageCallback;
import us.ihmc.pubsub.tools.ParticipantListenerImpl;
import us.ihmc.pubsub.tools.PublishSubscribeTools;
import us.ihmc.pubsub.tools.PublisherListenerImpl;
import us.ihmc.pubsub.tools.SubscriberListenerImpl;

public class PubSubTester<P extends Packet> {
    public Domain domain;
    public Subscriber subscriber;
    public Publisher publisher;
    public ArrayList<MessageCallback<P>> callbacks = new ArrayList();

    public PubSubTester(Supplier<P> msgTypeSupplier) throws IOException {
        this(DomainFactory.PubSubImplementation.FAST_RTPS, msgTypeSupplier);
    }

    public PubSubTester(DomainFactory.PubSubImplementation pubSubImplementation, Supplier<P> msgTypeSupplier) throws IOException {
        this.domain = DomainFactory.getDomain((DomainFactory.PubSubImplementation)pubSubImplementation);
        this.domain.setLogLevel(LogLevel.INFO);
        ParticipantAttributes attributes = this.domain.createParticipantAttributes();
        attributes.setDomainId(PublishSubscribeTools.systemDomain());
        attributes.setLeaseDuration(Time.Infinite);
        attributes.setName("PubSubTester");
        Participant participant = this.domain.createParticipant(attributes, (ParticipantListener)new ParticipantListenerImpl());
        IDLElementTestPubSubType dataType = new IDLElementTestPubSubType();
        this.domain.registerType(participant, (TopicDataType)dataType);
        PublisherAttributes publisherAttributes = this.domain.createPublisherAttributes(participant, (TopicDataType)dataType, "pubsubtest", ReliabilityKind.RELIABLE, new String[0]);
        publisherAttributes.getQos().setDurabilityKind(DurabilityKind.VOLATILE_DURABILITY_QOS);
        publisherAttributes.getTopic().getHistoryQos().setKind(HistoryQosPolicy.HistoryQosPolicyKind.KEEP_LAST_HISTORY_QOS);
        publisherAttributes.getTopic().getHistoryQos().setDepth(1);
        publisherAttributes.getQos().setPublishMode(PublishModeKind.ASYNCHRONOUS_PUBLISH_MODE);
        Packet data = (Packet)msgTypeSupplier.get();
        TopicDataType topicDataType = (TopicDataType)data.getPubSubTypePacket().get();
        SubscriberAttributes subscriberAttributes = this.domain.createSubscriberAttributes(participant, topicDataType, "pubsubtest", ReliabilityKind.RELIABLE, new String[0]);
        subscriberAttributes.getTopic().getHistoryQos().setDepth(1);
        subscriberAttributes.getQos().setDurabilityKind(DurabilityKind.VOLATILE_DURABILITY_QOS);
        subscriberAttributes.getTopic().getHistoryQos().setKind(HistoryQosPolicy.HistoryQosPolicyKind.KEEP_ALL_HISTORY_QOS);
        this.subscriber = this.domain.createSubscriber(participant, subscriberAttributes, new SubscriberListenerImpl<Packet>(data, this.callbacks));
        this.publisher = this.domain.createPublisher(participant, publisherAttributes, (PublisherListener)new PublisherListenerImpl());
    }
}

