/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.idl.generated.test.BigMessage;
import us.ihmc.idl.generated.test.BigMessagePubSubType;
import us.ihmc.idl.generated.test.IDLSubmessage;
import us.ihmc.pubsub.Domain;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.DurabilityKind;
import us.ihmc.pubsub.attributes.HistoryQosPolicy;
import us.ihmc.pubsub.attributes.ParticipantAttributes;
import us.ihmc.pubsub.attributes.PublishModeKind;
import us.ihmc.pubsub.attributes.PublisherAttributes;
import us.ihmc.pubsub.attributes.ReliabilityKind;
import us.ihmc.pubsub.attributes.SubscriberAttributes;
import us.ihmc.pubsub.common.LogLevel;
import us.ihmc.pubsub.common.MatchingInfo;
import us.ihmc.pubsub.common.SampleInfo;
import us.ihmc.pubsub.common.Time;
import us.ihmc.pubsub.participant.Participant;
import us.ihmc.pubsub.participant.ParticipantDiscoveryInfo;
import us.ihmc.pubsub.participant.ParticipantListener;
import us.ihmc.pubsub.publisher.Publisher;
import us.ihmc.pubsub.publisher.PublisherListener;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.pubsub.subscriber.SubscriberListener;

public class IntraprocessLargeCopyTest {
    @Test
    public void testRepeatedLargeCopiesInFastRTPSCallbacks() throws IOException, InterruptedException {
        Random random = new Random(981239012380L);
        DomainFactory.PubSubImplementation impl = DomainFactory.PubSubImplementation.FAST_RTPS;
        this.performCopyTest(random, impl);
    }

    @Test
    public void testRepeatedLargeCopiesInIntraprocessCallbacks() throws IOException, InterruptedException {
        Random random = new Random(981239012380L);
        DomainFactory.PubSubImplementation impl = DomainFactory.PubSubImplementation.INTRAPROCESS;
        this.performCopyTest(random, impl);
    }

    private void performCopyTest(Random random, DomainFactory.PubSubImplementation impl) throws InterruptedException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream systemErr = System.err;
        System.setErr(new PrintStream(byteArrayOutputStream));
        Thread subscriberThread = new Thread(() -> {
            try {
                this.createSubscriber(impl);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }, "SubscriberThread");
        subscriberThread.start();
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int i = 0; i < 5; ++i) {
            Thread publisherThread = new Thread(() -> {
                try {
                    Publisher publisher = this.createPublisher(impl);
                    this.publishABunch(publisher, random);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }, "PublisherThread");
            publisherThread.start();
            threads.add(publisherThread);
        }
        threads.stream().forEach(thread -> {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        });
        subscriberThread.join();
        ThreadTools.sleep((long)5000L);
        System.err.flush();
        System.setErr(systemErr);
        System.err.println(byteArrayOutputStream.toString());
        Assertions.assertFalse((boolean)byteArrayOutputStream.toString().contains("IndexOutOfBoundsException"), (String)"Standard error contains java.lang.IndexOutOfBoundsException");
    }

    private Publisher createPublisher(DomainFactory.PubSubImplementation impl) throws IOException {
        Domain domain = DomainFactory.getDomain((DomainFactory.PubSubImplementation)impl);
        domain.setLogLevel(LogLevel.ERROR);
        ParticipantAttributes attributes = domain.createParticipantAttributes();
        attributes.setDomainId(215);
        attributes.setLeaseDuration(Time.Infinite);
        attributes.setName("StatusTest");
        Participant participant = domain.createParticipant(attributes, (ParticipantListener)new ParticipantListenerImpl());
        BigMessagePubSubType dataType = new BigMessagePubSubType();
        domain.registerType(participant, (TopicDataType)dataType);
        PublisherAttributes publisherAttributes = domain.createPublisherAttributes(participant, (TopicDataType)dataType, "Status", ReliabilityKind.RELIABLE, new String[]{"us/ihmc"});
        publisherAttributes.getQos().setDurabilityKind(DurabilityKind.VOLATILE_DURABILITY_QOS);
        publisherAttributes.getTopic().getHistoryQos().setKind(HistoryQosPolicy.HistoryQosPolicyKind.KEEP_LAST_HISTORY_QOS);
        publisherAttributes.getTopic().getHistoryQos().setDepth(10);
        publisherAttributes.getQos().setPublishMode(PublishModeKind.ASYNCHRONOUS_PUBLISH_MODE);
        return domain.createPublisher(participant, publisherAttributes, (PublisherListener)new PublisherListenerImpl());
    }

    private Subscriber createSubscriber(DomainFactory.PubSubImplementation impl) throws IOException {
        Domain domain = DomainFactory.getDomain((DomainFactory.PubSubImplementation)impl);
        domain.setLogLevel(LogLevel.ERROR);
        ParticipantAttributes attributes = domain.createParticipantAttributes();
        attributes.setDomainId(215);
        attributes.setLeaseDuration(Time.Infinite);
        attributes.setName("StatusTest");
        Participant participant = domain.createParticipant(attributes, (ParticipantListener)new ParticipantListenerImpl());
        BigMessagePubSubType dataType = new BigMessagePubSubType();
        domain.registerType(participant, (TopicDataType)dataType);
        PublisherAttributes publisherAttributes = domain.createPublisherAttributes(participant, (TopicDataType)dataType, "Status", ReliabilityKind.RELIABLE, new String[]{"us/ihmc"});
        publisherAttributes.getQos().setDurabilityKind(DurabilityKind.VOLATILE_DURABILITY_QOS);
        publisherAttributes.getTopic().getHistoryQos().setKind(HistoryQosPolicy.HistoryQosPolicyKind.KEEP_LAST_HISTORY_QOS);
        publisherAttributes.getTopic().getHistoryQos().setDepth(10);
        publisherAttributes.getQos().setPublishMode(PublishModeKind.ASYNCHRONOUS_PUBLISH_MODE);
        BigMessagePubSubType dataType2 = new BigMessagePubSubType();
        SubscriberAttributes subscriberAttributes = domain.createSubscriberAttributes(participant, (TopicDataType)dataType2, "Status", ReliabilityKind.RELIABLE, new String[]{"us/ihmc"});
        subscriberAttributes.getQos().setDurabilityKind(DurabilityKind.TRANSIENT_LOCAL_DURABILITY_QOS);
        subscriberAttributes.getTopic().getHistoryQos().setKind(HistoryQosPolicy.HistoryQosPolicyKind.KEEP_ALL_HISTORY_QOS);
        return domain.createSubscriber(participant, subscriberAttributes, (SubscriberListener)new SubscriberListenerImpl());
    }

    private void publishABunch(Publisher publisher, Random random) throws IOException {
        for (int i = 0; i < 20; ++i) {
            BigMessage msg = new BigMessage();
            IDLSubmessage idlSubmessage = new IDLSubmessage();
            int randomSize = random.nextInt(100000);
            for (int j = 0; j < randomSize; ++j) {
                idlSubmessage.setHello(i + j);
                ((IDLSubmessage)((Object)msg.getLargeSequence().add())).set(idlSubmessage);
            }
            publisher.write((Object)msg);
        }
    }

    private class ParticipantListenerImpl
    implements ParticipantListener {
        private ParticipantListenerImpl() {
        }

        public void onParticipantDiscovery(Participant participant, ParticipantDiscoveryInfo info) {
            System.out.println("New participant discovered");
            System.out.println("Status: " + info.getStatus());
            System.out.println("Guid: " + info.getGuid().toString());
            System.out.println("Name: " + info.getName());
        }
    }

    private class PublisherListenerImpl
    implements PublisherListener {
        private PublisherListenerImpl() {
        }

        public void onPublicationMatched(Publisher publisher, MatchingInfo info) {
            System.out.println("New subscriber matched");
            System.out.println("Status: " + info.getStatus());
            System.out.println("Guid: " + info.getGuid().toString());
        }
    }

    private class SubscriberListenerImpl
    implements SubscriberListener {
        private final BigMessage data = new BigMessage();
        private final SampleInfo info = new SampleInfo();
        int i = 0;

        private SubscriberListenerImpl() {
        }

        public void onNewDataMessage(Subscriber subscriber) {
            if (subscriber.takeNextData((Object)this.data, this.info)) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                BigMessage copied = new BigMessage();
                copied.set(this.data);
                System.out.println("Received: " + this.i++ + " Copied size: " + copied.getLargeSequence().size());
            }
        }

        public void onSubscriptionMatched(Subscriber subscriber, MatchingInfo info) {
            System.out.println("New publisher matched");
            System.out.println("Status: " + info.getStatus());
            System.out.println("Guid: " + info.getGuid().toString());
        }
    }
}

