/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.examples;

import java.io.IOException;
import us.ihmc.idl.generated.chat.ChatMessage;
import us.ihmc.idl.generated.chat.ChatMessagePubSubType;
import us.ihmc.pubsub.Domain;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.DurabilityKind;
import us.ihmc.pubsub.attributes.HistoryQosPolicy;
import us.ihmc.pubsub.attributes.ParticipantAttributes;
import us.ihmc.pubsub.attributes.ReliabilityKind;
import us.ihmc.pubsub.attributes.SubscriberAttributes;
import us.ihmc.pubsub.common.LogLevel;
import us.ihmc.pubsub.common.MatchingInfo;
import us.ihmc.pubsub.common.SampleInfo;
import us.ihmc.pubsub.common.Time;
import us.ihmc.pubsub.participant.Participant;
import us.ihmc.pubsub.participant.ParticipantDiscoveryInfo;
import us.ihmc.pubsub.participant.ParticipantListener;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.pubsub.subscriber.SubscriberListener;

public class SubscriberExample {
    public SubscriberExample() throws IOException {
        Domain domain = DomainFactory.getDomain((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS);
        domain.setLogLevel(LogLevel.INFO);
        ParticipantAttributes attributes = domain.createParticipantAttributes();
        attributes.setDomainId(215);
        attributes.setLeaseDuration(Time.Infinite);
        attributes.setName("SubscriberExample");
        Participant participant = domain.createParticipant(attributes, (ParticipantListener)new ParticipantListenerImpl());
        ChatMessagePubSubType dataType = new ChatMessagePubSubType();
        domain.registerType(participant, (TopicDataType)dataType);
        SubscriberAttributes subscriberAttributes = domain.createSubscriberAttributes(participant, (TopicDataType)dataType, "ChatBox1", ReliabilityKind.BEST_EFFORT, new String[]{"us/ihmc"});
        subscriberAttributes.getQos().setDurabilityKind(DurabilityKind.TRANSIENT_LOCAL_DURABILITY_QOS);
        subscriberAttributes.getTopic().getHistoryQos().setKind(HistoryQosPolicy.HistoryQosPolicyKind.KEEP_ALL_HISTORY_QOS);
        Subscriber subscriber = domain.createSubscriber(participant, subscriberAttributes, (SubscriberListener)new SubscriberListenerImpl());
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        new SubscriberExample();
        Thread.currentThread().join();
    }

    private class ParticipantListenerImpl
    implements ParticipantListener {
        private ParticipantListenerImpl() {
        }

        public void onParticipantDiscovery(Participant participant, ParticipantDiscoveryInfo info) {
            System.out.println("New participant discovered");
            System.out.println("Status: " + info.getStatus());
            System.out.println("Guid: " + info.getGuid().toString());
            System.out.println("Name: " + info.getName());
        }
    }

    private class SubscriberListenerImpl
    implements SubscriberListener {
        private final ChatMessage data = new ChatMessage();
        private final SampleInfo info = new SampleInfo();

        private SubscriberListenerImpl() {
        }

        public void onNewDataMessage(Subscriber subscriber) {
            if (subscriber.takeNextData((Object)this.data, this.info)) {
                System.out.println(this.data.getSender().toString() + ": " + this.data.getMsg().toString());
            }
        }

        public void onSubscriptionMatched(Subscriber subscriber, MatchingInfo info) {
            System.out.println("New publisher matched");
            System.out.println("Status: " + info.getStatus());
            System.out.println("Guid: " + info.getGuid().toString());
        }
    }
}

