/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.examples;

import java.io.IOException;
import java.util.ArrayList;
import us.ihmc.pubsub.Domain;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.pubsub.attributes.Locator;
import us.ihmc.pubsub.attributes.ParticipantAttributes;
import us.ihmc.pubsub.attributes.ReaderQosHolder;
import us.ihmc.pubsub.attributes.TopicAttributes;
import us.ihmc.pubsub.attributes.WriterQosHolder;
import us.ihmc.pubsub.common.Guid;
import us.ihmc.pubsub.common.Time;
import us.ihmc.pubsub.participant.Participant;
import us.ihmc.pubsub.participant.ParticipantDiscoveryInfo;
import us.ihmc.pubsub.participant.ParticipantListener;
import us.ihmc.pubsub.participant.PublisherEndpointDiscoveryListener;
import us.ihmc.pubsub.participant.SubscriberEndpointDiscoveryListener;

public class EndpointDiscoveryProtocolListenerExample {
    public EndpointDiscoveryProtocolListenerExample() throws IOException {
        Domain domain = DomainFactory.getDomain((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS);
        ParticipantAttributes attributes = domain.createParticipantAttributes();
        attributes.setDomainId(215);
        attributes.setLeaseDuration(Time.Infinite);
        attributes.setName("EndpointDiscoveryProtocolListenerExample");
        Participant participant = domain.createParticipant(attributes, (ParticipantListener)new ParticipantListenerImpl());
        participant.registerEndpointDiscoveryListeners((PublisherEndpointDiscoveryListener)new PublisherEndpointDiscoveryListenerImpl(), (SubscriberEndpointDiscoveryListener)new SubscriberEndpointDiscoveryListenerImpl());
    }

    public static void main(String[] args) throws IOException {
        new EndpointDiscoveryProtocolListenerExample();
        while (true) {
            try {
                while (true) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private class ParticipantListenerImpl
    implements ParticipantListener {
        private ParticipantListenerImpl() {
        }

        public void onParticipantDiscovery(Participant participant, ParticipantDiscoveryInfo info) {
            System.out.println("New participant discovered");
            System.out.println("Status: " + info.getStatus());
            System.out.println("Guid: " + info.getGuid().toString());
            System.out.println("Name: " + info.getName());
        }
    }

    private class PublisherEndpointDiscoveryListenerImpl
    implements PublisherEndpointDiscoveryListener {
        private PublisherEndpointDiscoveryListenerImpl() {
        }

        public void publisherTopicChange(boolean isAlive, Guid guid, ArrayList<Locator> unicastLocatorList, ArrayList<Locator> multicastLocatorList, Guid participantGuid, String typeName, String topicName, int userDefinedId, long typeMaxSerialized, TopicAttributes.TopicKind topicKind, WriterQosHolder writerQosHolder) {
            System.out.println("New publisher topic change");
            System.out.println("Is alive: " + isAlive);
            System.out.println("GUID: " + guid);
            System.out.println("ParticipantGUID: " + participantGuid);
            System.out.println("TypeName: " + typeName);
            System.out.println("TopicName: " + topicName);
        }
    }

    private class SubscriberEndpointDiscoveryListenerImpl
    implements SubscriberEndpointDiscoveryListener {
        private SubscriberEndpointDiscoveryListenerImpl() {
        }

        public void subscriberTopicChange(boolean isAlive, Guid guid, boolean expectsInlineQos, ArrayList<Locator> unicastLocatorList, ArrayList<Locator> multicastLocatorList, Guid participantGuid, String typeName, String topicName, int userDefinedId, TopicAttributes.TopicKind javaTopicKind, ReaderQosHolder readerQosHolder) {
            System.out.println("New subscriber topic change");
            System.out.println("Is alive: " + isAlive);
            System.out.println("GUID: " + guid);
            System.out.println("ParticipantGUID: " + participantGuid);
            System.out.println("TypeName: " + typeName);
            System.out.println("TopicName: " + topicName);
        }
    }
}

