/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.test;

import java.io.IOException;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.PrintTools;
import us.ihmc.commons.allocations.AllocationProfiler;
import us.ihmc.commons.allocations.AllocationRecord;
import us.ihmc.idl.generated.test.StatusMessage;
import us.ihmc.idl.generated.test.StatusMessagePubSubType;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.Domain;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.DurabilityKind;
import us.ihmc.pubsub.attributes.HistoryQosPolicy;
import us.ihmc.pubsub.attributes.ParticipantAttributes;
import us.ihmc.pubsub.attributes.PublishModeKind;
import us.ihmc.pubsub.attributes.PublisherAttributes;
import us.ihmc.pubsub.attributes.ReliabilityKind;
import us.ihmc.pubsub.attributes.SubscriberAttributes;
import us.ihmc.pubsub.common.LogLevel;
import us.ihmc.pubsub.common.MatchingInfo;
import us.ihmc.pubsub.common.SampleInfo;
import us.ihmc.pubsub.common.Time;
import us.ihmc.pubsub.participant.Participant;
import us.ihmc.pubsub.participant.ParticipantDiscoveryInfo;
import us.ihmc.pubsub.participant.ParticipantListener;
import us.ihmc.pubsub.publisher.Publisher;
import us.ihmc.pubsub.publisher.PublisherListener;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.pubsub.subscriber.SubscriberListener;

public class PublishSubscribeUInt64AllocationTest {
    public static final int NUMBER_OF_MESSAGES_TO_SEND = 30;

    @Tag(value="allocation")
    @Test
    public void testPublishSubscribeUInt32AllocationsFastRTPS() throws IOException {
        this.runAllocationTest(DomainFactory.PubSubImplementation.FAST_RTPS);
    }

    @Disabled
    @Tag(value="allocation")
    @Test
    public void testPublishSubscribeUInt32AllocationsIntraprocess() throws IOException {
        this.runAllocationTest(DomainFactory.PubSubImplementation.INTRAPROCESS);
    }

    public void runAllocationTest(DomainFactory.PubSubImplementation pubSubImplementation) throws IOException {
        AllocationProfiler allocationProfiler = new AllocationProfiler();
        Domain domain = DomainFactory.getDomain((DomainFactory.PubSubImplementation)pubSubImplementation);
        domain.setLogLevel(LogLevel.INFO);
        ParticipantAttributes attributes = domain.createParticipantAttributes();
        attributes.setDomainId(215);
        attributes.setLeaseDuration(Time.Infinite);
        attributes.setName("StatusTest");
        Participant participant = domain.createParticipant(attributes, (ParticipantListener)new ParticipantListenerImpl());
        StatusMessagePubSubType dataType = new StatusMessagePubSubType();
        domain.registerType(participant, (TopicDataType)dataType);
        PublisherAttributes publisherAttributes = domain.createPublisherAttributes(participant, (TopicDataType)dataType, "Status", ReliabilityKind.RELIABLE, new String[]{"us/ihmc"});
        publisherAttributes.getQos().setDurabilityKind(pubSubImplementation == DomainFactory.PubSubImplementation.INTRAPROCESS ? DurabilityKind.VOLATILE_DURABILITY_QOS : DurabilityKind.TRANSIENT_LOCAL_DURABILITY_QOS);
        publisherAttributes.getTopic().getHistoryQos().setKind(HistoryQosPolicy.HistoryQosPolicyKind.KEEP_LAST_HISTORY_QOS);
        publisherAttributes.getTopic().getHistoryQos().setDepth(50);
        publisherAttributes.getQos().setPublishMode(PublishModeKind.ASYNCHRONOUS_PUBLISH_MODE);
        StatusMessagePubSubType dataType2 = new StatusMessagePubSubType();
        SubscriberAttributes subscriberAttributes = domain.createSubscriberAttributes(participant, (TopicDataType)dataType2, "Status", ReliabilityKind.RELIABLE, new String[]{"us/ihmc"});
        subscriberAttributes.getQos().setDurabilityKind(pubSubImplementation == DomainFactory.PubSubImplementation.INTRAPROCESS ? DurabilityKind.VOLATILE_DURABILITY_QOS : DurabilityKind.VOLATILE_DURABILITY_QOS);
        subscriberAttributes.getTopic().getHistoryQos().setKind(HistoryQosPolicy.HistoryQosPolicyKind.KEEP_ALL_HISTORY_QOS);
        SubscriberListenerImpl subscriberListener = new SubscriberListenerImpl();
        Subscriber subscriber = domain.createSubscriber(participant, subscriberAttributes, (SubscriberListener)subscriberListener);
        Publisher publisher = domain.createPublisher(participant, publisherAttributes, (PublisherListener)new PublisherListenerImpl());
        StatusMessage msg = new StatusMessage();
        msg.setPause(false);
        msg.setSequenceId(0L);
        this.publishNMessages(publisher, msg, 1);
        allocationProfiler.startRecordingAllocations();
        this.publishNMessages(publisher, msg, 30);
        allocationProfiler.stopRecordingAllocations();
        for (StatusMessage message : subscriberListener.receivedMessages) {
            if (message == null) continue;
            PrintTools.info((Object)this, (String)("Message received: " + message.toString()));
        }
        List allocations = allocationProfiler.pollAllocations();
        String message = "";
        for (AllocationRecord allocation : allocations) {
            message = message + allocation.toString() + "\n";
        }
        System.out.println(message);
        Assertions.assertTrue((allocations.size() == 0 ? 1 : 0) != 0, (String)("allocated " + allocations.size() + ": \n" + message));
    }

    private void publishNMessages(Publisher publisher, StatusMessage msg, int numberOfMessagesToSend) throws IOException {
        for (int i = 0; i < numberOfMessagesToSend; ++i) {
            try {
                msg.setPause(i % 2 == 0);
                msg.setSequenceId(i);
                publisher.write((Object)msg);
                Thread.sleep(1000L);
                ++i;
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class PublisherListenerImpl
    implements PublisherListener {
        private PublisherListenerImpl() {
        }

        public void onPublicationMatched(Publisher publisher, MatchingInfo info) {
            LogTools.debug((String)"New subscriber matched");
            LogTools.debug((String)("Status: " + info.getStatus()));
            LogTools.debug((String)("Guid: " + info.getGuid().toString()));
        }
    }

    private class ParticipantListenerImpl
    implements ParticipantListener {
        private ParticipantListenerImpl() {
        }

        public void onParticipantDiscovery(Participant participant, ParticipantDiscoveryInfo info) {
            LogTools.debug((String)"New participant discovered");
            LogTools.debug((String)("Status: " + info.getStatus()));
            LogTools.debug((String)("Guid: " + info.getGuid().toString()));
            LogTools.debug((String)("Name: " + info.getName()));
        }
    }

    private class SubscriberListenerImpl
    implements SubscriberListener {
        private final SampleInfo info = new SampleInfo();
        public final StatusMessage[] receivedMessages = new StatusMessage[30];
        public int i;

        private SubscriberListenerImpl() {
            for (int i = 0; i < 30; ++i) {
                this.receivedMessages[i] = new StatusMessage();
            }
            this.i = 0;
        }

        public void onNewDataMessage(Subscriber subscriber) {
            if (subscriber.takeNextData((Object)this.receivedMessages[this.i++], this.info)) {
                // empty if block
            }
        }

        public void onSubscriptionMatched(Subscriber subscriber, MatchingInfo info) {
            LogTools.debug((String)"New publisher matched");
            LogTools.debug((String)("Status: " + info.getStatus()));
            LogTools.debug((String)("Guid: " + info.getGuid().toString()));
        }
    }
}

