/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.test;

import java.io.IOException;
import us.ihmc.idl.generated.chat.ChatMessage;
import us.ihmc.idl.generated.chat.ChatMessagePubSubType;
import us.ihmc.pubsub.Domain;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.DurabilityKind;
import us.ihmc.pubsub.attributes.HistoryQosPolicy;
import us.ihmc.pubsub.attributes.ParticipantAttributes;
import us.ihmc.pubsub.attributes.PublishModeKind;
import us.ihmc.pubsub.attributes.PublisherAttributes;
import us.ihmc.pubsub.attributes.ReliabilityKind;
import us.ihmc.pubsub.common.LogLevel;
import us.ihmc.pubsub.common.MatchingInfo;
import us.ihmc.pubsub.common.Time;
import us.ihmc.pubsub.participant.Participant;
import us.ihmc.pubsub.participant.ParticipantDiscoveryInfo;
import us.ihmc.pubsub.participant.ParticipantListener;
import us.ihmc.pubsub.publisher.Publisher;
import us.ihmc.pubsub.publisher.PublisherListener;

public class AggressivePublisher {
    public AggressivePublisher() throws IOException {
        Domain domain = DomainFactory.getDomain((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS);
        domain.setLogLevel(LogLevel.INFO);
        ParticipantAttributes attributes = domain.createParticipantAttributes();
        attributes.setDomainId(215);
        attributes.setLeaseDuration(Time.Infinite);
        attributes.setName("AggressivePublisher");
        Participant participant = domain.createParticipant(attributes, (ParticipantListener)new ParticipantListenerImpl());
        ChatMessagePubSubType dataType = new ChatMessagePubSubType();
        domain.registerType(participant, (TopicDataType)dataType);
        PublisherAttributes publisherAttributes = domain.createPublisherAttributes(participant, (TopicDataType)dataType, "segfault_trigger", ReliabilityKind.RELIABLE, new String[]{"us/ihmc"});
        publisherAttributes.getQos().setDurabilityKind(DurabilityKind.VOLATILE_DURABILITY_QOS);
        publisherAttributes.getTopic().getHistoryQos().setKind(HistoryQosPolicy.HistoryQosPolicyKind.KEEP_LAST_HISTORY_QOS);
        publisherAttributes.getTopic().getHistoryQos().setDepth(1);
        publisherAttributes.getQos().setPublishMode(PublishModeKind.ASYNCHRONOUS_PUBLISH_MODE);
        Publisher publisher = domain.createPublisher(participant, publisherAttributes, (PublisherListener)new PublisherListenerImpl());
        ChatMessage msg = new ChatMessage();
        msg.setSender("Java");
        String longMessage = "AReallyLongStringIGuessOkayMaybeItsNotLikeThatLongButWhateverItGetsTheJobDoneMaybe";
        msg.setMsg(longMessage);
        int i = 0;
        while (true) {
            msg.setSender("Hello World " + i++);
            msg.setMsg(longMessage);
            publisher.write((Object)msg);
        }
    }

    public static void main(String[] args) throws IOException {
        new AggressivePublisher();
    }

    private class PublisherListenerImpl
    implements PublisherListener {
        private PublisherListenerImpl() {
        }

        public void onPublicationMatched(Publisher publisher, MatchingInfo info) {
            System.out.println("New subscriber matched");
            System.out.println("Status: " + info.getStatus());
            System.out.println("Guid: " + info.getGuid().toString());
        }
    }

    private class ParticipantListenerImpl
    implements ParticipantListener {
        private ParticipantListenerImpl() {
        }

        public void onParticipantDiscovery(Participant participant, ParticipantDiscoveryInfo info) {
            System.out.println("New participant discovered");
            System.out.println("Status: " + info.getStatus());
            System.out.println("Guid: " + info.getGuid().toString());
            System.out.println("Name: " + info.getName());
        }
    }
}

