/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.examples;

import java.io.IOException;
import us.ihmc.idl.generated.chat.ChatMessage;
import us.ihmc.idl.generated.chat.ChatMessagePubSubType;
import us.ihmc.pubsub.Domain;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.DurabilityKind;
import us.ihmc.pubsub.attributes.HistoryQosPolicy;
import us.ihmc.pubsub.attributes.ParticipantAttributes;
import us.ihmc.pubsub.attributes.PublishModeKind;
import us.ihmc.pubsub.attributes.PublisherAttributes;
import us.ihmc.pubsub.attributes.ReliabilityKind;
import us.ihmc.pubsub.common.LogLevel;
import us.ihmc.pubsub.common.MatchingInfo;
import us.ihmc.pubsub.common.Time;
import us.ihmc.pubsub.participant.Participant;
import us.ihmc.pubsub.participant.ParticipantDiscoveryInfo;
import us.ihmc.pubsub.participant.ParticipantListener;
import us.ihmc.pubsub.publisher.Publisher;
import us.ihmc.pubsub.publisher.PublisherListener;
import us.ihmc.rtps.impl.fastRTPS.FastRTPSPublisherAttributes;
import us.ihmc.rtps.impl.fastRTPS.Time_t;

public class PublisherExample {
    public PublisherExample() throws IOException {
        Domain domain = DomainFactory.getDomain((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS);
        domain.setLogLevel(LogLevel.INFO);
        ParticipantAttributes attributes = domain.createParticipantAttributes();
        attributes.setDomainId(215);
        attributes.setLeaseDuration(Time.Infinite);
        attributes.setName("PublisherExample");
        Participant participant = domain.createParticipant(attributes, (ParticipantListener)new ParticipantListenerImpl());
        ChatMessagePubSubType dataType = new ChatMessagePubSubType();
        domain.registerType(participant, (TopicDataType)dataType);
        PublisherAttributes publisherAttributes = domain.createPublisherAttributes(participant, (TopicDataType)dataType, "ChatBox1", ReliabilityKind.RELIABLE, new String[]{"us/ihmc"});
        publisherAttributes.getQos().setDurabilityKind(DurabilityKind.TRANSIENT_LOCAL_DURABILITY_QOS);
        publisherAttributes.getTopic().getHistoryQos().setKind(HistoryQosPolicy.HistoryQosPolicyKind.KEEP_LAST_HISTORY_QOS);
        publisherAttributes.getTopic().getHistoryQos().setDepth(50);
        publisherAttributes.getQos().setPublishMode(PublishModeKind.ASYNCHRONOUS_PUBLISH_MODE);
        if (publisherAttributes instanceof FastRTPSPublisherAttributes) {
            FastRTPSPublisherAttributes fastRTPSPublisherAttributes = (FastRTPSPublisherAttributes)publisherAttributes;
            Time_t heartbeatPeriod = new Time_t();
            heartbeatPeriod.setSeconds(0);
            long nsec = 100000000L;
            heartbeatPeriod.setNanosec(nsec);
            fastRTPSPublisherAttributes.getTimes().setHeartbeatPeriod(heartbeatPeriod);
        }
        Publisher publisher = domain.createPublisher(participant, publisherAttributes, (PublisherListener)new PublisherListenerImpl());
        ChatMessage msg = new ChatMessage();
        msg.setSender("Java");
        int i = 0;
        while (true) {
            try {
                while (true) {
                    msg.setMsg("Hello World " + i++);
                    publisher.write((Object)msg);
                    System.out.println("Publishing: " + msg.getMsgAsString());
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) throws IOException {
        new PublisherExample();
    }

    private class PublisherListenerImpl
    implements PublisherListener {
        private PublisherListenerImpl() {
        }

        public void onPublicationMatched(Publisher publisher, MatchingInfo info) {
            System.out.println("New subscriber matched");
            System.out.println("Status: " + info.getStatus());
            System.out.println("Guid: " + info.getGuid().toString());
        }
    }

    private class ParticipantListenerImpl
    implements ParticipantListener {
        private ParticipantListenerImpl() {
        }

        public void onParticipantDiscovery(Participant participant, ParticipantDiscoveryInfo info) {
            System.out.println("New participant discovered");
            System.out.println("Status: " + info.getStatus());
            System.out.println("Guid: " + info.getGuid().toString());
            System.out.println("Name: " + info.getName());
        }
    }
}

