/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.idl.generated.geometry;

import java.io.IOException;
import us.ihmc.idl.CDR;
import us.ihmc.idl.IDLSequence;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.idl.generated.geometry.Vector;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;

public class VectorPubSubType
implements TopicDataType<Vector> {
    public static final String name = "geometry::Vector";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public void serialize(Vector data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        VectorPubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, Vector data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        VectorPubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return VectorPubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 128 + 1;
        current_alignment += 8 + CDR.alignment((int)current_alignment, (int)8);
        current_alignment += 8 + CDR.alignment((int)current_alignment, (int)8);
        current_alignment += 8 + CDR.alignment((int)current_alignment, (int)8);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 800 + CDR.alignment((int)current_alignment, (int)8);
        current_alignment += 24 + CDR.alignment((int)current_alignment, (int)8);
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(Vector data) {
        return VectorPubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(Vector data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getFrame().length() + 1;
        current_alignment += 8 + CDR.alignment((int)current_alignment, (int)8);
        current_alignment += 8 + CDR.alignment((int)current_alignment, (int)8);
        current_alignment += 8 + CDR.alignment((int)current_alignment, (int)8);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += data.getBla().size() * 8 + CDR.alignment((int)current_alignment, (int)8);
        current_alignment += 24 + CDR.alignment((int)current_alignment, (int)8);
        return current_alignment - initial_alignment;
    }

    public static void write(Vector data, CDR cdr) {
        if (data.getFrame().length() > 128) {
            throw new RuntimeException("frame field exceeds the maximum length");
        }
        cdr.write_type_d(data.getFrame());
        cdr.write_type_6(data.getX());
        cdr.write_type_6(data.getY());
        cdr.write_type_6(data.getZ());
        if (data.getBla().size() > 100) {
            throw new RuntimeException("bla field exceeds the maximum length");
        }
        cdr.write_type_e((IDLSequence)data.getBla());
        for (int i0 = 0; i0 < data.getWaa().length; ++i0) {
            cdr.write_type_6(data.getWaa()[i0]);
        }
    }

    public static void read(Vector data, CDR cdr) {
        cdr.read_type_d(data.getFrame());
        data.setX(cdr.read_type_6());
        data.setY(cdr.read_type_6());
        data.setZ(cdr.read_type_6());
        cdr.read_type_e((IDLSequence)data.getBla());
        for (int i0 = 0; i0 < data.getWaa().length; ++i0) {
            data.getWaa()[i0] = cdr.read_type_6();
        }
    }

    public final void serialize(Vector data, InterchangeSerializer ser) {
        ser.write_type_d("frame", data.getFrame());
        ser.write_type_6("x", data.getX());
        ser.write_type_6("y", data.getY());
        ser.write_type_6("z", data.getZ());
        ser.write_type_e("bla", (IDLSequence)data.getBla());
        ser.write_type_f("waa", data.getWaa());
    }

    public final void deserialize(InterchangeSerializer ser, Vector data) {
        ser.read_type_d("frame", data.getFrame());
        data.setX(ser.read_type_6("x"));
        data.setY(ser.read_type_6("y"));
        data.setZ(ser.read_type_6("z"));
        ser.read_type_e("bla", (IDLSequence)data.getBla());
        ser.read_type_f("waa", data.getWaa());
    }

    public static void staticCopy(Vector src, Vector dest) {
        dest.set(src);
    }

    public Vector createData() {
        return new Vector();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)VectorPubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(Vector data, CDR cdr) {
        VectorPubSubType.write(data, cdr);
    }

    public void deserialize(Vector data, CDR cdr) {
        VectorPubSubType.read(data, cdr);
    }

    public void copy(Vector src, Vector dest) {
        VectorPubSubType.staticCopy(src, dest);
    }

    public VectorPubSubType newInstance() {
        return new VectorPubSubType();
    }
}

