/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.convexOptimization;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import us.ihmc.convexOptimization.AbstractQpOASESWrapper;
import us.ihmc.tools.nativelibraries.NativeLibraryLoader;

public class QpOASESJNISolver
extends AbstractQpOASESWrapper {
    private long solverID;
    private DoubleBuffer A_Buffer;
    private DoubleBuffer x_Buffer;
    private DoubleBuffer H_Buffer;
    private DoubleBuffer g_Buffer;
    private DoubleBuffer lb_Buffer;
    private DoubleBuffer ub_Buffer;
    private DoubleBuffer lbA_Buffer;
    private DoubleBuffer ubA_Buffer;

    public QpOASESJNISolver(int nvar, int ncon, QPOASESHessianType hessianType, QPOASESSolverOptions solverOption) {
        super(nvar, ncon);
        this.setHessianTypeOrdinal(hessianType.ordinal(), this.solverID);
        this.setSolverOptionOrdinal(solverOption.ordinal(), this.solverID);
        this.reinitializeSolverOptions(this.solverID);
    }

    public QpOASESJNISolver(int nvar, int ncon) {
        this(nvar, ncon, QPOASESHessianType.HST_SEMIDEF, QPOASESSolverOptions.RELIABLE);
    }

    public QpOASESJNISolver() {
        this(1, 1);
    }

    private native int solveJNI(int var1, double var2, long var4);

    private native int hotstartJNI(int var1, double var2, long var4);

    private native void initializeJNI(int var1, int var2, long var3);

    private native long createSolver();

    private native void setHessianTypeOrdinal(int var1, long var2);

    private native void setSolverOptionOrdinal(int var1, long var2);

    private native ByteBuffer get_A_Buffer(long var1);

    private native ByteBuffer get_x_Buffer(long var1);

    private native ByteBuffer get_H_Buffer(long var1);

    private native ByteBuffer get_g_Buffer(long var1);

    private native ByteBuffer get_lb_Buffer(long var1);

    private native ByteBuffer get_ub_Buffer(long var1);

    private native ByteBuffer get_lbA_Buffer(long var1);

    private native ByteBuffer get_ubA_Buffer(long var1);

    private native int getNumberOfWorkingSetChangesFromNative(long var1);

    private native double getCPUTimeFromNative(long var1);

    private native double getObjValueFromNative(long var1);

    private native void reinitializeSolverOptions(long var1);

    @Override
    protected int solveNative(double[] H, double[] g, double[] A, double[] lb, double[] ub, double[] lbA, double[] ubA, int[] nWSR, double[] cputime, double[] x, double[] objVal) {
        this.updateBuffers(H, g, A, lb, ub, lbA, ubA, x);
        int ret = this.solveJNI(nWSR[0], cputime[0], this.solverID);
        this.updateArrays(H, g, A, lb, ub, lbA, ubA, x);
        nWSR[0] = this.getNumberOfWorkingSetChangesFromNative(this.solverID);
        cputime[0] = this.getCPUTimeFromNative(this.solverID);
        objVal[0] = this.getObjValueFromNative(this.solverID);
        return ret;
    }

    @Override
    protected int hotstartNative(double[] H, double[] g, double[] A, double[] lb, double[] ub, double[] lbA, double[] ubA, int[] nWSR, double[] cputime, double[] x, double[] objVal) {
        this.updateBuffers(H, g, A, lb, ub, lbA, ubA, x);
        int ret = this.hotstartJNI(nWSR[0], cputime[0], this.solverID);
        this.updateArrays(H, g, A, lb, ub, lbA, ubA, x);
        nWSR[0] = this.getNumberOfWorkingSetChangesFromNative(this.solverID);
        cputime[0] = this.getCPUTimeFromNative(this.solverID);
        objVal[0] = this.getObjValueFromNative(this.solverID);
        return ret;
    }

    @Override
    protected void initializeNative(int nvar, int ncon) {
        this.solverID = this.createSolver();
        this.initializeJNI(nvar, ncon, this.solverID);
        this.setupBuffers();
    }

    private void setupBuffers() {
        ByteBuffer A_Buffer_asByteBuffer = this.get_A_Buffer(this.solverID);
        A_Buffer_asByteBuffer.order(ByteOrder.nativeOrder());
        this.A_Buffer = A_Buffer_asByteBuffer.asDoubleBuffer();
        ByteBuffer x_Buffer_asByteBuffer = this.get_x_Buffer(this.solverID);
        x_Buffer_asByteBuffer.order(ByteOrder.nativeOrder());
        this.x_Buffer = x_Buffer_asByteBuffer.asDoubleBuffer();
        ByteBuffer H_Buffer_asByteBuffer = this.get_H_Buffer(this.solverID);
        H_Buffer_asByteBuffer.order(ByteOrder.nativeOrder());
        this.H_Buffer = H_Buffer_asByteBuffer.asDoubleBuffer();
        ByteBuffer g_Buffer_asByteBuffer = this.get_g_Buffer(this.solverID);
        g_Buffer_asByteBuffer.order(ByteOrder.nativeOrder());
        this.g_Buffer = g_Buffer_asByteBuffer.asDoubleBuffer();
        ByteBuffer lb_Buffer_asByteBuffer = this.get_lb_Buffer(this.solverID);
        lb_Buffer_asByteBuffer.order(ByteOrder.nativeOrder());
        this.lb_Buffer = lb_Buffer_asByteBuffer.asDoubleBuffer();
        ByteBuffer ub_Buffer_asByteBuffer = this.get_ub_Buffer(this.solverID);
        ub_Buffer_asByteBuffer.order(ByteOrder.nativeOrder());
        this.ub_Buffer = ub_Buffer_asByteBuffer.asDoubleBuffer();
        ByteBuffer lbA_Buffer_asByteBuffer = this.get_lbA_Buffer(this.solverID);
        lbA_Buffer_asByteBuffer.order(ByteOrder.nativeOrder());
        this.lbA_Buffer = lbA_Buffer_asByteBuffer.asDoubleBuffer();
        ByteBuffer ubA_Buffer_asByteBuffer = this.get_ubA_Buffer(this.solverID);
        ubA_Buffer_asByteBuffer.order(ByteOrder.nativeOrder());
        this.ubA_Buffer = ubA_Buffer_asByteBuffer.asDoubleBuffer();
    }

    private void updateBuffers(double[] H, double[] g, double[] A, double[] lb, double[] ub, double[] lbA, double[] ubA, double[] x) {
        this.H_Buffer.clear();
        this.H_Buffer.put(H);
        this.g_Buffer.clear();
        this.g_Buffer.put(g);
        this.A_Buffer.clear();
        this.A_Buffer.put(A);
        this.x_Buffer.clear();
        this.x_Buffer.put(x);
        this.lb_Buffer.clear();
        this.lb_Buffer.put(lb);
        this.ub_Buffer.clear();
        this.ub_Buffer.put(ub);
        this.lbA_Buffer.clear();
        this.lbA_Buffer.put(lbA);
        this.ubA_Buffer.clear();
        this.ubA_Buffer.put(ubA);
    }

    private void updateArrays(double[] H, double[] g, double[] A, double[] lb, double[] ub, double[] lbA, double[] ubA, double[] x) {
        this.H_Buffer.clear();
        this.g_Buffer.clear();
        this.A_Buffer.clear();
        this.x_Buffer.clear();
        this.lb_Buffer.clear();
        this.ub_Buffer.clear();
        this.lbA_Buffer.clear();
        this.ubA_Buffer.clear();
        this.H_Buffer.get(H);
        this.g_Buffer.get(g);
        this.A_Buffer.get(A);
        this.x_Buffer.get(x);
        this.lb_Buffer.get(lb);
        this.ub_Buffer.get(ub);
        this.lbA_Buffer.get(lbA);
        this.ubA_Buffer.get(ubA);
    }

    static {
        NativeLibraryLoader.loadLibrary((String)"us.ihmc.convexOptimization", (String)"IHMCOASESConstrainedQPSolver_rel");
    }

    public static enum QPOASESSolverOptions {
        RELIABLE,
        FAST,
        MPC,
        DEFAULT;

    }

    public static enum QPOASESHessianType {
        HST_ZERO,
        HST_IDENTITY,
        HST_POSDEF,
        HST_POSDEF_NULLSPACE,
        HST_SEMIDEF,
        HST_INDEF,
        HST_UNKNOWN;

    }
}

