/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme;

import com.jme3.app.Application;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.commons.lang3.tuple.ImmutablePair;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.jMonkeyEngineToolkit.jme.JMERayCollisionAdapter;
import us.ihmc.tools.TimestampProvider;

public class JMEMultiRayTracer {
    private static final boolean DEBUG = false;
    private final Application application;
    private long time;
    private final JMERayCollisionAdapter rayCollisionAdapter;
    private String[] childrenToIntersect = null;

    public JMEMultiRayTracer(Application application, Node rootNode) {
        this.application = application;
        this.rayCollisionAdapter = new JMERayCollisionAdapter(rootNode);
    }

    public void setChildrenToIntersect(String[] childrenToIntersect) {
        this.childrenToIntersect = childrenToIntersect;
    }

    public long scan(TimestampProvider timestampProvider, List<? extends Line3DReadOnly> rays, double[] rawRayLengths) {
        try {
            Future<ImmutablePair<Long, Node>> futureRootNode = this.enqueueRootNodeExtracter(timestampProvider);
            ImmutablePair<Long, Node> retVal = futureRootNode.get();
            long timestamp = (Long)retVal.getLeft();
            Node rootNode = (Node)retVal.getRight();
            if (this.childrenToIntersect != null) {
                ArrayList<Node> children = new ArrayList<Node>();
                for (int i = 0; i < this.childrenToIntersect.length; ++i) {
                    Node child = (Node)rootNode.getChild(this.childrenToIntersect[i]);
                    if (child == null) continue;
                    children.add(child);
                }
                rootNode.detachAllChildren();
                for (Node n : children) {
                    rootNode.attachChild((Spatial)n);
                }
            }
            this.startDebugTimer();
            this.getPickDistance(rays.get(0), rootNode);
            this.reportDebugTimeToSetupPicking(rays);
            for (int i = 0; i < rays.size(); ++i) {
                rawRayLengths[i] = this.getPickDistance(rays.get(i), rootNode);
            }
            this.reportDebugTimeToCastAllRays();
            return timestamp;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void reportDebugTimeToCastAllRays() {
    }

    public void reportDebugTimeToSetupPicking(List<? extends Line3DReadOnly> rays) {
    }

    public void startDebugTimer() {
        this.time = System.nanoTime();
    }

    public Future<ImmutablePair<Long, Node>> enqueueRootNodeExtracter(final TimestampProvider timestampProvider) {
        return this.application.enqueue((Callable)new Callable<ImmutablePair<Long, Node>>(){

            @Override
            public ImmutablePair<Long, Node> call() throws Exception {
                long time = System.nanoTime();
                long timestamp = timestampProvider != null ? timestampProvider.getTimestamp() : 0L;
                Node newRoot = JMEMultiRayTracer.this.rayCollisionAdapter.cloneRootNode();
                return new ImmutablePair((Object)timestamp, (Object)newRoot);
            }
        });
    }

    private double getPickDistance(Line3DReadOnly ray3d, Node rootNode) {
        this.rayCollisionAdapter.setPickingGeometry(ray3d);
        double pickDistance = this.rayCollisionAdapter.getPickDistance(rootNode);
        return pickDistance;
    }
}

