/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme.terrain;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.terrain.geomipmap.TerrainQuad;
import com.jme3.texture.Texture;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.graphicsDescription.HeightMap;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearanceTexture;
import us.ihmc.jMonkeyEngineToolkit.jme.JMEAppearanceMaterial;
import us.ihmc.jMonkeyEngineToolkit.jme.util.JMEGeometryUtils;

public class JMEHeightMapTerrain {
    private static final int GRID_SIZE_POWER_OF_TWO = 9;
    private static final int gridSize = (int)Math.pow(2.0, 9.0) + 1;
    private static final int patchSize = (int)Math.pow(2.0, 4.0) + 1;
    private String groundTexture = "Textures/gridGroundProfile.png";
    private final HeightMap heightMap;
    private final Node terrainNode = new Node("terrainNode");
    private final float xMin;
    private final float xMax;
    private final float yMin;
    private final float yMax;
    private final float width;
    private final float length;
    private final Vector3f scale = new Vector3f();
    int xLast = 0;
    int yLast = 0;

    private float getHeightAtIndex(int i) {
        float x = i / gridSize;
        float y = i % gridSize;
        float xCoordinate = this.scale.x * x + this.xMin;
        float yCoordinate = this.scale.y * y + this.yMin;
        return (float)this.heightMap.heightAt((double)xCoordinate, (double)yCoordinate, 0.0);
    }

    public JMEHeightMapTerrain(HeightMap heightMap, AssetManager assetManager) {
        this(heightMap, assetManager, null);
    }

    public JMEHeightMapTerrain(HeightMap heightMap, AssetManager assetManager, AppearanceDefinition appearance) {
        this.heightMap = heightMap;
        BoundingBox3D boundingBox = heightMap.getBoundingBox();
        this.xMin = (float)boundingBox.getMinX();
        this.xMax = (float)boundingBox.getMaxX();
        this.yMin = (float)boundingBox.getMinY();
        this.yMax = (float)boundingBox.getMaxY();
        this.width = this.xMax - this.xMin;
        this.length = this.yMax - this.yMin;
        if ((double)this.width < 1.0E-5 || (double)this.length < 1.0E-5) {
            return;
        }
        this.scale.x = this.width / (float)gridSize;
        this.scale.y = this.length / (float)gridSize;
        this.scale.z = 1.0f;
        Vector3f localScale = new Vector3f(this.scale);
        JMEGeometryUtils.transformFromZupToJMECoordinates(localScale);
        float[] floatHeightMap = new float[gridSize * gridSize];
        for (int i = 0; i < floatHeightMap.length; ++i) {
            floatHeightMap[i] = this.getHeightAtIndex(i);
        }
        TerrainQuad terrain = new TerrainQuad("JMEHeightMapTerrain", patchSize, gridSize, floatHeightMap);
        Material material = null;
        if (appearance != null) {
            if (appearance instanceof YoAppearanceTexture) {
                texture = ((YoAppearanceTexture)appearance).getPath() != null ? assetManager.loadTexture(((YoAppearanceTexture)appearance).getPath()) : JMEAppearanceMaterial.createTexture(((YoAppearanceTexture)appearance).getBufferedImage());
                material = this.loadTexture(assetManager, localScale, texture);
            } else {
                material = JMEAppearanceMaterial.createMaterial(assetManager, appearance);
            }
        } else {
            texture = assetManager.loadTexture(this.groundTexture);
            material = this.loadTexture(assetManager, localScale, texture);
        }
        terrain.setMaterial(material);
        terrain.setLocalScale(localScale);
        float xTranslation = this.width / 2.0f + this.xMin;
        float yTranslation = this.length / 2.0f + this.yMin;
        this.terrainNode.setLocalTranslation(xTranslation, yTranslation, 0.0f);
        Node rotation = new Node();
        rotation.rotate(JMEGeometryUtils.getRotationFromZupToJMECoordinates());
        this.terrainNode.attachChild((Spatial)rotation);
        rotation.attachChild((Spatial)terrain);
    }

    private Material loadTexture(AssetManager assetManager, Vector3f localScale, Texture texture) {
        Material matTerrain = new Material(assetManager, "Terrain/ScalableTextureTerrain.j3md");
        matTerrain.setBoolean("useTriPlanarMapping", true);
        texture.setWrap(Texture.WrapMode.Repeat);
        matTerrain.setTexture("Texture", texture);
        Vector2f scale = new Vector2f(localScale.x, localScale.z);
        matTerrain.setFloat("gridSize", (float)gridSize);
        matTerrain.setVector2("Scale", scale);
        return matTerrain;
    }

    public Node getTerrain() {
        return this.terrainNode;
    }
}

