/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.camera;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import javax.imageio.ImageIO;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple4D.Quaternion;

public class ScreenCapture
implements Serializable {
    private static final long serialVersionUID = 4267642643460511978L;
    private static final boolean isOpenJDK;
    private byte[] bytesOut = null;
    private final int height;
    private final int width;
    private final Point3D location;
    private final Quaternion rotation;
    private float fov;

    public ScreenCapture(BufferedImage bufferedImage, Point3D location, Quaternion rotation, float fov) {
        this.height = bufferedImage.getHeight();
        this.width = bufferedImage.getWidth();
        try {
            this.bytesOut = ScreenCapture.bufferedImageToByteArray(bufferedImage);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.rotation = rotation;
        this.location = location;
        this.fov = fov;
    }

    public Point3D getLocation() {
        return this.location;
    }

    public Quaternion getRotation() {
        return this.rotation;
    }

    public float getFov() {
        return this.fov;
    }

    public static byte[] bufferedImageToByteArray(BufferedImage image) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        if (isOpenJDK) {
            ImageIO.write((RenderedImage)image, "png", outputStream);
        } else {
            ImageIO.write((RenderedImage)image, "jpeg", outputStream);
        }
        return outputStream.toByteArray();
    }

    public static BufferedImage byteArrayToBufferedImage(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        BufferedImage bufferedImageFromConvert = null;
        try {
            bufferedImageFromConvert = ImageIO.read(inputStream);
        }
        catch (IOException e) {
            return null;
        }
        return bufferedImageFromConvert;
    }

    public BufferedImage getImage() {
        return ScreenCapture.byteArrayToBufferedImage(this.bytesOut);
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    static {
        boolean bl = isOpenJDK = System.getProperty("java.vm.name").indexOf("OpenJDK") != -1;
        if (isOpenJDK) {
            System.err.println("OpenJDK doesn't ship with JPEG libraries. Streaming using PNG images.");
        }
    }
}

