/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.camera;

import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;

public class CameraConfiguration {
    public static final double DEFAULT_FIELD_OF_VIEW = 0.7853981633974483;
    public static final double DEFAULT_CLIP_DISTANCE_NEAR = 0.1;
    public static final double DEFAULT_CLIP_DISTANCE_FAR = 1000.0;
    protected String name;
    protected String trackXVar = "q_x";
    protected String trackYVar = "q_y";
    protected String trackZVar = "q_z";
    protected String dollyXVar = "q_x";
    protected String dollyYVar = "q_y";
    protected String dollyZVar = "q_z";
    protected String fieldOfViewVar = null;
    public double fieldOfView = 0.7853981633974483;
    public double clipDistanceNear = 0.1;
    public double clipDistanceFar = 1000.0;
    protected boolean isMounted = false;
    protected String mountName = "";
    public double camX;
    public double camY;
    public double camZ;
    public double fixX;
    public double fixY;
    public double fixZ;
    public boolean isTracking = true;
    public boolean isTrackingX = true;
    public boolean isTrackingY = true;
    public boolean isTrackingZ = false;
    public boolean isDolly = false;
    public boolean isDollyX = true;
    public boolean isDollyY = true;
    public boolean isDollyZ = false;
    public double trackDX = 0.0;
    public double trackDY = 0.0;
    public double trackDZ = 0.0;
    public double dollyDX = 2.0;
    public double dollyDY = 12.0;
    public double dollyDZ = 0.0;

    public CameraConfiguration(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setCameraMount(String mountName) {
        this.isMounted = true;
        this.mountName = mountName;
    }

    public String getCameraMountName() {
        return this.mountName;
    }

    public boolean isCameraMounted() {
        return this.isMounted;
    }

    public void setCameraFieldOfViewVar(String fieldOfViewVar) {
        this.fieldOfViewVar = fieldOfViewVar;
    }

    public void setCameraFieldOfView(double fieldOfView) {
        this.fieldOfView = fieldOfView;
    }

    public void setCameraTracking(boolean track, boolean trackX, boolean trackY, boolean trackZ) {
        this.isTracking = track;
        this.isTrackingX = trackX;
        this.isTrackingY = trackY;
        this.isTrackingZ = trackZ;
    }

    public void setCameraDolly(boolean dolly, boolean dollyX, boolean dollyY, boolean dollyZ) {
        this.isDolly = dolly;
        this.isDollyX = dollyX;
        this.isDollyY = dollyY;
        this.isDollyZ = dollyZ;
    }

    public void setCameraTrackingVars(String trackXVar, String trackYVar, String trackZVar) {
        this.trackXVar = trackXVar;
        this.trackYVar = trackYVar;
        this.trackZVar = trackZVar;
    }

    public void setCameraDollyVars(String dollyXVar, String dollyYVar, String dollyZVar) {
        this.dollyXVar = dollyXVar;
        this.dollyYVar = dollyYVar;
        this.dollyZVar = dollyZVar;
    }

    public void setCameraTrackingOffsets(double trackDX, double trackDY, double trackDZ) {
        this.trackDX = trackDX;
        this.trackDY = trackDY;
        this.trackDZ = trackDZ;
    }

    public void setCameraDollyOffsets(double dollyDX, double dollyDY, double dollyDZ) {
        this.dollyDX = dollyDX;
        this.dollyDY = dollyDY;
        this.dollyDZ = dollyDZ;
    }

    public void setCameraFix(Tuple3DBasics cameraFix) {
        this.setCameraFix(cameraFix.getX(), cameraFix.getY(), cameraFix.getZ());
    }

    public void setCameraPosition(Tuple3DBasics cameraPosition) {
        this.setCameraPosition(cameraPosition.getX(), cameraPosition.getY(), cameraPosition.getZ());
    }

    public void setCameraFix(double fixX, double fixY, double fixZ) {
        this.fixX = fixX;
        this.fixY = fixY;
        this.fixZ = fixZ;
    }

    public void setCameraPosition(double camX, double camY, double camZ) {
        this.camX = camX;
        this.camY = camY;
        this.camZ = camZ;
    }

    public void setClipDistance(double near, double far) {
        this.clipDistanceNear = near;
        this.clipDistanceFar = far;
    }

    public String getTrackXVar() {
        return this.trackXVar;
    }

    public String getTrackYVar() {
        return this.trackYVar;
    }

    public String getTrackZVar() {
        return this.trackZVar;
    }

    public String getDollyXVar() {
        return this.dollyXVar;
    }

    public String getDollyYVar() {
        return this.dollyYVar;
    }

    public String getDollyZVar() {
        return this.dollyZVar;
    }

    public String getFieldOfViewVar() {
        return this.fieldOfViewVar;
    }

    public String toString() {
        return this.name;
    }
}

