/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme;

import com.jme3.app.Application;
import com.jme3.app.state.AbstractAppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.post.SceneProcessor;
import com.jme3.profile.AppProfiler;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.texture.FrameBuffer;
import com.jme3.util.BufferUtils;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.graphicsDescription.image.DepthImage;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraStreamer;
import us.ihmc.jMonkeyEngineToolkit.camera.CaptureDevice;
import us.ihmc.jMonkeyEngineToolkit.camera.RGBDStreamer;
import us.ihmc.jMonkeyEngineToolkit.jme.JMERenderer;

public class JMEFastCaptureDevice
extends AbstractAppState
implements SceneProcessor,
CaptureDevice {
    private ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(ThreadTools.getNamedThreadFactory((String)"JMEFastCaptureDevice"));
    private static final boolean USE_PBO = true;
    private static final boolean CAPTURE_IMMEDIATLY_AFTER_PREVIOUS_VIDEOFRAME = true;
    private boolean captureDepthMap = false;
    private Renderer renderer;
    private RenderManager renderManager;
    private int width;
    private int height;
    private ViewPort viewport;
    private BufferedImage bufferedImage;
    private DepthImage depthImage;
    private ByteBuffer systemRam;
    private byte[] cpuArray;
    private int bufferId;
    private int dataSize;
    private boolean captureFrame = true;
    private Object syncObject = new Object();
    private Object captureHolder = new Object();
    private CameraStreamer cameraStreamer;
    private RGBDStreamer rgbdStreamer;
    private Runnable graphicsUpdaterTimerTask;
    private final JMERenderer jmeRenderer;
    private boolean alreadyClosing = false;

    public JMEFastCaptureDevice(ViewPort viewport, JMERenderer jmeRenderer) {
        this.viewport = viewport;
        this.jmeRenderer = jmeRenderer;
    }

    public void initialize(AppStateManager stateManager, Application app) {
        if (!super.isInitialized()) {
            this.viewport.addProcessor((SceneProcessor)this);
        }
        super.initialize(stateManager, app);
    }

    public void initialize(RenderManager rm, ViewPort vp) {
        this.renderer = rm.getRenderer();
        this.renderManager = rm;
        this.reshape(vp, vp.getCamera().getWidth(), vp.getCamera().getHeight());
    }

    public boolean isInitialized() {
        return super.isInitialized() && this.renderer != null;
    }

    public synchronized void reshape(ViewPort vp, int w, int h) {
        if (w == 0 || h == 0) {
            return;
        }
        this.width = w;
        this.height = h;
        if (this.rgbdStreamer != null) {
            this.dataSize = w * h * 8;
            this.depthImage = new DepthImage(w, h);
            this.bufferedImage = null;
            this.captureDepthMap = true;
            if (Math.abs(this.viewport.getCamera().getViewPortLeft()) > 1.0E-7f || Math.abs(this.viewport.getCamera().getViewPortRight() - 1.0f) > 1.0E-7f || Math.abs(this.viewport.getCamera().getViewPortTop() - 1.0f) > 1.0E-7f || Math.abs(this.viewport.getCamera().getViewPortBottom()) > 1.0E-7f) {
                throw new RuntimeException("Camera viewport not setup correctly for depth image capture.");
            }
            if ((double)Math.abs(this.viewport.getCamera().getFrustumTop() + this.viewport.getCamera().getFrustumBottom()) > 1.0E-7 || (double)Math.abs(this.viewport.getCamera().getFrustumLeft() + this.viewport.getCamera().getFrustumRight()) > 1.0E-7) {
                throw new RuntimeException("Camera frustum not symetrical, required for depth image capture");
            }
        } else {
            this.dataSize = w * h * 4;
            this.bufferedImage = new BufferedImage(this.width, this.height, 5);
            this.depthImage = null;
            this.captureDepthMap = false;
        }
        this.systemRam = BufferUtils.createByteBuffer((int)this.dataSize);
        this.cpuArray = new byte[this.dataSize];
        IntBuffer buffer = BufferUtils.createIntBuffer((int)1);
        GL15.glGenBuffers((IntBuffer)buffer);
        this.bufferId = buffer.get(0);
        GL15.glBindBuffer((int)35051, (int)this.bufferId);
        GL15.glBufferData((int)35051, (long)this.dataSize, (int)35045);
        GL15.glBindBuffer((int)35051, (int)0);
    }

    public void preFrame(float tpf) {
    }

    public void postQueue(RenderQueue rq) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postFrame(FrameBuffer out) {
        if (this.alreadyClosing) {
            return;
        }
        Object object = this.syncObject;
        synchronized (object) {
            if (this.captureFrame) {
                Camera curCamera = this.renderManager.getCurrentCamera();
                int viewX = (int)(curCamera.getViewPortLeft() * (float)curCamera.getWidth());
                int viewY = (int)(curCamera.getViewPortBottom() * (float)curCamera.getHeight());
                int viewWidth = (int)((curCamera.getViewPortRight() - curCamera.getViewPortLeft()) * (float)curCamera.getWidth());
                int viewHeight = (int)((curCamera.getViewPortTop() - curCamera.getViewPortBottom()) * (float)curCamera.getHeight());
                this.renderer.setViewPort(0, 0, this.width, this.height);
                this.renderer.setFrameBuffer(out);
                if (out != null) {
                    FrameBuffer.RenderBuffer rb = out.getColorBuffer();
                    GL11.glReadBuffer((int)(36064 + rb.getSlot()));
                }
                GL15.glBindBuffer((int)35051, (int)this.bufferId);
                GL11.glReadPixels((int)0, (int)0, (int)this.width, (int)this.height, (int)32993, (int)5121, (long)0L);
                if (this.captureDepthMap) {
                    GL11.glReadPixels((int)0, (int)0, (int)this.width, (int)this.height, (int)6402, (int)5126, (long)(this.width * this.height * 4));
                }
                this.systemRam = GL15.glMapBuffer((int)35051, (int)35000, null);
                if (this.systemRam != null) {
                    this.systemRam.get(this.cpuArray);
                }
                GL15.glUnmapBuffer((int)35051);
                GL15.glBindBuffer((int)35051, (int)0);
                this.renderer.setFrameBuffer(null);
                this.renderer.setViewPort(viewX, viewY, viewWidth, viewHeight);
                this.captureFrame = false;
                this.syncObject.notifyAll();
            }
        }
    }

    public void cleanup() {
    }

    private boolean isStreamingRGBD() {
        return this.rgbdStreamer != null;
    }

    public void convertScreenShot() {
        if (this.alreadyClosing) {
            return;
        }
        WritableRaster wr = this.bufferedImage.getRaster();
        DataBufferByte db = (DataBufferByte)wr.getDataBuffer();
        int width = wr.getWidth();
        int height = wr.getHeight();
        byte[] imageArray = db.getData();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int upperHalfPtrAlpha = (y * width + x) * 4;
                int lowerHalfPtr = ((height - y - 1) * width + x) * 3;
                byte b1 = this.cpuArray[upperHalfPtrAlpha + 0];
                byte g1 = this.cpuArray[upperHalfPtrAlpha + 1];
                byte r1 = this.cpuArray[upperHalfPtrAlpha + 2];
                imageArray[lowerHalfPtr + 0] = b1;
                imageArray[lowerHalfPtr + 1] = g1;
                imageArray[lowerHalfPtr + 2] = r1;
            }
        }
    }

    public float getDepth(float zDepth) {
        float far = this.viewport.getCamera().getFrustumFar();
        float near = this.viewport.getCamera().getFrustumNear();
        zDepth = zDepth * 2.0f - 1.0f;
        return 2.0f * near * far / (far + near - zDepth * (far - near));
    }

    public void convertRGBD(float nearClip, float farClip) {
        if (this.alreadyClosing) {
            return;
        }
        ByteBuffer imageBuffer = ByteBuffer.wrap(this.cpuArray);
        imageBuffer.order(ByteOrder.nativeOrder());
        imageBuffer.position(this.width * this.height * 4);
        FloatBuffer depthBuffer = imageBuffer.asFloatBuffer();
        float m00 = (this.viewport.getCamera().getFrustumRight() - this.viewport.getCamera().getFrustumLeft()) / (2.0f * this.viewport.getCamera().getFrustumNear());
        float m11 = (this.viewport.getCamera().getFrustumTop() - this.viewport.getCamera().getFrustumBottom()) / (2.0f * this.viewport.getCamera().getFrustumNear());
        this.depthImage.setTransform2D(m00, m11);
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                int upperHalfPtrAlpha = (y * this.width + x) * 4;
                byte b1 = this.cpuArray[upperHalfPtrAlpha + 0];
                byte g1 = this.cpuArray[upperHalfPtrAlpha + 1];
                byte r1 = this.cpuArray[upperHalfPtrAlpha + 2];
                float rawDepth = depthBuffer.get();
                float depth = this.getDepth(rawDepth);
                if (depth < nearClip) {
                    depth = Float.NEGATIVE_INFINITY;
                } else if (depth > farClip) {
                    depth = Float.POSITIVE_INFINITY;
                }
                this.depthImage.setPoint(x, y, r1, g1, b1, depth);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage exportSnapshotAsBufferedImage() {
        this.checkIfStreaming();
        if (this.alreadyClosing) {
            return this.bufferedImage;
        }
        Object object = this.captureHolder;
        synchronized (object) {
            Object object2 = this.syncObject;
            synchronized (object2) {
                this.captureFrame = true;
                do {
                    try {
                        this.syncObject.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (this.captureFrame & !this.alreadyClosing);
            }
            this.convertScreenShot();
            return this.bufferedImage;
        }
    }

    @Override
    public void exportSnapshot(File snapshotFile) {
        BufferedImage img = this.exportSnapshotAsBufferedImage();
        try {
            ImageIO.write((RenderedImage)img, "png", snapshotFile);
        }
        catch (IOException exp) {
            System.out.println("I/O exception!" + exp.toString());
        }
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setSize(int width, int height) {
    }

    @Override
    public synchronized void streamTo(CameraStreamer cameraStreamer, int framesPerSecond) {
        this.checkIfStreaming();
        this.cameraStreamer = cameraStreamer;
        this.graphicsUpdaterTimerTask = new GraphicsUpdater();
        this.executor.scheduleAtFixedRate(this.graphicsUpdaterTimerTask, 0L, 1000000 / framesPerSecond, TimeUnit.MICROSECONDS);
    }

    private void checkIfStreaming() {
        if (this.cameraStreamer != null || this.rgbdStreamer != null) {
            throw new RuntimeException("This capture device is already streaming data");
        }
    }

    @Override
    public synchronized void streamTo(RGBDStreamer rgbdStreamer, int framesPerSecond) {
        this.checkIfStreaming();
        this.jmeRenderer.enqueue(() -> this.reshape(this.viewport, this.width, this.height));
        this.rgbdStreamer = rgbdStreamer;
        this.graphicsUpdaterTimerTask = new GraphicsUpdater();
        this.executor.scheduleAtFixedRate(this.graphicsUpdaterTimerTask, 0L, 1000000 / framesPerSecond, TimeUnit.MICROSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAndDispose() {
        if (this.alreadyClosing) {
            return;
        }
        this.alreadyClosing = true;
        Object object = this.syncObject;
        synchronized (object) {
            this.syncObject.notifyAll();
        }
        this.executor.shutdown();
        this.executor = null;
        this.renderer = null;
        this.renderManager = null;
        this.viewport = null;
        this.bufferedImage = null;
        this.systemRam = null;
        this.cpuArray = null;
        this.captureHolder = null;
        this.cameraStreamer = null;
        this.rgbdStreamer = null;
        this.depthImage = null;
    }

    public void setProfiler(AppProfiler profiler) {
    }

    private class GraphicsUpdater
    implements Runnable {
        public long timeStamp = 0L;
        public Point3DReadOnly position = new Point3D();
        public QuaternionReadOnly orientation = new Quaternion();
        public double fov = 1.5707963267948966;

        private GraphicsUpdater() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (JMEFastCaptureDevice.this.alreadyClosing) {
                return;
            }
            if (JMEFastCaptureDevice.this.cameraStreamer != null ? !JMEFastCaptureDevice.this.cameraStreamer.isReadyForNewData() : !JMEFastCaptureDevice.this.rgbdStreamer.isReadyForNewData()) {
                return;
            }
            Object object = JMEFastCaptureDevice.this.syncObject;
            synchronized (object) {
                if (JMEFastCaptureDevice.this.captureFrame) {
                    try {
                        JMEFastCaptureDevice.this.syncObject.wait();
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
            if (JMEFastCaptureDevice.this.alreadyClosing) {
                return;
            }
            if (!JMEFastCaptureDevice.this.isStreamingRGBD()) {
                JMEFastCaptureDevice.this.convertScreenShot();
                JMEFastCaptureDevice.this.cameraStreamer.updateImage(JMEFastCaptureDevice.this.bufferedImage, this.timeStamp, this.position, this.orientation, this.fov);
            } else if (JMEFastCaptureDevice.this.captureDepthMap) {
                JMEFastCaptureDevice.this.convertRGBD((float)JMEFastCaptureDevice.this.rgbdStreamer.getNearClip(), (float)JMEFastCaptureDevice.this.rgbdStreamer.getFarClip());
                JMEFastCaptureDevice.this.rgbdStreamer.updateRBGD(JMEFastCaptureDevice.this.depthImage, this.timeStamp, this.position, this.orientation, this.fov);
            }
            this.startCaptureOfVideoFrame();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startCaptureOfVideoFrame() {
            if (JMEFastCaptureDevice.this.alreadyClosing) {
                return;
            }
            Object object = JMEFastCaptureDevice.this.syncObject;
            synchronized (object) {
                JMEFastCaptureDevice.this.captureFrame = true;
                if (JMEFastCaptureDevice.this.cameraStreamer != null) {
                    this.timeStamp = JMEFastCaptureDevice.this.cameraStreamer.getTimeStamp();
                    this.position = JMEFastCaptureDevice.this.cameraStreamer.getCameraPosition();
                    this.orientation = JMEFastCaptureDevice.this.cameraStreamer.getCameraOrientation();
                    this.fov = JMEFastCaptureDevice.this.cameraStreamer.getFieldOfView();
                } else {
                    this.timeStamp = JMEFastCaptureDevice.this.rgbdStreamer.getTimeStamp();
                    this.position = JMEFastCaptureDevice.this.rgbdStreamer.getCameraPosition();
                    this.orientation = JMEFastCaptureDevice.this.rgbdStreamer.getCameraOrientation();
                    this.fov = JMEFastCaptureDevice.this.rgbdStreamer.getFieldOfView();
                }
            }
        }
    }
}

