/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.yoGraphics;

import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.util.concurrent.Callable;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.jMonkeyEngineToolkit.jme.JMERenderer;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoGraphicPointCloud
extends YoGraphic {
    private final JMERenderer jmeRenderer;
    private Graphics3DObject graphics3dObject;
    private final int capacity;
    private final Point3D[] points;
    private final Node node;
    private final Material material;
    private final Mesh mesh;
    private final Geometry geometry;
    private final FloatBuffer pointBuffer;
    private final FloatBuffer colorBuffer;
    private final FloatBuffer sizeBuffer;

    public YoGraphicPointCloud(String name, int capacity, int spriteSizePixels, ColorRGBA color, JMERenderer jmeRenderer) {
        super(name);
        int i;
        this.jmeRenderer = jmeRenderer;
        this.capacity = capacity;
        this.points = new Point3D[capacity];
        for (i = 0; i < capacity; ++i) {
            this.points[i] = new Point3D();
        }
        this.pointBuffer = BufferUtils.createFloatBuffer((int)(3 * capacity));
        for (i = 0; i < capacity; ++i) {
            this.pointBuffer.put(this.points[i].getX32());
            this.pointBuffer.put(this.points[i].getY32());
            this.pointBuffer.put(this.points[i].getZ32());
        }
        this.pointBuffer.rewind();
        this.colorBuffer = BufferUtils.createFloatBuffer((int)(4 * capacity));
        for (i = 0; i < capacity; ++i) {
            this.colorBuffer.put(color.getColorArray());
        }
        this.colorBuffer.rewind();
        int bufferSize = this.pointBuffer.limit() / 3;
        this.sizeBuffer = BufferUtils.createFloatBuffer((int)bufferSize);
        for (int i2 = 0; i2 < bufferSize; ++i2) {
            this.sizeBuffer.put(1.0f);
        }
        this.node = new Node();
        this.material = new Material(jmeRenderer.getAssetManager(), "Common/MatDefs/Misc/Particle.j3md");
        this.material.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Off);
        this.material.getAdditionalRenderState().setDepthWrite(true);
        this.material.getAdditionalRenderState().setDepthTest(true);
        this.material.setBoolean("PointSprite", true);
        this.material.setFloat("Quadratic", (float)spriteSizePixels);
        this.mesh = new Mesh();
        this.mesh.setMode(Mesh.Mode.Points);
        this.mesh.setBuffer(VertexBuffer.Type.Position, 3, this.pointBuffer);
        this.mesh.setBuffer(VertexBuffer.Type.Color, 4, this.colorBuffer);
        this.mesh.setBuffer(VertexBuffer.Type.Size, 1, this.sizeBuffer);
        this.mesh.setStatic();
        this.mesh.updateBound();
        this.geometry = new Geometry("Point Cloud", this.mesh);
        this.geometry.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        this.geometry.setQueueBucket(RenderQueue.Bucket.Opaque);
        this.geometry.setMaterial(this.material);
        this.geometry.updateModelBound();
        this.node.attachChild((Spatial)this.geometry);
        this.node.updateModelBound();
        jmeRenderer.getZUpNode().attachChild((Spatial)this.node);
        this.graphics3dObject = new Graphics3DObject();
    }

    public void update(final Point3DReadOnly[] points, final int size) {
        for (int i = 0; i < this.capacity; ++i) {
            if (i >= size) {
                this.points[i].setToNaN();
                continue;
            }
            this.points[i].set((Tuple3DReadOnly)points[i]);
        }
        this.jmeRenderer.enqueue(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                YoGraphicPointCloud.this.pointBuffer.limit(size * 3);
                YoGraphicPointCloud.this.colorBuffer.limit(size * 4);
                YoGraphicPointCloud.this.sizeBuffer.limit(size * 1);
                int j = 0;
                for (int i = 0; i < size; ++i) {
                    YoGraphicPointCloud.this.pointBuffer.put(j++, points[i].getX32());
                    YoGraphicPointCloud.this.pointBuffer.put(j++, points[i].getY32());
                    YoGraphicPointCloud.this.pointBuffer.put(j++, points[i].getZ32());
                }
                YoGraphicPointCloud.this.mesh.setBuffer(VertexBuffer.Type.Position, 3, YoGraphicPointCloud.this.pointBuffer);
                YoGraphicPointCloud.this.mesh.setBuffer(VertexBuffer.Type.Color, 4, YoGraphicPointCloud.this.colorBuffer);
                YoGraphicPointCloud.this.mesh.setBuffer(VertexBuffer.Type.Size, 1, YoGraphicPointCloud.this.sizeBuffer);
                YoGraphicPointCloud.this.mesh.updateCounts();
                YoGraphicPointCloud.this.node.updateModelBound();
                return null;
            }
        });
    }

    protected void computeRotationTranslation(AffineTransform transform3d) {
        transform3d.setIdentity();
    }

    protected boolean containsNaN() {
        return false;
    }

    public Graphics3DObject getLinkGraphics() {
        return this.graphics3dObject;
    }

    public Artifact createArtifact() {
        return null;
    }

    public YoGraphic duplicate(YoRegistry newRegistry) {
        throw new UnsupportedOperationException();
    }
}

