/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme;

import com.jme3.app.Application;
import com.jme3.asset.AssetManager;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.structure.Graphics3DNode;
import us.ihmc.graphicsDescription.structure.Graphics3DNodeType;
import us.ihmc.jMonkeyEngineToolkit.jme.JMEGraphicsObject;
import us.ihmc.jMonkeyEngineToolkit.jme.JMERayCastOpacity;
import us.ihmc.jMonkeyEngineToolkit.jme.JMEUpdatable;
import us.ihmc.jMonkeyEngineToolkit.jme.util.JMEDataTypeUtils;
import us.ihmc.tools.thread.CloseableAndDisposable;
import us.ihmc.tools.thread.CloseableAndDisposableRegistry;

public class JMEGraphics3DNode
extends Node
implements JMEUpdatable,
CloseableAndDisposable {
    private Graphics3DNode graphics3dNode;
    private static final boolean DEBUG = false;
    private QuaternionBasics rotation = new us.ihmc.euclid.tuple4D.Quaternion();
    private Vector3D translation = new Vector3D();
    private Vector3D scale = new Vector3D();
    private Quaternion jmeRotation = new Quaternion();
    private Quaternion oldJmeRotation = new Quaternion(Float.NaN, Float.NaN, Float.NaN, Float.NaN);
    private Vector3f jmeTranslation = new Vector3f();
    private Vector3f oldJmeTranslation = new Vector3f(Float.NaN, Float.NaN, Float.NaN);
    private Vector3f jmeScale = new Vector3f();
    private Vector3f oldJmeScale = new Vector3f(Float.NaN, Float.NaN, Float.NaN);
    private JMEGraphicsObject graphics;
    private Node graphicsObjectNode;
    private AssetManager assetManager;
    private Application application;

    public JMEGraphics3DNode(Graphics3DNode graphics3dNode, AssetManager assetManager, Application application, CloseableAndDisposableRegistry closeableAndDisposableRegistry) {
        super(graphics3dNode.getName());
        this.graphics3dNode = graphics3dNode;
        this.application = application;
        this.assetManager = assetManager;
        this.createAndAttachGraphicsObject();
        if (closeableAndDisposableRegistry != null) {
            closeableAndDisposableRegistry.registerCloseableAndDisposable((CloseableAndDisposable)this);
        }
    }

    private void createAndAttachGraphicsObject() {
        Graphics3DObject graphicsObject = this.graphics3dNode.getGraphicsObjectAndResetHasGraphicsObjectChanged();
        if (graphicsObject != null) {
            if (this.graphicsObjectNode != null) {
                this.detachChild((Spatial)this.graphicsObjectNode);
            }
            this.graphics = new JMEGraphicsObject(this.application, this.assetManager, graphicsObject);
            this.graphicsObjectNode = this.graphics.getNode();
            this.attachChild((Spatial)this.graphicsObjectNode);
        } else {
            this.graphics = null;
            this.graphicsObjectNode = null;
        }
    }

    @Override
    public void update() {
        if (this.graphics3dNode.getHasGraphicsObjectChanged()) {
            this.createAndAttachGraphicsObject();
        }
        AffineTransform transform = this.graphics3dNode.getTransform();
        this.rotation.set(transform.getLinearTransform().getAsQuaternion());
        this.scale.set((Tuple3DReadOnly)transform.getLinearTransform().getScaleVector());
        this.translation.set((Tuple3DReadOnly)transform.getTranslation());
        JMEDataTypeUtils.packVecMathTuple3dInJMEVector3f((Tuple3DReadOnly)this.translation, this.jmeTranslation);
        JMEDataTypeUtils.packVectMathQuat4dInJMEQuaternion((QuaternionReadOnly)this.rotation, this.jmeRotation);
        JMEDataTypeUtils.packVecMathTuple3dInJMEVector3f((Tuple3DReadOnly)this.scale, this.jmeScale);
        if (!this.oldJmeRotation.equals((Object)this.jmeRotation)) {
            this.setLocalRotation(this.jmeRotation);
            this.oldJmeRotation.set(this.jmeRotation);
        }
        if (!this.oldJmeScale.equals((Object)this.jmeScale)) {
            this.setLocalScale(this.jmeScale);
            this.oldJmeScale.set(this.jmeScale);
        }
        if (!this.oldJmeTranslation.equals((Object)this.jmeTranslation)) {
            this.setLocalTranslation(this.jmeTranslation);
            this.oldJmeTranslation.set(this.jmeTranslation);
        }
    }

    public Graphics3DNode getGraphics3DNode() {
        return this.graphics3dNode;
    }

    public static void setupNodeByType(Node jmeNode, Graphics3DNodeType nodeType) {
        switch (nodeType) {
            case TRANSFORM: {
                jmeNode.setShadowMode(RenderQueue.ShadowMode.Off);
            }
            case ROOTJOINT: 
            case JOINT: {
                jmeNode.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
                jmeNode.setUserData("RayCastOpacity", (Object)JMERayCastOpacity.OPAQUE.toString());
                break;
            }
            case VISUALIZATION: {
                jmeNode.setShadowMode(RenderQueue.ShadowMode.Off);
                jmeNode.setUserData("RayCastOpacity", (Object)JMERayCastOpacity.TRANSPARENT.toString());
                break;
            }
            case GROUND: {
                jmeNode.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
                jmeNode.setUserData("RayCastOpacity", (Object)JMERayCastOpacity.OPAQUE.toString());
            }
        }
    }

    public void setType(Graphics3DNodeType nodeType) {
        JMEGraphics3DNode.setupNodeByType(this, nodeType);
    }

    public void closeAndDispose() {
        this.graphics3dNode = null;
        this.rotation = null;
        this.translation = null;
        this.scale = null;
        this.jmeRotation = null;
        this.oldJmeRotation = null;
        this.jmeTranslation = null;
        this.oldJmeTranslation = null;
        this.jmeScale = null;
        this.oldJmeScale = null;
        this.graphics = null;
        this.graphicsObjectNode = null;
        this.assetManager = null;
        this.application = null;
    }
}

