/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme.lidar;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.scene.Node;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.AffineTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.jMonkeyEngineToolkit.GPULidar;
import us.ihmc.jMonkeyEngineToolkit.GPULidarListener;
import us.ihmc.jMonkeyEngineToolkit.jme.JMERenderer;
import us.ihmc.jMonkeyEngineToolkit.jme.lidar.LidarDistortionProcessor;
import us.ihmc.jMonkeyEngineToolkit.jme.lidar.LidarMaterial;
import us.ihmc.jMonkeyEngineToolkit.jme.lidar.LidarSceneViewPort;
import us.ihmc.jMonkeyEngineToolkit.jme.util.JMEDataTypeUtils;
import us.ihmc.jMonkeyEngineToolkit.jme.util.JMEGeometryUtils;

public class JMEGPULidar
implements GPULidar,
AppState {
    private static final Quaternion scsToJMECameraRotation = new Quaternion();
    private final int numberOfCameras;
    private final LidarSceneViewPort[] lidarSceneViewPort;
    private final LidarDistortionProcessor lidarDistortionProcessor;
    private final JMERenderer jmeRenderer;
    private final Quaternion[] cameraRotations;
    private final Vector3D j3dPosition = new Vector3D();
    private final QuaternionBasics j3dOrientation = new us.ihmc.euclid.tuple4D.Quaternion();
    private final Vector3f jmePosition = new Vector3f();
    private final Quaternion jmeOrientation = new Quaternion();
    private final Quaternion jmeCameraOrientation = new Quaternion();
    private final RigidBodyTransform lidarTransform = new RigidBodyTransform();
    private double time = Double.NaN;

    public JMEGPULidar(JMERenderer jmeRenderer, int scansPerSweep, int scanHeight, double fieldOfView, double minRange, double maxRange) {
        this.jmeRenderer = jmeRenderer;
        if (fieldOfView - 1.0E-4 <= 1.5707963267948966) {
            this.numberOfCameras = 1;
        } else if (fieldOfView - 1.0E-4 <= Math.PI) {
            this.numberOfCameras = 2;
        } else if (fieldOfView - 1.0E-4 <= 4.71238898038469) {
            this.numberOfCameras = 3;
        } else if (fieldOfView - 1.0E-4 <= Math.PI * 2) {
            this.numberOfCameras = 4;
        } else {
            throw new RuntimeException("Field of view for LIDAR can not be more than 2 pi radians.");
        }
        if (scansPerSweep != scansPerSweep / this.numberOfCameras * this.numberOfCameras) {
            throw new RuntimeException("scansPerSweep is not integer divisable by number of cameras " + this.numberOfCameras);
        }
        this.cameraRotations = JMEGPULidar.createCameraRotations(this.numberOfCameras, (float)fieldOfView);
        float startAngle = -((float)fieldOfView) / 2.0f;
        this.lidarSceneViewPort = new LidarSceneViewPort[this.numberOfCameras];
        LidarMaterial lidarMaterial = new LidarMaterial(jmeRenderer.getAssetManager());
        for (int i = 0; i < this.numberOfCameras; ++i) {
            this.lidarSceneViewPort[i] = new LidarSceneViewPort(jmeRenderer, lidarMaterial, this.numberOfCameras, scansPerSweep, scanHeight, (float)fieldOfView, (float)minRange, (float)maxRange);
        }
        this.lidarDistortionProcessor = new LidarDistortionProcessor(jmeRenderer, scansPerSweep, scanHeight, this.numberOfCameras, startAngle, (float)fieldOfView, this.lidarSceneViewPort);
        jmeRenderer.getStateManager().attach((AppState)this);
    }

    @Override
    public void addGPULidarListener(GPULidarListener listener) {
        this.lidarDistortionProcessor.addGPULidarListener(listener);
    }

    private static Quaternion[] createCameraRotations(int numberOfCameras, float fieldOfView) {
        Quaternion[] cameraRotations = new Quaternion[numberOfCameras];
        if (numberOfCameras == 1) {
            cameraRotations[0] = null;
        } else if (numberOfCameras == 2) {
            cameraRotations[0] = new Quaternion();
            cameraRotations[0].fromAngles(0.0f, fieldOfView / 4.0f, 0.0f);
            cameraRotations[1] = new Quaternion();
            cameraRotations[1].fromAngles(0.0f, -fieldOfView / 4.0f, 0.0f);
        } else if (numberOfCameras == 3) {
            cameraRotations[0] = new Quaternion();
            cameraRotations[0].fromAngles(0.0f, fieldOfView / 3.0f, 0.0f);
            cameraRotations[1] = null;
            cameraRotations[2] = new Quaternion();
            cameraRotations[2].fromAngles(0.0f, -fieldOfView / 3.0f, 0.0f);
        } else if (numberOfCameras == 4) {
            cameraRotations[0] = new Quaternion();
            cameraRotations[0].fromAngles(0.0f, 3.0f * fieldOfView / 8.0f, 0.0f);
            cameraRotations[1] = new Quaternion();
            cameraRotations[1].fromAngles(0.0f, fieldOfView / 8.0f, 0.0f);
            cameraRotations[2] = new Quaternion();
            cameraRotations[2].fromAngles(0.0f, -fieldOfView / 8.0f, 0.0f);
            cameraRotations[3] = new Quaternion();
            cameraRotations[3].fromAngles(0.0f, -3.0f * fieldOfView / 8.0f, 0.0f);
        }
        return cameraRotations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransformFromWorld(RigidBodyTransform transformFromWorld, double time) {
        RigidBodyTransform rigidBodyTransform = this.lidarTransform;
        synchronized (rigidBodyTransform) {
            this.lidarTransform.set(transformFromWorld);
            this.time = time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransformFromWorld(AffineTransform transformFromWorld, double time) {
        RigidBodyTransform rigidBodyTransform = this.lidarTransform;
        synchronized (rigidBodyTransform) {
            this.lidarTransform.set((AffineTransformReadOnly)transformFromWorld);
            this.time = time;
        }
    }

    public void updateViewPortScenes() {
        Node sceneToUse = JMERenderer.USE_GPU_LIDAR_PARALLEL_SCENE ? this.jmeRenderer.cloneSceneWithoutVisualizations() : this.jmeRenderer.getZUpNode();
        for (LidarSceneViewPort viewPort : this.lidarSceneViewPort) {
            viewPort.updateScene(sceneToUse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(float tpf) {
        RigidBodyTransform rigidBodyTransform = this.lidarTransform;
        synchronized (rigidBodyTransform) {
            this.lidarTransform.get((Orientation3DBasics)this.j3dOrientation, (Tuple3DBasics)this.j3dPosition);
            this.lidarDistortionProcessor.setTransform(this.lidarTransform, this.time);
        }
        JMEDataTypeUtils.packVecMathTuple3dInJMEVector3f((Tuple3DReadOnly)this.j3dPosition, this.jmePosition);
        JMEDataTypeUtils.packVectMathQuat4dInJMEQuaternion((QuaternionReadOnly)this.j3dOrientation, this.jmeOrientation);
        JMEGeometryUtils.transformFromZupToJMECoordinates(this.jmePosition);
        this.jmeOrientation.multLocal(scsToJMECameraRotation);
        JMEGeometryUtils.transformFromZupToJMECoordinates(this.jmeOrientation);
        for (int i = 0; i < this.numberOfCameras; ++i) {
            this.lidarSceneViewPort[i].setLocation(this.jmePosition);
            if (this.cameraRotations[i] == null) {
                this.lidarSceneViewPort[i].setRotation(this.jmeOrientation);
                continue;
            }
            this.jmeOrientation.mult(this.cameraRotations[i], this.jmeCameraOrientation);
            this.lidarSceneViewPort[i].setRotation(this.jmeCameraOrientation);
        }
    }

    public void initialize(AppStateManager stateManager, Application app) {
    }

    public boolean isInitialized() {
        return true;
    }

    public void setEnabled(boolean active) {
    }

    public boolean isEnabled() {
        return true;
    }

    public void stateAttached(AppStateManager stateManager) {
    }

    public void stateDetached(AppStateManager stateManager) {
    }

    public void render(RenderManager rm) {
    }

    public void postRender() {
    }

    public void cleanup() {
    }

    static {
        scsToJMECameraRotation.fromRotationMatrix(0.0f, 0.0f, 1.0f, -1.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f);
    }
}

