/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme.lidar;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.shape.primitives.Sphere3D;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D32;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.structure.Graphics3DNode;
import us.ihmc.graphicsDescription.structure.Graphics3DNodeType;
import us.ihmc.jMonkeyEngineToolkit.Graphics3DWorld;
import us.ihmc.jMonkeyEngineToolkit.jme.lidar.LidarTestParameters;
import us.ihmc.jMonkeyEngineToolkit.jme.lidar.LidarTestScan;
import us.ihmc.jMonkeyEngineToolkit.jme.lidar.RayTracingLidar;

public class Graphics3DLidarScan {
    private static final double SPHERE_RADIUS = 0.005;
    private Graphics3DWorld world;
    private String lidarName;
    private LidarTestParameters params;
    private AppearanceDefinition appearance;
    private Graphics3DNode[] points;
    private Graphics3DNode[] rays;

    public Graphics3DLidarScan(Graphics3DWorld world, String lidarName, LidarTestParameters params, AppearanceDefinition appearance) {
        this.world = world;
        this.lidarName = lidarName;
        this.params = params;
        this.appearance = appearance;
        this.init();
    }

    private void init() {
        if (this.params.getShowTracePoints()) {
            this.createPoints();
            this.world.addAllChildren(this.points);
        }
        if (this.params.getShowScanRays()) {
            this.createRays();
            this.world.addAllChildren(this.rays);
        }
    }

    public void update(LidarTestScan lidarScan) {
        for (int i = 0; i < lidarScan.size() && i < this.params.getScansPerSweep(); ++i) {
            if (this.params.getShowTracePoints()) {
                if ((double)lidarScan.getRange(i) < this.params.getMinRange() || (double)lidarScan.getRange(i) > this.params.getMaxRange()) {
                    this.points[i].setTransform(new AffineTransform());
                } else {
                    RigidBodyTransform pointTransform = new RigidBodyTransform();
                    Point3D p = new Point3D((double)lidarScan.getRange(i) + 0.0055000000000000005, 0.0, 0.0);
                    RigidBodyTransform transform = new RigidBodyTransform();
                    lidarScan.getInterpolatedTransform(i, transform);
                    transform.multiply((RigidBodyTransformReadOnly)RayTracingLidar.getSweepTransform(this.params, i));
                    transform.transform((Point3DBasics)p);
                    pointTransform.getTranslation().set((Tuple3DReadOnly)new Vector3D32((Tuple3DReadOnly)p));
                    this.points[i].setTransform((RigidBodyTransformReadOnly)pointTransform);
                }
            }
            if (!this.params.getShowScanRays()) continue;
            RigidBodyTransform rayTransform = new RigidBodyTransform();
            lidarScan.getInterpolatedTransform(i, rayTransform);
            rayTransform.multiply((RigidBodyTransformReadOnly)RayTracingLidar.getSweepTransform(this.params, i));
            this.rays[i].setTransform((RigidBodyTransformReadOnly)rayTransform);
        }
    }

    private void createPoints() {
        int scansPerSweep = this.params.getScansPerSweep();
        this.points = new Graphics3DNode[scansPerSweep];
        for (int i = 0; i < scansPerSweep; ++i) {
            this.points[i] = new Graphics3DNode(this.lidarName + "point" + i, Graphics3DNodeType.VISUALIZATION, new Graphics3DObject((Shape3DReadOnly)new Sphere3D(0.005), this.appearance));
        }
    }

    private void createRays() {
        int scansPerSweep = this.params.getScansPerSweep();
        this.rays = new Graphics3DNode[scansPerSweep];
        for (int i = 0; i < scansPerSweep; ++i) {
            Graphics3DObject rayObject = new Graphics3DObject();
            rayObject.rotate(1.5707963267948966, Axis3D.Y);
            rayObject.addCylinder(1.0, 5.0E-4, this.appearance);
            this.rays[i] = new Graphics3DNode(this.lidarName + "ray" + i, Graphics3DNodeType.VISUALIZATION, rayObject);
        }
    }
}

