/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.light.AmbientLight;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import us.ihmc.euclid.Axis3D;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.instructions.Graphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.primitives.Graphics3DScaleInstruction;
import us.ihmc.jMonkeyEngineToolkit.jme.JMEGraphicsObject;

public class JMEChangeAppearanceAndScaleTester
extends SimpleApplication {
    Graphics3DInstruction instruction;
    Graphics3DScaleInstruction scale;
    int counter = 0;
    private Node node;

    public void simpleInitApp() {
        Graphics3DObject graphics = new Graphics3DObject();
        graphics.setChangeable(true);
        graphics.rotate(1.5707963267948966, Axis3D.Z);
        this.scale = graphics.scale(1.0);
        this.instruction = graphics.addEllipsoid(1.0, 1.0, 1.0, YoAppearance.Red());
        JMEGraphicsObject graphicsObject = new JMEGraphicsObject((Application)this, this.assetManager, graphics);
        this.node = graphicsObject.getNode();
        this.rootNode.attachChild((Spatial)this.node);
        this.flyCam.setDragToRotate(true);
        this.setupLighting();
    }

    private DirectionalLight setupDirectionalLight(Vector3f direction) {
        DirectionalLight d2 = new DirectionalLight();
        d2.setColor(ColorRGBA.White.mult(0.6f));
        Vector3f lightDirection2 = direction.normalizeLocal();
        d2.setDirection(lightDirection2);
        return d2;
    }

    private void setupLighting() {
        DirectionalLight primaryLight = this.setupDirectionalLight(new Vector3f(-0.5f, -8.0f, -2.0f));
        this.rootNode.addLight((Light)primaryLight);
        DirectionalLight d2 = this.setupDirectionalLight(new Vector3f(1.0f, -1.0f, 1.0f));
        this.rootNode.addLight((Light)d2);
        DirectionalLight d3 = this.setupDirectionalLight(new Vector3f(1.0f, -1.0f, -1.0f));
        this.rootNode.addLight((Light)d3);
        DirectionalLight d4 = this.setupDirectionalLight(new Vector3f(-1.0f, -1.0f, 1.0f));
        this.rootNode.addLight((Light)d4);
        AmbientLight a1 = new AmbientLight();
        a1.setColor(ColorRGBA.White.mult(0.4f));
        this.rootNode.addLight((Light)a1);
    }

    public void simpleUpdate(float tpf) {
        if (this.counter % 1000 == 0) {
            this.instruction.setAppearance(YoAppearance.Yellow());
            this.scale.setScale(0.5);
        } else if (this.counter % 500 == 0) {
            this.scale.setScale(1.0);
            this.instruction.setAppearance(YoAppearance.Green());
        }
        ++this.counter;
    }

    public static void main(String[] args) {
        JMEChangeAppearanceAndScaleTester jmeChangeAppearanceTester = new JMEChangeAppearanceAndScaleTester();
        jmeChangeAppearanceTester.start();
    }
}

