/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme;

import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Sphere;
import java.time.Duration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.shape.primitives.Sphere3D;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.structure.Graphics3DNode;
import us.ihmc.jMonkeyEngineToolkit.jme.JMEGraphics3DAdapter;
import us.ihmc.jMonkeyEngineToolkit.jme.JMEGraphics3DWorld;

@Tag(value="jme")
public class JMEGraphics3DWorldTest {
    @Test
    public void testShowGui() {
        JMEGraphics3DWorld world = new JMEGraphics3DWorld("testWorld", new JMEGraphics3DAdapter());
        world.startWithGui();
        world.keepAlive(1.0);
        world.stop();
    }

    @Test
    public void testWithoutGui() {
        JMEGraphics3DWorld world = new JMEGraphics3DWorld("testWorld", new JMEGraphics3DAdapter());
        world.startWithoutGui();
        world.keepAlive(1.0);
        world.stop();
    }

    @Test
    public void addASphere() {
        JMEGraphics3DWorld world = new JMEGraphics3DWorld("testWorld", new JMEGraphics3DAdapter());
        world.addChild(new Graphics3DNode("Sphere", new Graphics3DObject((Shape3DReadOnly)new Sphere3D())));
        world.startWithGui();
        world.keepAlive(1.0);
        world.stop();
    }

    @Test
    public void addASphereAfterGuiStarted() {
        JMEGraphics3DWorld world = new JMEGraphics3DWorld("testWorld", new JMEGraphics3DAdapter());
        world.startWithGui();
        world.addChild(new Graphics3DNode("Sphere", new Graphics3DObject((Shape3DReadOnly)new Sphere3D())));
        world.keepAlive(1.0);
        world.stop();
    }

    @Test
    public void addAJMESphere() {
        JMEGraphics3DWorld world = new JMEGraphics3DWorld("testWorld", new JMEGraphics3DAdapter());
        Geometry geometry = new Geometry("jmeSphereGeo", (Mesh)new Sphere(200, 200, 5.0f, false, true));
        Material material = new Material(world.getGraphics3DAdapter().getRenderer().getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        material.setColor("Color", new ColorRGBA(0.0f, 1.0f, 0.0f, 0.5f));
        material.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        geometry.setMaterial(material);
        geometry.setQueueBucket(RenderQueue.Bucket.Transparent);
        Node jmeSphereNode = new Node("jmeSphereNode");
        jmeSphereNode.move(1.5f, 2.5f, -0.5f);
        jmeSphereNode.attachChild((Spatial)geometry);
        world.addChild(jmeSphereNode);
        world.startWithGui();
        world.keepAlive(1.0);
        world.stop();
    }

    @Test
    public void testSetCameraPosition() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(5L), () -> {
            JMEGraphics3DWorld world = new JMEGraphics3DWorld("testWorld", new JMEGraphics3DAdapter());
            world.addChild(new Graphics3DNode("Sphere", new Graphics3DObject((Shape3DReadOnly)new Sphere3D())));
            world.startWithGui();
            world.setCameraPosition(5.0, 5.0, 5.0);
            world.keepAlive(1.0);
            world.stop();
        });
    }

    @Test
    public void fixCameraOnSphere() {
        JMEGraphics3DWorld world = new JMEGraphics3DWorld("testWorld", new JMEGraphics3DAdapter());
        Graphics3DNode sphereNode = new Graphics3DNode("Sphere", new Graphics3DObject((Shape3DReadOnly)new Sphere3D()));
        world.addChild(sphereNode);
        world.startWithGui();
        world.setCameraPosition(5.0, 5.0, 5.0);
        world.fixCameraOnNode(sphereNode);
        world.keepAlive(1.0);
        world.stop();
    }
}

