/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme.lidar;

import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResult;
import com.jme3.collision.CollisionResults;
import com.jme3.math.Ray;
import java.util.ArrayList;
import us.ihmc.euclid.geometry.Line3D;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.jMonkeyEngineToolkit.Graphics3DWorld;
import us.ihmc.jMonkeyEngineToolkit.jme.JMEGraphics3DAdapter;
import us.ihmc.jMonkeyEngineToolkit.jme.lidar.LidarTestParameters;
import us.ihmc.jMonkeyEngineToolkit.jme.lidar.LidarTestScan;
import us.ihmc.jMonkeyEngineToolkit.jme.util.JMEDataTypeUtils;
import us.ihmc.jMonkeyEngineToolkit.jme.util.JMEGeometryUtils;

public class RayTracingLidar {
    private Graphics3DWorld world;
    private final LidarTestParameters params;
    private final int sensorId;
    private ArrayList<String> collisionNodeNames = new ArrayList();

    public RayTracingLidar(Graphics3DWorld world, LidarTestParameters params, int sensorId) {
        this.world = world;
        this.params = params;
        this.sensorId = sensorId;
    }

    public void addCollisionNodes(String ... collisionNodeNames) {
        for (String collisionNodeName : collisionNodeNames) {
            this.collisionNodeNames.add(collisionNodeName);
        }
    }

    public LidarTestScan scan(RigidBodyTransform lidarTransform) {
        int scansPerSweep = this.params.getScansPerSweep();
        float[] ranges = new float[scansPerSweep];
        for (int i = 0; i < scansPerSweep; ++i) {
            Ray ray = JMEGeometryUtils.transformRayFromZupToJMECoordinate((Ray)JMEDataTypeUtils.ray3dToJMERay((Line3DReadOnly)RayTracingLidar.getRay(this.params, lidarTransform, i)));
            CollisionResults masterResults = new CollisionResults();
            for (String collisionNodeName : this.collisionNodeNames) {
                CollisionResults results = new CollisionResults();
                ((JMEGraphics3DAdapter)this.world.getGraphics3DAdapter()).getRenderer().getZUpNode().getChild(collisionNodeName).collideWith((Collidable)ray, results);
                for (CollisionResult result : results) {
                    masterResults.addCollision(result);
                }
            }
            CollisionResult closestCollision = masterResults.getClosestCollision();
            ranges[i] = closestCollision != null ? closestCollision.getDistance() : 0.0f;
        }
        return new LidarTestScan(this.params, lidarTransform, lidarTransform, ranges, this.sensorId);
    }

    public static Line3D getRay(LidarTestParameters params, RigidBodyTransform currentTransform, int index) {
        Line3D ray = new Line3D(0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        RigidBodyTransform transform = new RigidBodyTransform((RigidBodyTransformReadOnly)currentTransform);
        transform.multiply((RigidBodyTransformReadOnly)RayTracingLidar.getSweepTransform(params, index));
        ray.applyTransform((Transform)transform);
        return ray;
    }

    public static RigidBodyTransform getSweepTransform(LidarTestParameters params, int i) {
        if (i >= params.getScansPerSweep() * params.getScanHeight()) {
            throw new IndexOutOfBoundsException("Index " + i + " greater than or equal to pointsPerSweep " + params.getScansPerSweep() + " * scanHeight " + params.getScanHeight());
        }
        double yawPerIndex = (params.getLidarSweepEndAngle() - params.getLidarSweepStartAngle()) / (double)(params.getScansPerSweep() - 1);
        double pitchPerIndex = (params.getLidarPitchMaxAngle() - params.getLidarPitchMinAngle()) / (double)(params.getScanHeight() - 1);
        RigidBodyTransform sweepTransform = new RigidBodyTransform();
        if (params.getScansPerSweep() > 1) {
            sweepTransform.setRotationYawAndZeroTranslation(params.getLidarSweepStartAngle() + yawPerIndex * (double)(i % params.getScansPerSweep()));
        }
        if (params.getScanHeight() > 1) {
            sweepTransform.setRotationPitchAndZeroTranslation(params.getLidarPitchMinAngle() + pitchPerIndex * (double)(i / params.getScansPerSweep()));
        }
        return sweepTransform;
    }
}

