/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme.lidar;

import java.time.Duration;
import java.util.concurrent.LinkedBlockingQueue;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import us.ihmc.jMonkeyEngineToolkit.jme.lidar.JMEGPULidarTestEnviroment;
import us.ihmc.jMonkeyEngineToolkit.jme.lidar.LidarTestListener;
import us.ihmc.jMonkeyEngineToolkit.jme.lidar.LidarTestParameters;
import us.ihmc.jMonkeyEngineToolkit.jme.lidar.LidarTestScan;
import us.ihmc.jMonkeyEngineToolkit.jme.lidar.manual.JMELidar120FovTest;
import us.ihmc.jMonkeyEngineToolkit.jme.lidar.manual.JMELidar360FovTest;
import us.ihmc.jMonkeyEngineToolkit.jme.lidar.manual.JMELidar60FovTest;
import us.ihmc.jMonkeyEngineToolkit.jme.lidar.manual.JMELidarSphere270FovTest;
import us.ihmc.robotics.Assert;

@Tag(value="jme")
public class JMEGPULidarTest
implements LidarTestListener {
    private static final boolean TEST_MANUALLY = false;
    private JMEGPULidarTestEnviroment lidarTest;
    private LidarTestParameters parameters;
    private boolean stop = false;
    private final LinkedBlockingQueue<ScanPair> scanPairs = new LinkedBlockingQueue();
    private double averageDifference = 0.0;
    private long numScans = 0L;

    @AfterEach
    public void tearDown() {
        System.out.println("Average difference: " + this.averageDifference / (double)this.numScans + " Number of Scans: " + this.numScans);
        Assert.assertTrue("Number of scans incorrect: " + this.numScans, this.numScans > 1000L);
        this.numScans = 0L;
        this.averageDifference = 0.0;
        this.lidarTest.getWorld().stop();
    }

    @Test
    public void test60DegreeFieldOfView() {
        this.parameters = new JMELidar60FovTest();
        this.doATest(this.parameters);
    }

    @Test
    public void test120DegreeFieldOfView() {
        this.parameters = new JMELidar120FovTest();
        this.doATest(this.parameters);
    }

    @Disabled
    @Test
    public void test360DegreeFieldOfView() {
        this.parameters = new JMELidar360FovTest();
        this.doATest(this.parameters);
    }

    @Disabled
    @Test
    public void test270DegreeFieldOfView() {
        this.parameters = new JMELidarSphere270FovTest();
        this.doATest(this.parameters);
    }

    private void doATest(LidarTestParameters parameters) {
        Assertions.assertTimeout((Duration)Duration.ofSeconds(30L), () -> {
            this.lidarTest = new JMEGPULidarTestEnviroment();
            this.lidarTest.testAutomatically(parameters, this);
            this.beginAssertingLidarScans();
        });
    }

    private void beginAssertingLidarScans() {
        while (!this.stop) {
            if (this.scanPairs.isEmpty()) continue;
            ScanPair pair = this.scanPairs.poll();
            Assert.assertTrue(pair.gpuScan.epsilonEquals(pair.traceScan, 1.0E-7, (float)this.parameters.getGpuVsTraceTolerance()));
            this.recordStatistics(pair.gpuScan, pair.traceScan);
        }
    }

    private void recordStatistics(LidarTestScan gpuScan, LidarTestScan traceScan) {
        for (int i = 0; i < this.parameters.getScansPerSweep(); ++i) {
            this.averageDifference += (double)(traceScan.getRange(i) - gpuScan.getRange(i));
            ++this.numScans;
        }
    }

    @Override
    public void notify(LidarTestScan gpuScan, LidarTestScan traceScan) {
        this.scanPairs.add(new ScanPair(gpuScan, traceScan));
    }

    @Override
    public void stop() {
        this.stop = true;
    }

    private class ScanPair {
        private final LidarTestScan gpuScan;
        private final LidarTestScan traceScan;

        public ScanPair(LidarTestScan gpuScan, LidarTestScan traceScan) {
            this.gpuScan = gpuScan;
            this.traceScan = traceScan;
        }
    }
}

