/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.io.resources;

import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.function.IOConsumer;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ConfigurationBuilder;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.commons.nio.BasicPathVisitor;

public class ResourceTools {
    public static InputStream openStreamAbsolute(Class<?> clazz, Path path) {
        return clazz.getClassLoader().getResourceAsStream(path.toString());
    }

    public static InputStream openStreamRelative(Class<?> clazz, Path path) {
        return clazz.getResourceAsStream(path.toString());
    }

    public static InputStream openStreamSystem(Path path) {
        return ClassLoader.getSystemResourceAsStream(path.toString());
    }

    public static URL getResourceAbsolute(Class<?> clazz, Path path) {
        return clazz.getClassLoader().getResource(path.toString());
    }

    public static URL getResourceRelative(Class<?> clazz, Path path) {
        return clazz.getResource(path.toString());
    }

    public static URL getResourceSystem(Path path) {
        return ClassLoader.getSystemResource(path.toString());
    }

    public static String readResourceToString(InputStream inputStream) {
        return (String)ExceptionTools.handle(() -> IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8), (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE);
    }

    public static String readResourceToString(URL url) {
        return (String)ExceptionTools.handle(() -> IOUtils.toString((URL)url, (Charset)StandardCharsets.UTF_8), (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE);
    }

    public static String readResourceToString(String path) {
        return ResourceTools.readResourceToString(ResourceTools.getResourceSystem(Paths.get(path, new String[0])));
    }

    public static byte[] readResourceToByteArray(String resourceAbsolutePath) {
        return (byte[])ExceptionTools.handle(() -> IOUtils.resourceToByteArray((String)resourceAbsolutePath), (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE);
    }

    public static void readResourceToByteBuffer(String resourceAbsolutePath, ByteBuffer byteBuffer) {
        try (InputStream inputStream = Object.class.getClassLoader().getResourceAsStream(resourceAbsolutePath);){
            int zeroTo255;
            while ((zeroTo255 = inputStream.read()) > -1) {
                byteBuffer.put((byte)zeroTo255);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Path getResourcesPathForClass(Class<?> clazz) {
        return Paths.get(ResourceTools.getResourcesPathStringForClass(clazz), new String[0]);
    }

    public static String getResourcesPathStringForClass(Class<?> clazz) {
        return "/" + clazz.getPackage().getName().replaceAll("\\.", "/");
    }

    public static String sanitizeResourcePath(String resourcePath) {
        Path resourcePathAsPathRaw = Paths.get(resourcePath, new String[0]);
        Path firstPart = resourcePathAsPathRaw.getName(0);
        Path normalizedAbsoluteResourceFolderPath = firstPart.resolve(firstPart.relativize(resourcePathAsPathRaw).normalize());
        return normalizedAbsoluteResourceFolderPath.toString();
    }

    public static String toResourceAccessStringWithCorrectSeparators(Path path) {
        return path.toString().replaceAll("\\\\", "/");
    }

    public static Set<String> listResources() {
        return ResourceTools.listResources("", ".*");
    }

    public static Set<String> listResources(String packagePathWithDots, String filterRegex) {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().forPackage(packagePathWithDots, new ClassLoader[0]).setScanners(new Scanner[]{Scanners.Resources}));
        Object withSlashes = packagePathWithDots.replaceAll("\\.", "/");
        if (!((String)withSlashes).isEmpty()) {
            withSlashes = (String)withSlashes + "/";
        }
        TreeSet<String> resources = new TreeSet<String>();
        for (String resource : reflections.getResources(filterRegex)) {
            if (!resource.startsWith((String)withSlashes)) continue;
            String subsequentPath = resource.replaceFirst((String)withSlashes, "");
            resources.add(subsequentPath);
        }
        return resources;
    }

    public static boolean exists(Class<?> getClassForLoading, String name) {
        return getClassForLoading.getResource(name) != null;
    }

    public static boolean exists(String name) {
        return ClassLoader.getSystemResource(name) != null;
    }

    public static void walkResourcesFlat(String pathNecessaryForResourceExploring, BiConsumer<String, BasicPathVisitor.PathType> pathVisitor) {
        TreeSet<String> fileNames = new TreeSet<String>();
        TreeSet<String> directoryNames = new TreeSet<String>();
        for (String resourceEntry : ResourceTools.listResources(pathNecessaryForResourceExploring, ".*")) {
            if (resourceEntry.contains("/")) {
                directoryNames.add(resourceEntry.substring(0, resourceEntry.indexOf("/")));
                continue;
            }
            fileNames.add(resourceEntry);
        }
        for (String fileName : fileNames) {
            pathVisitor.accept(fileName, BasicPathVisitor.PathType.FILE);
        }
        for (String directoryName : directoryNames) {
            pathVisitor.accept(directoryName, BasicPathVisitor.PathType.DIRECTORY);
        }
    }

    public static Set<ClassPath.ClassInfo> getClassInfoRecursive(Class<?> clazz, String packagePrefix) {
        try {
            return ClassPath.from((ClassLoader)clazz.getClassLoader()).getTopLevelClassesRecursive(packagePrefix);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void printClasspathSize(Class<?> clazz, String packagePrefix) {
        System.out.println("Number of classes in " + packagePrefix + ".* " + ResourceTools.getClassInfoRecursive(clazz, packagePrefix).size());
    }

    public static void processAsPath(URL resourceURL, IOConsumer<Path> processor) throws IOException {
        URI resourceURI;
        try {
            resourceURI = resourceURL.toURI();
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid Resource URL", e);
        }
        try {
            Path resourcePath = Path.of(resourceURI);
            processor.accept((Object)resourcePath);
        }
        catch (FileSystemNotFoundException fileSystemNotFoundException) {
            try (FileSystem fileSystem = FileSystems.newFileSystem(resourceURI, Collections.emptyMap());){
                Path resourcePath = fileSystem.provider().getPath(resourceURI);
                processor.accept((Object)resourcePath);
            }
        }
    }
}

