/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class DatagramOutputStream
extends OutputStream {
    private final ByteArrayOutputStream byteArrayOutputStream;
    private final DatagramSocket datagramSocketToWriteTo = new DatagramSocket();
    private final int port;
    private final InetAddress inetAddress;
    private final boolean VERBOSE = false;
    byte sendIndex = 0;

    public DatagramOutputStream(int port, String ipAddress) throws SocketException, UnknownHostException {
        this.port = port;
        this.inetAddress = InetAddress.getByName(ipAddress);
        this.byteArrayOutputStream = new ByteArrayOutputStream(32000);
    }

    @Override
    public void write(int b) throws IOException {
        this.byteArrayOutputStream.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.byteArrayOutputStream.write(b);
    }

    @Override
    public void write(byte[] b, int offset, int length) {
        this.byteArrayOutputStream.write(b, offset, length);
    }

    @Override
    public void flush() {
        this.byteArrayOutputStream.write(this.sendIndex);
        this.sendIndex = (byte)(this.sendIndex + 1);
        byte[] byteArray = this.byteArrayOutputStream.toByteArray();
        DatagramPacket datagramPacket = new DatagramPacket(byteArray, byteArray.length, this.inetAddress, this.port);
        try {
            this.datagramSocketToWriteTo.send(datagramPacket);
        }
        catch (IOException e) {
            System.err.println("IOException in DatagramOutputStream.flush()");
        }
        this.byteArrayOutputStream.reset();
    }

    @Override
    public void close() {
        if (this.datagramSocketToWriteTo != null) {
            this.datagramSocketToWriteTo.close();
        }
    }
}

