/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.inputDevices.joystick.mapping;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.List;
import net.java.games.input.Component;
import net.java.games.input.Event;
import org.apache.commons.lang3.SystemUtils;
import us.ihmc.tools.inputDevices.joystick.JoystickCompatibilityFilter;
import us.ihmc.tools.inputDevices.joystick.mapping.JoystickMapping;

public enum LogitechExtreme3DMapping implements JoystickMapping
{
    TRIGGER,
    THROTTLE,
    HAT,
    STICK_ROLL,
    STICK_PITCH,
    STICK_YAW,
    BUTTON_2,
    BUTTON_3,
    BUTTON_4,
    BUTTON_5,
    BUTTON_6,
    BUTTON_7,
    BUTTON_8,
    BUTTON_9,
    BUTTON_10,
    BUTTON_11,
    BUTTON_12;

    public static final LogitechExtreme3DMapping[] values;
    private static final BiMap<Component.Identifier, LogitechExtreme3DMapping> windowsBiMap;
    private static final BiMap<Component.Identifier, LogitechExtreme3DMapping> macBiMap;
    private static final BiMap<Component.Identifier, LogitechExtreme3DMapping> linuxBiMap;

    private static void mapValues(LogitechExtreme3DMapping mapping, Component.Identifier windowsIdentifier, Component.Identifier macIdentifier, Component.Identifier linuxIdentifier) {
        windowsBiMap.put((Object)windowsIdentifier, (Object)mapping);
        macBiMap.put((Object)macIdentifier, (Object)mapping);
        linuxBiMap.put((Object)linuxIdentifier, (Object)mapping);
    }

    public static List<JoystickCompatibilityFilter> getCompatibilityFilters() {
        ArrayList<JoystickCompatibilityFilter> compatibilityFilters = new ArrayList<JoystickCompatibilityFilter>();
        return compatibilityFilters;
    }

    @Override
    public Component.Identifier getIdentifier() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return (Component.Identifier)windowsBiMap.inverse().get((Object)this);
        }
        if (SystemUtils.IS_OS_MAC) {
            return (Component.Identifier)macBiMap.inverse().get((Object)this);
        }
        if (SystemUtils.IS_OS_LINUX) {
            return (Component.Identifier)linuxBiMap.inverse().get((Object)this);
        }
        return null;
    }

    public static LogitechExtreme3DMapping getMapping(Component.Identifier identifier) {
        if (SystemUtils.IS_OS_WINDOWS) {
            return (LogitechExtreme3DMapping)windowsBiMap.get((Object)identifier);
        }
        if (SystemUtils.IS_OS_MAC) {
            return (LogitechExtreme3DMapping)macBiMap.get((Object)identifier);
        }
        if (SystemUtils.IS_OS_LINUX) {
            return (LogitechExtreme3DMapping)linuxBiMap.get((Object)identifier);
        }
        return null;
    }

    private static LogitechExtreme3DMapping getMapping(Component component) {
        return LogitechExtreme3DMapping.getMapping(component.getIdentifier());
    }

    public static LogitechExtreme3DMapping getMapping(Event event) {
        return LogitechExtreme3DMapping.getMapping(event.getComponent());
    }

    static {
        values = LogitechExtreme3DMapping.values();
        windowsBiMap = HashBiMap.create((int)values.length);
        macBiMap = HashBiMap.create((int)values.length);
        linuxBiMap = HashBiMap.create((int)values.length);
        LogitechExtreme3DMapping.mapValues(TRIGGER, (Component.Identifier)Component.Identifier.Button._0, (Component.Identifier)Component.Identifier.Button._0, (Component.Identifier)Component.Identifier.Button.TRIGGER);
        LogitechExtreme3DMapping.mapValues(THROTTLE, (Component.Identifier)Component.Identifier.Axis.SLIDER, (Component.Identifier)Component.Identifier.Axis.SLIDER, (Component.Identifier)Component.Identifier.Axis.SLIDER);
        LogitechExtreme3DMapping.mapValues(HAT, (Component.Identifier)Component.Identifier.Axis.POV, (Component.Identifier)Component.Identifier.Axis.POV, (Component.Identifier)Component.Identifier.Axis.POV);
        LogitechExtreme3DMapping.mapValues(STICK_ROLL, (Component.Identifier)Component.Identifier.Axis.X, (Component.Identifier)Component.Identifier.Axis.X, (Component.Identifier)Component.Identifier.Axis.X);
        LogitechExtreme3DMapping.mapValues(STICK_PITCH, (Component.Identifier)Component.Identifier.Axis.Y, (Component.Identifier)Component.Identifier.Axis.Y, (Component.Identifier)Component.Identifier.Axis.Y);
        LogitechExtreme3DMapping.mapValues(STICK_YAW, (Component.Identifier)Component.Identifier.Axis.RZ, (Component.Identifier)Component.Identifier.Axis.RZ, (Component.Identifier)Component.Identifier.Axis.RZ);
        LogitechExtreme3DMapping.mapValues(BUTTON_2, (Component.Identifier)Component.Identifier.Button._1, (Component.Identifier)Component.Identifier.Button._1, (Component.Identifier)Component.Identifier.Button.THUMB);
        LogitechExtreme3DMapping.mapValues(BUTTON_3, (Component.Identifier)Component.Identifier.Button._2, (Component.Identifier)Component.Identifier.Button._2, (Component.Identifier)Component.Identifier.Button.THUMB2);
        LogitechExtreme3DMapping.mapValues(BUTTON_4, (Component.Identifier)Component.Identifier.Button._3, (Component.Identifier)Component.Identifier.Button._3, (Component.Identifier)Component.Identifier.Button.TOP);
        LogitechExtreme3DMapping.mapValues(BUTTON_5, (Component.Identifier)Component.Identifier.Button._4, (Component.Identifier)Component.Identifier.Button._4, (Component.Identifier)Component.Identifier.Button.TOP2);
        LogitechExtreme3DMapping.mapValues(BUTTON_6, (Component.Identifier)Component.Identifier.Button._5, (Component.Identifier)Component.Identifier.Button._5, (Component.Identifier)Component.Identifier.Button.PINKIE);
        LogitechExtreme3DMapping.mapValues(BUTTON_7, (Component.Identifier)Component.Identifier.Button._6, (Component.Identifier)Component.Identifier.Button._6, (Component.Identifier)Component.Identifier.Button.BASE);
        LogitechExtreme3DMapping.mapValues(BUTTON_8, (Component.Identifier)Component.Identifier.Button._7, (Component.Identifier)Component.Identifier.Button._7, (Component.Identifier)Component.Identifier.Button.BASE2);
        LogitechExtreme3DMapping.mapValues(BUTTON_9, (Component.Identifier)Component.Identifier.Button._8, (Component.Identifier)Component.Identifier.Button._8, (Component.Identifier)Component.Identifier.Button.BASE3);
        LogitechExtreme3DMapping.mapValues(BUTTON_10, (Component.Identifier)Component.Identifier.Button._9, (Component.Identifier)Component.Identifier.Button._9, (Component.Identifier)Component.Identifier.Button.BASE4);
        LogitechExtreme3DMapping.mapValues(BUTTON_11, (Component.Identifier)Component.Identifier.Button._10, (Component.Identifier)Component.Identifier.Button._10, (Component.Identifier)Component.Identifier.Button.BASE5);
        LogitechExtreme3DMapping.mapValues(BUTTON_12, (Component.Identifier)Component.Identifier.Button._11, (Component.Identifier)Component.Identifier.Button._11, (Component.Identifier)Component.Identifier.Button.BASE6);
    }
}

