/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.processManagement;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Version;
import us.ihmc.tools.processManagement.JavaProcessSpawner;

public class FuzzyStringClassLauncher {
    private HashMap<String, Class<?>> classList = new HashMap();
    private JFrame frame;
    private JPanel searchPanel;
    private JPanel resultsPanel;
    private JTextField searchField = new JTextField();
    private QueryParser queryParser;
    private IndexSearcher searcher;
    private TopScoreDocCollector collector;
    private String name;
    private ImageIcon javaIcon = new ImageIcon(FuzzyStringClassLauncher.class.getClassLoader().getResource("java.png"));

    public FuzzyStringClassLauncher(String name) {
        this.name = name;
        System.out.println("Indexing classes...");
        this.initClassList();
        System.out.println("Indexing complete.");
        try {
            this.initLucene();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void start() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FuzzyStringClassLauncher.this.setupJFrame();
            }
        });
    }

    private void setupJFrame() {
        this.frame = new JFrame(this.name);
        this.searchPanel = new JPanel(new GridBagLayout());
        this.searchPanel.setBorder(BorderFactory.createEmptyBorder());
        GridBagConstraints c = new GridBagConstraints();
        Insets oldInsets = c.insets;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 19;
        c.ipadx = 500;
        c.weightx = 0.0;
        c.insets = new Insets(30, 30, 30, 30);
        c.fill = 2;
        this.searchField = new JTextField();
        this.searchField.setColumns(5);
        this.setupSearchFieldListener();
        this.searchPanel.add((Component)this.searchField, c);
        c.insets = oldInsets;
        this.resultsPanel = new JPanel(new GridBagLayout());
        this.resultsPanel.setBorder(BorderFactory.createEmptyBorder());
        this.resultsPanel.setVisible(false);
        this.frame.getContentPane().setLayout(new BoxLayout(this.frame.getContentPane(), 1));
        this.frame.getContentPane().add(this.searchPanel);
        this.frame.getContentPane().add(this.resultsPanel);
        SystemTray tray = SystemTray.getSystemTray();
        TrayIcon icon = new TrayIcon(this.javaIcon.getImage());
        final JPopupMenu menu = new JPopupMenu("Fuzzy String Class Launcher");
        JMenuItem item = new JMenuItem("Quit");
        menu.add(item);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        icon.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(final MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    menu.setLocation(e.getX(), 0);
                    menu.setInvoker(menu);
                    menu.setVisible(true);
                } else if (SwingUtilities.isLeftMouseButton(e)) {
                    if (FuzzyStringClassLauncher.this.frame.isVisible()) {
                        FuzzyStringClassLauncher.this.searchField.setText("");
                        FuzzyStringClassLauncher.this.frame.setVisible(false);
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                FuzzyStringClassLauncher.this.frame.setLocation(e.getX() - FuzzyStringClassLauncher.this.frame.getWidth() / 2, 10);
                                FuzzyStringClassLauncher.this.frame.setVisible(true);
                            }
                        });
                    }
                }
            }
        });
        try {
            tray.add(icon);
        }
        catch (AWTException e1) {
            e1.printStackTrace();
        }
        this.frame.setUndecorated(true);
        this.frame.pack();
        this.frame.setResizable(false);
        this.frame.setDefaultCloseOperation(1);
        this.frame.setLocationRelativeTo(null);
        this.frame.setAlwaysOnTop(true);
    }

    private void setupSearchFieldListener() {
        this.searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (FuzzyStringClassLauncher.this.searchField.getText().length() == 0) {
                    FuzzyStringClassLauncher.this.disposeSearchResults();
                } else {
                    FuzzyStringClassLauncher.this.updateSearchResults();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (FuzzyStringClassLauncher.this.searchField.getText().length() == 0) {
                    FuzzyStringClassLauncher.this.disposeSearchResults();
                } else {
                    FuzzyStringClassLauncher.this.updateSearchResults();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (FuzzyStringClassLauncher.this.searchField.getText().length() == 0) {
                    FuzzyStringClassLauncher.this.disposeSearchResults();
                } else {
                    FuzzyStringClassLauncher.this.updateSearchResults();
                }
            }
        });
    }

    private void initClassList() {
        ArrayList<File> dirs = new ArrayList<File>();
        ArrayList<String> allClasses = new ArrayList<String>();
        try {
            this.getSubdirsFromRoots(dirs);
            this.getAllClasses(dirs, allClasses);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.populateMainClassListFromClasses(allClasses);
    }

    private void populateMainClassListFromClasses(ArrayList<String> allClasses) {
        for (String s : allClasses) {
            try {
                Class<?> clazz = Class.forName(s, false, this.getClass().getClassLoader());
                for (Method m : clazz.getMethods()) {
                    if (!m.getName().equals("main")) continue;
                    this.classList.put(clazz.getSimpleName(), clazz);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private void getAllClasses(ArrayList<File> dirs, ArrayList<String> classList) throws IOException {
        String binString = "bin" + File.separator;
        String classesString = "classes" + File.separator;
        String mainString = "main" + File.separator;
        String testString = "test" + File.separator;
        for (File dir : dirs) {
            for (File f : dir.listFiles()) {
                String fileName = f.getCanonicalFile().getAbsolutePath();
                if (fileName.contains(binString)) {
                    fileName = fileName.substring(fileName.indexOf(binString) + binString.length());
                }
                if (fileName.contains(classesString)) {
                    fileName = fileName.substring(fileName.indexOf(classesString) + classesString.length());
                }
                if (fileName.startsWith(mainString)) {
                    fileName = fileName.substring(fileName.indexOf(mainString) + mainString.length());
                } else if (fileName.startsWith(testString)) {
                    fileName = fileName.substring(fileName.indexOf(testString) + testString.length());
                }
                fileName = fileName.replace(File.separator, ".");
                if (f.isDirectory() || fileName.contains("$") || !fileName.endsWith(".class")) continue;
                classList.add(fileName.substring(0, fileName.indexOf(".class")));
            }
        }
    }

    private void getSubdirsFromRoots(ArrayList<File> dirs) throws IOException {
        Enumeration<URL> roots = this.getClass().getClassLoader().getResources("");
        while (roots.hasMoreElements()) {
            String nextPath = roots.nextElement().getPath();
            dirs.add(new File(nextPath));
            this.getAllSubDirs(nextPath, dirs);
        }
    }

    private void getAllSubDirs(String path, ArrayList<File> dirs) throws IOException {
        File root = null;
        root = new File(path).getCanonicalFile();
        for (File f : root.listFiles()) {
            if (!f.isDirectory()) continue;
            dirs.add(f);
            this.getAllSubDirs(f.getCanonicalPath(), dirs);
        }
    }

    private void initLucene() throws IOException {
        StandardAnalyzer analyzer = new StandardAnalyzer(Version.LUCENE_43);
        RAMDirectory index = new RAMDirectory();
        IndexWriterConfig config = new IndexWriterConfig(Version.LUCENE_43, (Analyzer)analyzer);
        IndexWriter writer = new IndexWriter((Directory)index, config);
        for (String s : this.classList.keySet()) {
            Document doc = new Document();
            doc.add((IndexableField)new TextField("classname", s, Field.Store.YES));
            writer.addDocument((Iterable)doc);
        }
        writer.close();
        this.queryParser = new QueryParser(Version.LUCENE_43, "classname", (Analyzer)analyzer);
        this.searcher = new IndexSearcher((IndexReader)DirectoryReader.open((Directory)index));
    }

    private void updateSearchResults() {
        this.collector = TopScoreDocCollector.create((int)15, (boolean)true);
        this.resultsPanel.removeAll();
        final JTree tree = new JTree(new DefaultMutableTreeNode());
        tree.setRowHeight(0);
        tree.setCellRenderer(new DefaultTreeCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                label.setBorder(BorderFactory.createEmptyBorder(row == 1 ? 0 : 10, 10, 10, 20));
                return label;
            }
        });
        tree.setShowsRootHandles(false);
        ((DefaultTreeCellRenderer)tree.getCellRenderer()).setOpenIcon(null);
        ((DefaultTreeCellRenderer)tree.getCellRenderer()).setClosedIcon(null);
        ((DefaultTreeCellRenderer)tree.getCellRenderer()).setLeafIcon(this.javaIcon);
        tree.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                String str;
                if (e.getClickCount() > 1 && (str = tree.getSelectionPath().getLastPathComponent().toString()) != null && !str.toLowerCase().contains("no results")) {
                    str = str.substring(str.indexOf("\">") + 2, str.indexOf("</"));
                    new JavaProcessSpawner(false, true).spawn(FuzzyStringClassLauncher.this.classList.get(str), new String[]{"-Xms2048m", "-Xmx2048m"}, null);
                }
            }
        });
        try {
            ScoreDoc[] hits;
            String searchString = this.searchField.getText().substring(0, 1) + this.searchField.getText().substring(1, this.searchField.getText().length()).replace("", "*");
            Query q = this.queryParser.parse(searchString + "~");
            this.searcher.search(q, (Collector)this.collector);
            for (ScoreDoc hit : hits = this.collector.topDocs().scoreDocs) {
                Document d = this.searcher.doc(hit.doc);
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode("<html><body><span style=\"font-weight:bold;font-size:1.2em;\">" + d.get("classname") + "</span></body></html>");
                ((DefaultMutableTreeNode)tree.getModel().getRoot()).add(newNode);
            }
            if (hits.length == 0) {
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode("<html><body><span style=\"font-weight:bold;font-size:1.2em;\">No Results</span></body></html>");
                ((DefaultMutableTreeNode)tree.getModel().getRoot()).add(newNode);
            }
            GridBagConstraints c = new GridBagConstraints();
            tree.setBorder(BorderFactory.createEtchedBorder());
            tree.expandRow(0);
            c.insets = new Insets(10, 10, 10, 10);
            c.fill = 1;
            c.weightx = 1.0;
            this.resultsPanel.add((Component)tree, c);
            this.resultsPanel.validate();
            this.resultsPanel.repaint();
            this.resultsPanel.setVisible(true);
            this.frame.pack();
            this.frame.validate();
            this.frame.repaint();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void disposeSearchResults() {
        this.resultsPanel.setVisible(false);
        this.frame.pack();
        this.frame.validate();
    }
}

