/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.io;

import java.nio.file.Path;
import javax.annotation.Nullable;
import us.ihmc.commons.nio.PathTools;
import us.ihmc.log.LogTools;
import us.ihmc.tools.io.WorkspaceFile;
import us.ihmc.tools.io.WorkspacePathTools;

public class WorkspaceDirectory {
    @Nullable
    protected Path filesystemDirectory;

    protected WorkspaceDirectory() {
    }

    public WorkspaceDirectory(String directoryNameToAssumePresent) {
        Path path = PathTools.findDirectoryInline((String)directoryNameToAssumePresent);
        this.filesystemDirectory = path == null ? null : path.toAbsolutePath();
    }

    public WorkspaceDirectory(String directoryNameToAssumePresent, String subsequentPath) {
        Path path = WorkspacePathTools.findPath(directoryNameToAssumePresent, subsequentPath);
        this.filesystemDirectory = path == null ? null : path.toAbsolutePath();
    }

    public WorkspaceDirectory(Class<?> classForFindingSourceSetDirectory) {
        this.setFilesystemDirectoryToSourceSetDirectory(classForFindingSourceSetDirectory);
    }

    public WorkspaceDirectory(Class<?> classForFindingSourceSetDirectory, String subsequentPath) {
        this.setFilesystemDirectoryToSourceSetDirectory(classForFindingSourceSetDirectory, subsequentPath);
    }

    public WorkspaceDirectory(Path filesystemDirectory) {
        this.filesystemDirectory = filesystemDirectory.toAbsolutePath();
    }

    protected void setFilesystemDirectoryToSourceSetDirectory(Class<?> classForFindingSourceSetDirectory) {
        Path path = WorkspacePathTools.inferFilesystemSourceSetDirectory(classForFindingSourceSetDirectory);
        this.filesystemDirectory = path == null ? null : path.toAbsolutePath();
    }

    protected void setFilesystemDirectoryToSourceSetDirectory(Class<?> classForFindingSourceSetDirectory, String subsequentPath) {
        this.setFilesystemDirectoryToSourceSetDirectory(classForFindingSourceSetDirectory);
        if (this.filesystemDirectory != null) {
            this.filesystemDirectory = this.filesystemDirectory.resolve(subsequentPath).toAbsolutePath();
        }
    }

    public boolean isFileAccessAvailable() {
        return this.filesystemDirectory != null;
    }

    public Path getFilesystemDirectory() {
        return this.filesystemDirectory;
    }

    public WorkspaceFile file(String subsequentPathToFile) {
        return new WorkspaceFile(this, subsequentPathToFile);
    }

    public WorkspaceDirectory resolve(String subdirectory) {
        if (this.isFileAccessAvailable()) {
            return new WorkspaceDirectory(this.filesystemDirectory.resolve(subdirectory));
        }
        return new WorkspaceDirectory((Path)null);
    }

    public static void main(String[] args) {
        WorkspaceDirectory workspaceDirectory = new WorkspaceDirectory("ihmc-open-robotics-software", "ihmc-java-toolkit/src");
        WorkspaceDirectory.printTestInfo(workspaceDirectory);
    }

    private static void printTestInfo(WorkspaceDirectory workspaceDirectory) {
        LogTools.info((String)"File access available: {}", (Object)(workspaceDirectory.isFileAccessAvailable() ? "Yes" : "No"));
        if (workspaceDirectory.isFileAccessAvailable()) {
            Path directoryPath = workspaceDirectory.getFilesystemDirectory();
            LogTools.info((String)"Directory path: {}", (Object)directoryPath);
        }
    }
}

